/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageClientRequest {
    private final Type type;

    public MessageClientRequest(PacketBuffer buffer) {
        this.type = Type.TYPES[buffer.readByte()];
    }

    public MessageClientRequest(Type type) {
        this.type = type;
    }

    public void encode(PacketBuffer buf) {
        buf.writeByte(this.type.ordinal());
    }

    public static class Handler {
        public static void onMessage(MessageClientRequest message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            EntityPlayerMP player = CommonUtils.checkServer(ctx);
            if (message.type == Type.TUTORIAL_COMPLETE) {
                CapProvider.tutorialDone.add(player.func_200200_C_().getString());
                ctx.enqueueWork(() -> {
                    CommonUtils.getDamageModel((EntityPlayer)player).hasTutorial = true;
                });
            } else if (message.type == Type.REQUEST_REFRESH) {
                ctx.enqueueWork(() -> FirstAid.NETWORKING.sendTo((Object)new MessageSyncDamageModel(CommonUtils.getDamageModel((EntityPlayer)player)), player.field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT));
            }
        }
    }

    public static enum Type {
        TUTORIAL_COMPLETE,
        REQUEST_REFRESH;

        private static final Type[] TYPES;

        static {
            TYPES = Type.values();
        }
    }
}

