/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.client.ClientHooks;
import ichttt.mods.firstaid.client.HUDHandler;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageConfiguration {
    private NBTTagCompound playerDamageModel;

    public MessageConfiguration(NBTTagCompound model) {
        this.playerDamageModel = model;
    }

    public MessageConfiguration(PacketBuffer buffer) {
        this(buffer.func_150793_b());
    }

    public void encode(PacketBuffer buf) {
        buf.func_150786_a(this.playerDamageModel);
    }

    public static class Handler {
        public static void onMessage(MessageConfiguration message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            CommonUtils.checkClient(ctx);
            FirstAid.LOGGER.info("Received remote damage model");
            ctx.enqueueWork(() -> {
                AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                damageModel.deserializeNBT((INBTBase)message.playerDamageModel);
                if (damageModel.hasTutorial) {
                    CapProvider.tutorialDone.add(Minecraft.func_71410_x().field_71439_g.func_200200_C_().getString());
                } else {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("[First Aid] " + I18n.func_135052_a((String)"firstaid.tutorial.hint", (Object[])new Object[]{ClientHooks.showWounds.getKey().func_197936_a()})));
                }
                HUDHandler.INSTANCE.ticker = 200;
                FirstAid.isSynced = true;
            });
        }
    }
}

