/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.client.DebuffTimedSound;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MessagePlayHurtSound {
    private final SoundEvent sound;
    private final int duration;

    public MessagePlayHurtSound(PacketBuffer buffer) {
        this((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buffer.func_192575_l()), buffer.readInt());
    }

    public MessagePlayHurtSound(SoundEvent sound, int duration) {
        this.sound = sound;
        this.duration = duration;
    }

    public void encode(PacketBuffer buf) {
        buf.func_192572_a(this.sound.func_187503_a());
        buf.writeInt(this.duration);
    }

    public static class Handler {
        public static void onMessage(MessagePlayHurtSound message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            CommonUtils.checkClient(ctx);
            ctx.enqueueWork(() -> DebuffTimedSound.playHurtSound(message.sound, message.duration));
        }
    }
}

