/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageReceiveDamage {
    private final EnumPlayerPart part;
    private final float damageAmount;
    private final float minHealth;

    public MessageReceiveDamage(PacketBuffer buffer) {
        this(EnumPlayerPart.fromID(buffer.readByte()), buffer.readFloat(), buffer.readFloat());
    }

    public MessageReceiveDamage(EnumPlayerPart part, float damageAmount, float minHealth) {
        this.part = part;
        this.damageAmount = damageAmount;
        this.minHealth = minHealth;
    }

    public void encode(PacketBuffer buf) {
        buf.writeByte((int)this.part.id);
        buf.writeFloat(this.damageAmount);
        buf.writeFloat(this.minHealth);
    }

    public static class Handler {
        public static void onMessage(MessageReceiveDamage message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            CommonUtils.checkClient(ctx);
            ctx.enqueueWork(() -> {
                AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                AbstractDamageablePart part = damageModel.getFromEnum(message.part);
                if (message.damageAmount > 0.0f) {
                    part.damage(message.damageAmount, null, false, message.minHealth);
                } else if (message.damageAmount < 0.0f) {
                    part.heal(-message.damageAmount, null, false);
                }
            });
        }
    }
}

