/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import com.google.common.collect.Iterators;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;

public class ArmorUtils {
    private static float getArmorModifier(EntityEquipmentSlot slot) {
        switch (slot) {
            case CHEST: {
                return 2.5f;
            }
            case LEGS: {
                return 3.0f;
            }
            case FEET: 
            case HEAD: {
                return 6.5f;
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    private static float getThougnessMofier(EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.CHEST || slot == EntityEquipmentSlot.LEGS ? 3 : 4;
    }

    public static float applyArmor(@Nonnull EntityPlayer entity, @Nonnull ItemStack itemStack, @Nonnull DamageSource source, float damage, @Nonnull EntityEquipmentSlot slot) {
        if (itemStack.func_190926_b() || source.func_76363_c()) {
            return damage;
        }
        Item item = itemStack.func_77973_b();
        if (!(item instanceof ItemArmor)) {
            return damage;
        }
        ItemArmor armor = (ItemArmor)item;
        float totalArmor = (float)armor.func_200881_e() * ArmorUtils.getArmorModifier(slot);
        float totalToughness = armor.getToughness() * ArmorUtils.getThougnessMofier(slot);
        itemStack.func_77972_a((int)damage, (EntityLivingBase)entity);
        damage = CombatRules.func_189427_a((float)damage, (float)totalArmor, (float)totalToughness);
        return damage;
    }

    public static float applyGlobalPotionModifiers(EntityPlayer player, DamageSource source, float damage) {
        if (source.func_151517_h()) {
            return damage;
        }
        if (player.func_70644_a(MobEffects.field_76429_m) && source != DamageSource.field_76380_i) {
            int i = (player.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
            int j = 25 - i;
            float f = damage * (float)j;
            damage = f / 25.0f;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        return damage;
    }

    public static float applyEnchantmentModifiers(ItemStack stack, DamageSource source, float damage) {
        int k = EnchantmentHelper.func_77508_a(() -> Iterators.singletonIterator((Object)stack), (DamageSource)source);
        if ((k *= 4) > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }
}

