/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.DataManagerWrapper;
import ichttt.mods.firstaid.common.damagesystem.distribution.HealthDistribution;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class CommonUtils {
    @Nonnull
    public static final EntityEquipmentSlot[] ARMOR_SLOTS = new EntityEquipmentSlot[4];
    @Nonnull
    public static final ImmutableMap<EntityEquipmentSlot, List<EnumPlayerPart>> slotToParts;

    public static void killPlayer(@Nonnull EntityPlayer player, @Nullable DamageSource source) {
        if (source != null && ((Boolean)FirstAidConfig.SERVER.allowOtherHealingItems.get()).booleanValue() && player.func_190628_d(source)) {
            return;
        }
        ((DataManagerWrapper)player.field_70180_af).set_impl(EntityPlayer.field_184632_c, Float.valueOf(0.0f));
    }

    public static boolean isValidArmorSlot(EntityEquipmentSlot slot) {
        return slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR;
    }

    public static boolean isSurvivalOrAdventure(EntityPlayer player) {
        return !player.func_175149_v() && !player.func_184812_l_();
    }

    public static String getActiveModidSafe() {
        ModContainer activeModContainer = ModLoadingContext.get().getActiveContainer();
        return activeModContainer == null ? "UNKNOWN-NULL" : activeModContainer.getModId();
    }

    public static void healPlayerByPercentage(double percentage, AbstractPlayerDamageModel damageModel, EntityPlayer player) {
        Objects.requireNonNull(damageModel);
        int healValue = Ints.checkedCast((long)Math.round((double)damageModel.getCurrentMaxHealth() * percentage));
        HealthDistribution.manageHealth(healValue, damageModel, player, true, false);
    }

    public static void debugLogStacktrace(String name) {
        if (!FirstAidConfig.debug) {
            return;
        }
        try {
            throw new RuntimeException("DEBUG:" + name);
        }
        catch (RuntimeException e) {
            FirstAid.LOGGER.info("DEBUG: " + name, (Throwable)e);
            return;
        }
    }

    @Nonnull
    public static AbstractPlayerDamageModel getDamageModel(EntityPlayer player) {
        return (AbstractPlayerDamageModel)player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null).orElseThrow(() -> new IllegalArgumentException("Player " + player.func_200200_C_() + " is missing a damage model!"));
    }

    public static boolean hasDamageModel(Entity entity) {
        return entity instanceof EntityPlayer && !(entity instanceof FakePlayer);
    }

    @Nonnull
    public static EntityPlayerMP checkServer(NetworkEvent.Context context) {
        if (context.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            throw new IllegalArgumentException("Wrong side for server packet handler " + context.getDirection());
        }
        context.setPacketHandled(true);
        return Objects.requireNonNull(context.getSender());
    }

    public static void checkClient(NetworkEvent.Context context) {
        if (context.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            throw new IllegalArgumentException("Wrong side for client packet handler: " + context.getDirection());
        }
        context.setPacketHandled(true);
    }

    static {
        CommonUtils.ARMOR_SLOTS[3] = EntityEquipmentSlot.HEAD;
        CommonUtils.ARMOR_SLOTS[2] = EntityEquipmentSlot.CHEST;
        CommonUtils.ARMOR_SLOTS[1] = EntityEquipmentSlot.LEGS;
        CommonUtils.ARMOR_SLOTS[0] = EntityEquipmentSlot.FEET;
        slotToParts = ImmutableMap.builder().put((Object)EntityEquipmentSlot.HEAD, Collections.singletonList(EnumPlayerPart.HEAD)).put((Object)EntityEquipmentSlot.CHEST, Arrays.asList(EnumPlayerPart.LEFT_ARM, EnumPlayerPart.RIGHT_ARM, EnumPlayerPart.BODY)).put((Object)EntityEquipmentSlot.LEGS, Arrays.asList(EnumPlayerPart.LEFT_LEG, EnumPlayerPart.RIGHT_LEG)).put((Object)EntityEquipmentSlot.FEET, Arrays.asList(EnumPlayerPart.LEFT_FOOT, EnumPlayerPart.RIGHT_FOOT)).build();
    }
}

