/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.common.util.CommonUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.quetzi.morpheus.Morpheus;
import net.quetzi.morpheus.MorpheusRegistry;
import net.quetzi.morpheus.api.INewDayHandler;
import net.quetzi.morpheus.world.WorldSleepState;

public class MorpheusHelper
implements INewDayHandler {
    private static final MorpheusHelper INSTANCE = new MorpheusHelper();
    private INewDayHandler oldHandler;

    public static void register() {
        if (MorpheusHelper.INSTANCE.oldHandler != null) {
            throw new IllegalStateException("MorpheusHelper did already init!");
        }
        MorpheusHelper.INSTANCE.oldHandler = (INewDayHandler)MorpheusRegistry.registry.get(0);
        FirstAid.LOGGER.info("Morpheus present - enabling compatibility module. Parent: " + MorpheusHelper.INSTANCE.oldHandler.getClass());
        Morpheus.register.registerHandler((INewDayHandler)INSTANCE, 0);
    }

    public void startNewDay() {
        if (this.oldHandler != null) {
            this.oldHandler.startNewDay();
        }
        if ((Double)FirstAidConfig.SERVER.sleepHealPercentage.get() <= 0.0) {
            return;
        }
        WorldSleepState sleepState = (WorldSleepState)Morpheus.playerSleepStatus.get(0);
        if (sleepState == null) {
            return;
        }
        WorldServer world = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.OVERWORLD);
        for (EntityPlayer player : world.field_73010_i) {
            if (!player.func_71026_bH()) continue;
            CommonUtils.getDamageModel(player).sleepHeal(player);
        }
    }
}

