/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.client.gui.FlashStateManager;
import ichttt.mods.firstaid.common.EventHandler;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.text.DecimalFormat;
import java.util.EnumMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class HealthRenderUtils {
    public static final ResourceLocation GUI_LOCATION = new ResourceLocation("firstaid", "textures/gui/show_wounds.png");
    public static final DecimalFormat TEXT_FORMAT = new DecimalFormat("0.0");
    private static final Object2IntOpenHashMap<EnumPlayerPart> prevHealth = new Object2IntOpenHashMap();
    private static final EnumMap<EnumPlayerPart, FlashStateManager> flashStates = new EnumMap(EnumPlayerPart.class);

    public static void drawHealthString(MatrixStack stack, AbstractDamageablePart damageablePart, float xTranslation, float yTranslation, boolean allowSecondLine) {
        float absorption = damageablePart.getAbsorption();
        String text = TEXT_FORMAT.format(damageablePart.currentHealth) + "/" + damageablePart.getMaxHealth();
        if (absorption > 0.0f) {
            String line2 = "+ " + TEXT_FORMAT.format(absorption);
            if (allowSecondLine) {
                Minecraft.func_71410_x().field_71466_p.func_238405_a_(stack, line2, xTranslation, yTranslation + 5.0f, 0xFFFFFF);
                yTranslation -= 5.0f;
            } else {
                text = text + " " + line2;
            }
        }
        Minecraft.func_71410_x().field_71466_p.func_238405_a_(stack, text, xTranslation, yTranslation, 0xFFFFFF);
    }

    private static void updatePrev(EnumPlayerPart part, int current, boolean playerDead) {
        if (!playerDead) {
            prevHealth.put((Object)part, current);
        } else {
            prevHealth.clear();
        }
    }

    public static boolean healthChanged(AbstractDamageablePart damageablePart, boolean playerDead) {
        int current = (int)Math.ceil(damageablePart.currentHealth);
        FlashStateManager activeFlashState = Objects.requireNonNull(flashStates.get((Object)damageablePart.part));
        if (prevHealth.containsKey((Object)damageablePart.part)) {
            int prev = prevHealth.getInt((Object)damageablePart.part);
            HealthRenderUtils.updatePrev(damageablePart.part, current, playerDead);
            if (prev != current) {
                activeFlashState.setActive(Util.func_211177_b());
                return true;
            }
            return false;
        }
        activeFlashState.setActive(Util.func_211177_b());
        HealthRenderUtils.updatePrev(damageablePart.part, current, playerDead);
        return true;
    }

    public static boolean drawAsString(AbstractDamageablePart damageablePart, boolean allowSecondLine) {
        int maxExtraHealth;
        int maxHealth = HealthRenderUtils.getMaxHearts(damageablePart.getMaxHealth());
        return maxHealth + (maxExtraHealth = HealthRenderUtils.getMaxHearts(damageablePart.getAbsorption())) > 8 && allowSecondLine || maxHealth + maxExtraHealth > 12;
    }

    public static void drawHealth(MatrixStack stack, AbstractDamageablePart damageablePart, float xTranslation, float yTranslation, AbstractGui gui, boolean allowSecondLine) {
        int maxHealth = HealthRenderUtils.getMaxHearts(damageablePart.getMaxHealth());
        int maxExtraHealth = HealthRenderUtils.getMaxHearts(damageablePart.getAbsorption());
        int current = (int)Math.ceil(damageablePart.currentHealth);
        FlashStateManager activeFlashState = Objects.requireNonNull(flashStates.get((Object)damageablePart.part));
        if (HealthRenderUtils.drawAsString(damageablePart, allowSecondLine)) {
            HealthRenderUtils.drawHealthString(stack, damageablePart, xTranslation, yTranslation, allowSecondLine);
            return;
        }
        int yTexture = damageablePart.canCauseDeath ? 45 : 0;
        int absorption = (int)Math.ceil(damageablePart.getAbsorption());
        boolean highlight = activeFlashState.update(Util.func_211177_b());
        Minecraft mc = Minecraft.func_71410_x();
        int regen = -1;
        if (((Boolean)FirstAidConfig.SERVER.allowOtherHealingItems.get()).booleanValue() && mc.field_71439_g.func_70644_a(Effects.field_76428_l)) {
            regen = (int)(mc.field_71456_v.field_175191_F / 2L % 15L);
        }
        boolean low = (float)(current + absorption) < 1.25f;
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        stack.func_227860_a_();
        stack.func_227861_a_((double)xTranslation, (double)yTranslation, 0.0);
        boolean drawSecondLine = allowSecondLine;
        if (allowSecondLine) {
            boolean bl = drawSecondLine = maxHealth + maxExtraHealth > 4;
        }
        if (drawSecondLine) {
            int maxHealth2 = 0;
            if (maxHealth > 4) {
                maxHealth2 = maxHealth - 4;
                maxHealth = 4;
            }
            int maxExtraHealth2 = Math.max(0, maxExtraHealth - (4 - maxHealth));
            maxExtraHealth -= maxExtraHealth2;
            int current2 = 0;
            if (current > 8) {
                current2 = current - 8;
                current = 8;
            }
            int absorption2 = absorption - maxExtraHealth * 2;
            absorption -= absorption2;
            stack.func_227861_a_(0.0, 5.0, 0.0);
            stack.func_227860_a_();
            HealthRenderUtils.renderLine(stack, regen, low, yTexture, maxHealth2, maxExtraHealth2, current2, absorption2, gui, highlight);
            regen -= maxHealth2 + maxExtraHealth;
            stack.func_227865_b_();
            stack.func_227861_a_(0.0, -10.0, 0.0);
        }
        HealthRenderUtils.renderLine(stack, regen, low, yTexture, maxHealth, maxExtraHealth, current, absorption, gui, highlight);
        stack.func_227865_b_();
    }

    private static void renderLine(MatrixStack stack, int regen, boolean low, int yTexture, int maxHealth, int maxExtraHearts, int current, int absorption, AbstractGui gui, boolean highlight) {
        stack.func_227860_a_();
        Int2IntArrayMap map = new Int2IntArrayMap();
        if (low) {
            for (int i = 0; i < maxHealth + maxExtraHearts; ++i) {
                map.put(i, EventHandler.rand.nextInt(2));
            }
        }
        HealthRenderUtils.renderMax(stack, regen, (Int2IntFunction)map, maxHealth, yTexture, gui, highlight);
        if (maxExtraHearts > 0) {
            if (maxHealth != 0) {
                RenderSystem.translatef((float)(2 + 9 * maxHealth), (float)0.0f, (float)0.0f);
            }
            HealthRenderUtils.renderMax(stack, regen - maxHealth, (Int2IntFunction)map, maxExtraHearts, yTexture, gui, false);
        }
        stack.func_227865_b_();
        stack.func_227861_a_(0.0, 0.0, 1.0);
        HealthRenderUtils.renderCurrentHealth(stack, regen, (Int2IntFunction)map, current, yTexture, gui);
        if (absorption > 0) {
            int offset = maxHealth * 9 + (maxHealth == 0 ? 0 : 2);
            stack.func_227861_a_((double)offset, 0.0, 0.0);
            HealthRenderUtils.renderAbsorption(stack, regen - maxHealth, (Int2IntFunction)map, absorption, yTexture, gui);
        }
    }

    public static int getMaxHearts(float value) {
        int maxCurrentHearts = (int)Math.ceil(value);
        if (maxCurrentHearts % 2 != 0) {
            ++maxCurrentHearts;
        }
        return maxCurrentHearts >> 1;
    }

    private static void renderMax(MatrixStack stack, int regen, Int2IntFunction function, int max, int yTexture, AbstractGui gui, boolean highlight) {
        int BACKGROUND = highlight ? 25 : 16;
        HealthRenderUtils.renderTexturedModalRects(stack, regen, function, max, false, BACKGROUND, BACKGROUND, yTexture, gui);
    }

    private static void renderCurrentHealth(MatrixStack stack, int regen, Int2IntFunction function, int current, int yTexture, AbstractGui gui) {
        boolean renderLastHalf = false;
        int render = current >> 1;
        if (current % 2 != 0) {
            renderLastHalf = true;
            ++render;
        }
        HealthRenderUtils.renderTexturedModalRects(stack, regen, function, render, renderLastHalf, 61, 52, yTexture, gui);
    }

    private static void renderAbsorption(MatrixStack stack, int regen, Int2IntFunction function, int absorption, int yTexture, AbstractGui gui) {
        boolean renderLastHalf = false;
        int render = absorption >> 1;
        if (absorption % 2 != 0) {
            renderLastHalf = true;
            ++render;
        }
        if (render > 0) {
            HealthRenderUtils.renderTexturedModalRects(stack, regen, function, render, renderLastHalf, 169, 160, yTexture, gui);
        }
    }

    private static void renderTexturedModalRects(MatrixStack stack, int regen, Int2IntFunction function, int toDraw, boolean lastOneHalf, int halfTextureX, int textureX, int textureY, AbstractGui gui) {
        if (toDraw == 0) {
            return;
        }
        if (toDraw < 0) {
            throw new IllegalArgumentException("Cannot draw negative amount of icons " + toDraw);
        }
        for (int i = 0; i < toDraw; ++i) {
            boolean renderHalf = lastOneHalf && i + 1 == toDraw;
            gui.func_238474_b_(stack, (int)(9.0f * (float)i), (i == regen ? -2 : 0) - function.get(i), renderHalf ? halfTextureX : textureX, textureY, 9, 9);
        }
    }

    static {
        for (EnumPlayerPart part : EnumPlayerPart.VALUES) {
            flashStates.put(part, new FlashStateManager());
        }
    }
}

