/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.client.util.EventCalendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;

public class PlayerModelRenderer {
    private static final ResourceLocation HEALTH_RENDER_LOCATION = new ResourceLocation("firstaid", "textures/gui/simple_health.png");
    private static final int SIZE = 64;
    private static int angle = 0;
    private static boolean otherWay = false;

    public static void renderPlayerHealth(MatrixStack stack, AbstractPlayerDamageModel damageModel, AbstractGui gui, boolean flashState, float alpha, float partialTicks) {
        int yOffset = flashState ? 128 : 0;
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - alpha / 255.0f));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HEALTH_RENDER_LOCATION);
        stack.func_227862_a_(0.5f, 0.5f, 0.5f);
        if (((Boolean)FirstAidConfig.CLIENT.enableEasterEggs.get()).booleanValue() && (EventCalendar.isAFDay() || EventCalendar.isHalloween())) {
            float angle = (float)PlayerModelRenderer.angle + (otherWay ? -partialTicks : partialTicks) * 2.0f;
            if (FirstAidConfig.CLIENT.pos.get() == FirstAidConfig.Client.Position.BOTTOM_LEFT || FirstAidConfig.CLIENT.pos.get() == FirstAidConfig.Client.Position.TOP_LEFT) {
                stack.func_227861_a_((double)(angle * 1.5f), 0.0, 0.0);
            } else {
                stack.func_227861_a_((double)(angle * 0.5f), 0.0, 0.0);
            }
            stack.func_227863_a_(new Quaternion(0.0f, 0.0f, 1.0f, angle));
        }
        if (yOffset != 0) {
            stack.func_227861_a_(0.0, (double)(-yOffset), 0.0);
        }
        PlayerModelRenderer.drawPart(stack, gui, damageModel.HEAD, 16, yOffset + 0, 32, 32);
        PlayerModelRenderer.drawPart(stack, gui, damageModel.BODY, 16, yOffset + 32, 32, 48);
        PlayerModelRenderer.drawPart(stack, gui, damageModel.LEFT_ARM, 0, yOffset + 32, 16, 48);
        PlayerModelRenderer.drawPart(stack, gui, damageModel.RIGHT_ARM, 48, yOffset + 32, 16, 48);
        PlayerModelRenderer.drawPart(stack, gui, damageModel.LEFT_LEG, 16, yOffset + 80, 16, 32);
        PlayerModelRenderer.drawPart(stack, gui, damageModel.RIGHT_LEG, 32, yOffset + 80, 16, 32);
        PlayerModelRenderer.drawPart(stack, gui, damageModel.LEFT_FOOT, 16, yOffset + 112, 16, 16);
        PlayerModelRenderer.drawPart(stack, gui, damageModel.RIGHT_FOOT, 32, yOffset + 112, 16, 16);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawPart(MatrixStack stack, AbstractGui gui, AbstractDamageablePart part, int texX, int texY, int sizeX, int sizeY) {
        int rawTexX = texX;
        int maxHealth = part.getMaxHealth();
        if ((double)part.currentHealth <= 0.001) {
            texX += 192;
        } else if ((double)Math.abs(part.currentHealth - (float)maxHealth) > 0.001) {
            float healthPercentage = part.currentHealth / (float)maxHealth;
            if (healthPercentage >= 1.0f || healthPercentage <= 0.0f) {
                throw new RuntimeException(String.format("Calculated invalid health for part %s with current health %s and max health %d. Got value %s", new Object[]{part.part, Float.valueOf(part.currentHealth), maxHealth, Float.valueOf(healthPercentage)}));
            }
            texX += 64 * ((double)healthPercentage > 0.5 ? 1 : 2);
        }
        gui.func_238474_b_(stack, rawTexX, texY, texX, texY, sizeX, sizeY);
    }

    public static void tickFun() {
        if ((angle += otherWay ? -2 : 2) >= 90 || angle <= 0) {
            otherWay = !otherWay;
        }
    }
}

