/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem.distribution;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.api.event.FirstAidLivingDamageEvent;
import ichttt.mods.firstaid.common.EventHandler;
import ichttt.mods.firstaid.common.damagesystem.PlayerDamageModel;
import ichttt.mods.firstaid.common.damagesystem.distribution.RandomDamageDistribution;
import ichttt.mods.firstaid.common.network.MessageUpdatePart;
import ichttt.mods.firstaid.common.util.ArmorUtils;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public abstract class DamageDistribution
implements IDamageDistribution {
    public static float handleDamageTaken(IDamageDistribution damageDistribution, AbstractPlayerDamageModel damageModel, float damage, @Nonnull PlayerEntity player, @Nonnull DamageSource source, boolean addStat, boolean redistributeIfLeft) {
        boolean hasTriedNoKill;
        float left;
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            FirstAid.LOGGER.info("Damaging {} using {} for dmg source {}, redistribute {}, addStat {}", (Object)Float.valueOf(damage), (Object)damageDistribution.toString(), (Object)source.field_76373_n, (Object)redistributeIfLeft, (Object)addStat);
        }
        CompoundNBT beforeCache = (CompoundNBT)damageModel.serializeNBT();
        if (!damageDistribution.skipGlobalPotionModifiers()) {
            damage = ArmorUtils.applyGlobalPotionModifiers(player, source, damage);
        }
        if (damage != 0.0f) {
            player.func_71020_j(source.func_76345_d());
            float currentHealth = player.func_110143_aJ();
            player.func_110142_aN().func_94547_a(source, currentHealth, damage);
        }
        if ((left = damageDistribution.distributeDamage(damage, player, source, addStat)) > 0.0f && redistributeIfLeft && (left = (damageDistribution = (hasTriedNoKill = damageDistribution == RandomDamageDistribution.NEAREST_NOKILL || damageDistribution == RandomDamageDistribution.ANY_NOKILL) ? RandomDamageDistribution.NEAREST_KILL : RandomDamageDistribution.getDefault()).distributeDamage(left, player, source, addStat)) > 0.0f && !hasTriedNoKill) {
            damageDistribution = RandomDamageDistribution.NEAREST_KILL;
            left = damageDistribution.distributeDamage(left, player, source, addStat);
        }
        PlayerDamageModel before = PlayerDamageModel.create();
        before.deserializeNBT(beforeCache);
        if (MinecraftForge.EVENT_BUS.post((Event)new FirstAidLivingDamageEvent(player, damageModel, before, source, left))) {
            damageModel.deserializeNBT((INBT)beforeCache);
            return 0.0f;
        }
        if (damageModel.isDead(player)) {
            CommonUtils.killPlayer(damageModel, player, source);
        }
        return left;
    }

    protected float minHealth(@Nonnull PlayerEntity player, @Nonnull AbstractDamageablePart part) {
        return 0.0f;
    }

    protected float distributeDamageOnParts(float damage, @Nonnull AbstractPlayerDamageModel damageModel, @Nonnull EnumPlayerPart[] enumParts, @Nonnull PlayerEntity player, boolean addStat) {
        ArrayList<AbstractDamageablePart> damageableParts = new ArrayList<AbstractDamageablePart>(enumParts.length);
        for (EnumPlayerPart part : enumParts) {
            damageableParts.add(damageModel.getFromEnum(part));
        }
        Collections.shuffle(damageableParts);
        for (AbstractDamageablePart part : damageableParts) {
            float minHealth = this.minHealth(player, part);
            float dmgDone = damage - part.damage(damage, player, !player.func_70644_a(EventHandler.MORPHINE), minHealth);
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageUpdatePart(part));
            if (addStat) {
                player.func_195067_a(Stats.field_188112_z, Math.round(dmgDone * 10.0f));
            }
            if ((damage -= dmgDone) == 0.0f) break;
            if (!(damage < 0.0f)) continue;
            FirstAid.LOGGER.error("Got negative damage {} left? Logic error? ", (Object)Float.valueOf(damage));
            break;
        }
        return damage;
    }

    @Nonnull
    protected abstract List<Pair<EquipmentSlotType, EnumPlayerPart[]>> getPartList();

    @Override
    public float distributeDamage(float damage, @Nonnull PlayerEntity player, @Nonnull DamageSource source, boolean addStat) {
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
        for (Pair<EquipmentSlotType, EnumPlayerPart[]> pair : this.getPartList()) {
            EquipmentSlotType slot = (EquipmentSlotType)pair.getLeft();
            EnumPlayerPart[] parts = (EnumPlayerPart[])pair.getRight();
            if (Arrays.stream(parts).map(damageModel::getFromEnum).anyMatch(part -> part.currentHealth > this.minHealth(player, (AbstractDamageablePart)part))) {
                damage = ArmorUtils.applyArmor(player, player.func_184582_a(slot), source, damage, slot);
                if (damage <= 0.0f) {
                    return 0.0f;
                }
                damage = ArmorUtils.applyEnchantmentModifiers(player.func_184582_a(slot), source, damage);
                if (damage <= 0.0f) {
                    return 0.0f;
                }
                if ((damage = ForgeHooks.onLivingDamage((LivingEntity)player, (DamageSource)source, (float)damage)) <= 0.0f) {
                    return 0.0f;
                }
                if ((damage = this.distributeDamageOnParts(damage, damageModel, parts, player, addStat)) != 0.0f) continue;
                break;
            }
            if (!((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) continue;
            FirstAid.LOGGER.info("Skipping {}, no health <in parts!", (Object)slot);
        }
        return damage;
    }
}

