/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdatePart {
    private final byte id;
    private final int maxHealth;
    private final float absorption;
    private final float currentHealth;

    public MessageUpdatePart(PacketBuffer buf) {
        this.id = buf.readByte();
        this.maxHealth = buf.readInt();
        this.absorption = buf.readFloat();
        this.currentHealth = buf.readFloat();
        this.validate();
    }

    public MessageUpdatePart(AbstractDamageablePart part) {
        this.id = (byte)part.part.ordinal();
        this.maxHealth = part.getMaxHealth();
        this.absorption = part.getAbsorption();
        this.currentHealth = part.currentHealth;
    }

    public void encode(PacketBuffer buf) {
        buf.writeByte((int)this.id);
        buf.writeInt(this.maxHealth);
        buf.writeFloat(this.absorption);
        buf.writeFloat(this.currentHealth);
        this.validate();
    }

    private void validate() {
        if (this.currentHealth < 0.0f) {
            throw new RuntimeException("Negative currentHealth!");
        }
        if (this.absorption < 0.0f) {
            throw new RuntimeException("Negative absorption!");
        }
        if (this.maxHealth < 0) {
            throw new RuntimeException("Negative maxHealth!");
        }
        if (EnumPlayerPart.VALUES[this.id].ordinal() != this.id) {
            throw new RuntimeException("Wrong player mapping!");
        }
    }

    public static class Handler {
        public static void onMessage(MessageUpdatePart message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            CommonUtils.checkClient(ctx);
            ctx.enqueueWork(() -> {
                AbstractDamageablePart damageablePart = CommonUtils.getDamageModel((PlayerEntity)Minecraft.func_71410_x().field_71439_g).getFromEnum(EnumPlayerPart.VALUES[message.id]);
                damageablePart.setMaxHealth(message.maxHealth);
                damageablePart.setAbsorption(message.absorption);
                damageablePart.currentHealth = message.currentHealth;
            });
        }
    }
}

