/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.api.enums;

import com.google.common.collect.ImmutableList;
import net.minecraft.inventory.EquipmentSlotType;

public enum EnumPlayerPart {
    HEAD(EquipmentSlotType.HEAD),
    LEFT_ARM(EquipmentSlotType.CHEST),
    LEFT_LEG(EquipmentSlotType.LEGS),
    LEFT_FOOT(EquipmentSlotType.FEET),
    BODY(EquipmentSlotType.CHEST),
    RIGHT_ARM(EquipmentSlotType.CHEST),
    RIGHT_LEG(EquipmentSlotType.LEGS),
    RIGHT_FOOT(EquipmentSlotType.FEET);

    public static final EnumPlayerPart[] VALUES;
    private ImmutableList<EnumPlayerPart> neighbours;
    public final EquipmentSlotType slot;

    private EnumPlayerPart(EquipmentSlotType slot) {
        this.slot = slot;
    }

    public ImmutableList<EnumPlayerPart> getNeighbours() {
        if (this.neighbours == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (this != BODY && this != HEAD) {
                builder.add((Object)this.getUp());
            }
            if (this != LEFT_FOOT && this != RIGHT_FOOT) {
                builder.add((Object)this.getDown());
            }
            if (this.ordinal() >= BODY.ordinal()) {
                builder.add((Object)this.getLeft());
            } else {
                builder.add((Object)this.getRight());
            }
            this.neighbours = builder.build();
        }
        return this.neighbours;
    }

    public EnumPlayerPart getUp() {
        if (this == BODY) {
            throw new RuntimeException("There is no part up from " + (Object)((Object)this));
        }
        return VALUES[this.ordinal() - 1];
    }

    public EnumPlayerPart getDown() {
        if (this == LEFT_FOOT) {
            throw new RuntimeException("There is no part down from " + (Object)((Object)this));
        }
        return VALUES[this.ordinal() + 1];
    }

    public EnumPlayerPart getLeft() {
        return VALUES[this.ordinal() - 4];
    }

    public EnumPlayerPart getRight() {
        return VALUES[this.ordinal() + 4];
    }

    static {
        VALUES = EnumPlayerPart.values();
    }
}

