/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractPartHealer;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.client.ClientHooks;
import ichttt.mods.firstaid.client.HUDHandler;
import ichttt.mods.firstaid.client.gui.GuiHealthScreen;
import ichttt.mods.firstaid.client.tutorial.GuiTutorial;
import ichttt.mods.firstaid.client.util.EventCalendar;
import ichttt.mods.firstaid.client.util.PlayerModelRenderer;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.apiimpl.RegistryManager;
import ichttt.mods.firstaid.common.items.FirstAidItems;
import ichttt.mods.firstaid.common.util.ArmorUtils;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventHandler {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");
    private static int id;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null || mc.field_71439_g.field_71174_a == null || mc.func_147113_T()) {
            return;
        }
        if (EventCalendar.isGuiFun()) {
            GuiHealthScreen.BED_ITEMSTACK.func_196085_b(id);
            if (mc.field_71441_e != null && mc.field_71441_e.func_82737_E() % 3L == 0L) {
                ++id;
            }
            if (id > 15) {
                id = 0;
            }
            PlayerModelRenderer.tickFun();
        }
        if (!RegistryManager.debuffConfigErrors.isEmpty() && mc.field_71441_e != null && mc.field_71441_e.field_72995_K) {
            mc.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("[FirstAid] FirstAid has detected invalid debuff config entries."), false);
            for (String s : RegistryManager.debuffConfigErrors) {
                mc.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("[FirstAid] " + s), false);
            }
            RegistryManager.debuffConfigErrors.clear();
        }
        if (HUDHandler.INSTANCE.ticker >= 0) {
            --HUDHandler.INSTANCE.ticker;
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent event) {
        if (ClientHooks.SHOW_WOUNDS.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((PlayerEntity)mc.field_71439_g);
            if (!damageModel.hasTutorial) {
                damageModel.hasTutorial = true;
                CapProvider.tutorialDone.add(mc.field_71439_g.func_200200_C_().getString());
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTutorial());
            } else {
                mc.func_147108_a((Screen)new GuiHealthScreen(damageModel));
            }
        }
    }

    @SubscribeEvent
    public static void preRender(RenderGameOverlayEvent.Pre event) {
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.HEALTH && !((Boolean)FirstAidConfig.CLIENT.showVanillaHealthBar.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGameOverlayEvent.Post event) {
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.ALL || type == RenderGameOverlayEvent.ElementType.TEXT && FirstAidConfig.CLIENT.overlayMode.get() != FirstAidConfig.Client.OverlayMode.OFF && FirstAidConfig.CLIENT.pos.get() == FirstAidConfig.Client.Position.BOTTOM_LEFT) {
            Minecraft mc = Minecraft.func_71410_x();
            if (!mc.field_71439_g.func_70089_S()) {
                return;
            }
            mc.func_213239_aq().func_76320_a("FirstAidOverlay");
            ForgeIngameGui.renderHealth = (Boolean)FirstAidConfig.CLIENT.showVanillaHealthBar.get();
            HUDHandler.INSTANCE.renderOverlay(event.getMatrixStack(), mc, event.getPartialTicks());
            mc.func_213239_aq().func_76319_b();
            mc.func_213239_aq().func_76319_b();
        }
    }

    private static ITextComponent makeArmorMsg(double value) {
        return new TranslationTextComponent("firstaid.specificarmor", new Object[]{FORMAT.format(value)}).func_240699_a_(TextFormatting.BLUE);
    }

    private static ITextComponent makeToughnessMsg(double value) {
        return new TranslationTextComponent("firstaid.specifictoughness", new Object[]{FORMAT.format(value)}).func_240699_a_(TextFormatting.BLUE);
    }

    private static <T> void replaceOrAppend(List<T> list, T search, T replace) {
        int index = list.indexOf(search);
        if (FirstAidConfig.CLIENT.armorTooltipMode.get() == FirstAidConfig.Client.TooltipMode.REPLACE && index >= 0) {
            list.set(index, replace);
        } else {
            list.add(replace);
        }
    }

    @SubscribeEvent
    public static void tooltipItems(ItemTooltipEvent event) {
        AbstractPartHealer healer;
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item == FirstAidItems.MORPHINE) {
            event.getToolTip().add(new TranslationTextComponent("firstaid.tooltip.morphine", new Object[]{"3:30-4:30"}));
            return;
        }
        if (FirstAidConfig.CLIENT.armorTooltipMode.get() != FirstAidConfig.Client.TooltipMode.NONE && item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            List tooltip = event.getToolTip();
            double normalArmor = ArmorUtils.getArmor(stack, armor.func_185083_B_());
            double totalArmor = ArmorUtils.applyArmorModifier(armor.func_185083_B_(), normalArmor);
            if (totalArmor > 0.0) {
                IFormattableTextComponent original = new TranslationTextComponent("attribute.modifier.plus.0", new Object[]{FORMAT.format(normalArmor), new TranslationTextComponent("attribute.name.generic.armor")}).func_240699_a_(TextFormatting.BLUE);
                ClientEventHandler.replaceOrAppend(tooltip, original, ClientEventHandler.makeArmorMsg(totalArmor));
            }
            double normalToughness = ArmorUtils.getArmorThoughness(stack, armor.func_185083_B_());
            double totalToughness = ArmorUtils.applyToughnessModifier(armor.func_185083_B_(), normalToughness);
            if (totalToughness > 0.0) {
                IFormattableTextComponent original = new TranslationTextComponent("attribute.modifier.plus.0", new Object[]{FORMAT.format(normalToughness), new TranslationTextComponent("attribute.name.generic.armor_toughness")}).func_240699_a_(TextFormatting.BLUE);
                ClientEventHandler.replaceOrAppend(tooltip, original, ClientEventHandler.makeToughnessMsg(totalToughness));
            }
        }
        if ((healer = FirstAidRegistryImpl.INSTANCE.getPartHealer(stack)) != null && event.getPlayer() != null) {
            event.getToolTip().add(new TranslationTextComponent("firstaid.tooltip.healer", new Object[]{healer.maxHeal.getAsInt() / 2, StringUtils.func_76337_a((int)healer.ticksPerHeal.getAsInt())}));
        }
    }

    @SubscribeEvent
    public static void onDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        FirstAid.isSynced = false;
        HUDHandler.INSTANCE.ticker = -1;
    }
}

