/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.client.gui.FlashStateManager;
import ichttt.mods.firstaid.client.gui.GuiHealthScreen;
import ichttt.mods.firstaid.client.util.HealthRenderUtils;
import ichttt.mods.firstaid.client.util.PlayerModelRenderer;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class HUDHandler
implements ISelectiveResourceReloadListener {
    public static final HUDHandler INSTANCE = new HUDHandler();
    private static final int FADE_TIME = 30;
    private final Map<EnumPlayerPart, String> TRANSLATION_MAP = new EnumMap<EnumPlayerPart, String>(EnumPlayerPart.class);
    private final FlashStateManager flashStateManager = new FlashStateManager();
    private int maxLength;
    public int ticker = -1;

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, @Nonnull Predicate<IResourceType> resourcePredicate) {
        if (!resourcePredicate.test((IResourceType)VanillaResourceType.LANGUAGES)) {
            return;
        }
        this.buildTranslationTable();
    }

    private synchronized void buildTranslationTable() {
        FirstAid.LOGGER.debug("Building GUI translation table");
        this.TRANSLATION_MAP.clear();
        this.maxLength = 0;
        for (EnumPlayerPart part : EnumPlayerPart.VALUES) {
            String translated = I18n.func_135052_a((String)("firstaid.gui." + part.toString().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]);
            this.maxLength = Math.max(this.maxLength, Minecraft.func_71410_x().field_71466_p.func_78256_a(translated));
            this.TRANSLATION_MAP.put(part, translated);
        }
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void renderOverlay(MatrixStack stack, Minecraft mc, float partialTicks) {
        int visibleTicks;
        mc.func_213239_aq().func_76320_a("prepare");
        if (mc.field_71439_g == null) {
            return;
        }
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((PlayerEntity)mc.field_71439_g);
        if (!FirstAid.isSynced) {
            return;
        }
        if (this.TRANSLATION_MAP.isEmpty()) {
            this.buildTranslationTable();
        }
        if ((visibleTicks = ((Integer)FirstAidConfig.CLIENT.visibleDurationTicks.get()).intValue()) != -1) {
            visibleTicks += 30;
        }
        boolean playerDead = damageModel.isDead((PlayerEntity)mc.field_71439_g);
        for (AbstractDamageablePart damageablePart : damageModel) {
            if (!HealthRenderUtils.healthChanged(damageablePart, playerDead)) continue;
            if (visibleTicks != -1) {
                this.ticker = Math.max(this.ticker, visibleTicks);
            }
            if (!((Boolean)FirstAidConfig.CLIENT.flash.get()).booleanValue()) continue;
            this.flashStateManager.setActive(Util.func_211177_b());
        }
        FirstAidConfig.Client.OverlayMode overlayMode = (FirstAidConfig.Client.OverlayMode)((Object)FirstAidConfig.CLIENT.overlayMode.get());
        if (overlayMode == FirstAidConfig.Client.OverlayMode.OFF || GuiHealthScreen.isOpen && overlayMode != FirstAidConfig.Client.OverlayMode.PLAYER_MODEL || !CommonUtils.isSurvivalOrAdventure((PlayerEntity)mc.field_71439_g)) {
            return;
        }
        if (visibleTicks != -1 && this.ticker < 0) {
            return;
        }
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        IngameGui gui = mc.field_71456_v;
        int xOffset = (Integer)FirstAidConfig.CLIENT.xOffset.get();
        int yOffset = (Integer)FirstAidConfig.CLIENT.yOffset.get();
        boolean playerModel = FirstAidConfig.CLIENT.overlayMode.get() == FirstAidConfig.Client.OverlayMode.PLAYER_MODEL;
        switch ((FirstAidConfig.Client.Position)((Object)FirstAidConfig.CLIENT.pos.get())) {
            case TOP_LEFT: {
                if (!playerModel) break;
                ++xOffset;
                break;
            }
            case TOP_RIGHT: {
                xOffset = mc.func_228018_at_().func_198107_o() - xOffset - (playerModel ? 34 : damageModel.getMaxRenderSize() + this.maxLength);
                break;
            }
            case BOTTOM_LEFT: {
                if (playerModel) {
                    ++xOffset;
                }
                yOffset = mc.func_228018_at_().func_198087_p() - yOffset - (playerModel ? 66 : 80);
                break;
            }
            case BOTTOM_RIGHT: {
                xOffset = mc.func_228018_at_().func_198107_o() - xOffset - (playerModel ? 34 : damageModel.getMaxRenderSize() + this.maxLength);
                yOffset = mc.func_228018_at_().func_198087_p() - yOffset - (playerModel ? 62 : 80);
                break;
            }
            default: {
                throw new RuntimeException("Invalid config option for position: " + FirstAidConfig.CLIENT.pos.get());
            }
        }
        if (mc.field_71462_r instanceof ChatScreen && FirstAidConfig.CLIENT.pos.get() == FirstAidConfig.Client.Position.BOTTOM_LEFT) {
            return;
        }
        if (mc.field_71474_y.field_74330_P && FirstAidConfig.CLIENT.pos.get() == FirstAidConfig.Client.Position.TOP_LEFT) {
            return;
        }
        boolean enableAlphaBlend = visibleTicks != -1 && this.ticker < 30;
        int alpha = enableAlphaBlend ? MathHelper.func_76125_a((int)((int)((float)(30 - this.ticker) * 255.0f / 30.0f)), (int)((Integer)FirstAidConfig.CLIENT.alpha.get()), (int)250) : (Integer)FirstAidConfig.CLIENT.alpha.get();
        stack.func_227860_a_();
        stack.func_227861_a_((double)xOffset, (double)yOffset, 0.0);
        if (enableAlphaBlend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        mc.func_213239_aq().func_219895_b("render");
        if (overlayMode == FirstAidConfig.Client.OverlayMode.PLAYER_MODEL) {
            PlayerModelRenderer.renderPlayerHealth(stack, damageModel, (AbstractGui)gui, this.flashStateManager.update(Util.func_211177_b()), alpha, partialTicks);
        } else {
            int xTranslation = this.maxLength;
            for (AbstractDamageablePart part : damageModel) {
                mc.field_71466_p.func_238405_a_(stack, this.TRANSLATION_MAP.get((Object)part.part), 0.0f, 0.0f, 0xFFFFFF - (alpha << 24 & 0xFF000001));
                if (FirstAidConfig.CLIENT.overlayMode.get() == FirstAidConfig.Client.OverlayMode.NUMBERS) {
                    HealthRenderUtils.drawHealthString(stack, part, xTranslation, 0.0f, false);
                } else {
                    HealthRenderUtils.drawHealth(stack, part, xTranslation, 0.0f, (AbstractGui)gui, false);
                }
                stack.func_227861_a_(0.0, 10.0, 0.0);
            }
        }
        mc.func_213239_aq().func_219895_b("cleanup");
        if (enableAlphaBlend) {
            RenderSystem.disableBlend();
        }
        stack.func_227865_b_();
    }
}

