/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common;

import com.mojang.brigadier.CommandDispatcher;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.DataManagerWrapper;
import ichttt.mods.firstaid.common.DebugDamageCommand;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.damagesystem.PlayerDamageModel;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.HealthDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.PreferredDamageDistribution;
import ichttt.mods.firstaid.common.items.FirstAidItems;
import ichttt.mods.firstaid.common.network.MessageConfiguration;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import ichttt.mods.firstaid.common.util.ProjectileHelper;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;

public class EventHandler {
    public static final Random rand = new Random();
    @ObjectHolder(value="firstaid:debuff.heartbeat")
    public static final SoundEvent HEARTBEAT = (SoundEvent)FirstAidItems.getNull();
    @ObjectHolder(value="firstaid:morphine")
    public static final Effect MORPHINE = (Effect)FirstAidItems.getNull();
    public static final Map<PlayerEntity, Pair<Entity, RayTraceResult>> hitList = new WeakHashMap<PlayerEntity, Pair<Entity, RayTraceResult>>();
    private static final Field LOOT_ENTRIES_FIELD = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entityProjectile;
        EquipmentSlotType slot;
        Pair<Entity, RayTraceResult> rayTraceResult;
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K || !CommonUtils.hasDamageModel((Entity)entity)) {
            return;
        }
        float amountToDamage = event.getAmount();
        PlayerEntity player = (PlayerEntity)entity;
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
        DamageSource source = event.getSource();
        if (amountToDamage == Float.MAX_VALUE) {
            damageModel.forEach(damageablePart -> {
                damageablePart.currentHealth = 0.0f;
            });
            if (player instanceof ServerPlayerEntity) {
                FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageSyncDamageModel(damageModel, false));
            }
            event.setCanceled(true);
            CommonUtils.killPlayer(damageModel, player, source);
            return;
        }
        boolean addStat = amountToDamage < 3.4028235E37f;
        IDamageDistribution damageDistribution = FirstAidRegistryImpl.INSTANCE.getDamageDistribution(source);
        if (source.func_76352_a() && (rayTraceResult = hitList.remove(player)) != null && (slot = ProjectileHelper.getPartByPosition(entityProjectile = (Entity)rayTraceResult.getLeft(), player)) != null) {
            damageDistribution = new PreferredDamageDistribution(slot);
        }
        DamageDistribution.handleDamageTaken(damageDistribution, damageModel, amountToDamage, player, source, addStat, true);
        event.setCanceled(true);
        hitList.remove(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        RayTraceResult result = event.getRayTraceResult();
        if (result.func_216346_c() != RayTraceResult.Type.ENTITY) {
            return;
        }
        Entity entity = ((EntityRayTraceResult)result).func_216348_a();
        if (!entity.field_70170_p.field_72995_K && entity instanceof PlayerEntity) {
            hitList.put((PlayerEntity)entity, (Pair<Entity, RayTraceResult>)Pair.of((Object)event.getEntity(), (Object)event.getRayTraceResult()));
        }
    }

    @SubscribeEvent
    public static void registerCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity obj = (Entity)event.getObject();
        if (CommonUtils.hasDamageModel(obj)) {
            PlayerEntity player = (PlayerEntity)obj;
            PlayerDamageModel damageModel = PlayerDamageModel.create();
            event.addCapability(CapProvider.IDENTIFIER, (ICapabilityProvider)new CapProvider(damageModel));
            player.field_70180_af = new DataManagerWrapper(player, player.field_70180_af);
        }
    }

    @SubscribeEvent
    public static void tickPlayers(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && CommonUtils.isSurvivalOrAdventure(event.player)) {
            if (!event.player.func_70089_S()) {
                return;
            }
            CommonUtils.getDamageModel(event.player).tick(event.player.field_70170_p, event.player);
            hitList.remove(event.player);
        }
    }

    @SubscribeEvent
    public static void onSleepFinished(SleepFinishedTimeEvent event) {
        if (ModList.get().isLoaded("morpheus")) {
            return;
        }
        for (PlayerEntity player : event.getWorld().func_217369_A()) {
            if (!player.func_71026_bH()) continue;
            CommonUtils.getDamageModel(player).sleepHeal(player);
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation tableName = event.getName();
        LootPool pool = null;
        int bandage = 0;
        int plaster = 0;
        int morphine = 0;
        if (tableName.equals((Object)LootTables.field_186420_b)) {
            pool = event.getTable().getPool("main");
            bandage = 8;
            plaster = 16;
            morphine = 4;
        } else if (tableName.equals((Object)LootTables.field_186428_j) || tableName.equals((Object)LootTables.field_186427_i) || tableName.equals((Object)LootTables.field_186424_f)) {
            pool = event.getTable().getPool("main");
            bandage = 20;
            plaster = 24;
            morphine = 8;
        } else if (tableName.equals((Object)LootTables.field_215820_k)) {
            pool = event.getTable().getPool("main");
            bandage = 4;
            plaster = 16;
            morphine = 2;
        } else if (tableName.equals((Object)LootTables.field_186431_m)) {
            pool = event.getTable().getPool("main");
            bandage = 4;
            plaster = 8;
            morphine = 2;
        }
        if (pool != null) {
            List lootEntries;
            try {
                lootEntries = (List)LOOT_ENTRIES_FIELD.get(pool);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Reflection failed!", e);
            }
            lootEntries.add(ItemLootEntry.func_216168_a(() -> FirstAidItems.BANDAGE).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(1.0f, 3.0f))).func_216086_a(bandage).func_216085_b(0).func_216081_b());
            lootEntries.add(ItemLootEntry.func_216168_a(() -> FirstAidItems.PLASTER).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(1.0f, 5.0f))).func_216086_a(plaster).func_216085_b(0).func_216081_b());
            lootEntries.add(ItemLootEntry.func_216168_a(() -> FirstAidItems.MORPHINE).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(1.0f, 2.0f))).func_216086_a(morphine).func_216085_b(0).func_216081_b());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!CommonUtils.hasDamageModel((Entity)entity)) {
            return;
        }
        event.setCanceled(true);
        if (entity.field_70170_p.field_72995_K || !((Boolean)FirstAidConfig.SERVER.allowOtherHealingItems.get()).booleanValue()) {
            return;
        }
        float amount = event.getAmount();
        if (Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(stackTraceElement -> stackTraceElement.getClassName().equals(FoodStats.class.getName()))) {
            if (((Boolean)FirstAidConfig.SERVER.allowNaturalRegeneration.get()).booleanValue()) {
                amount *= (float)((Double)FirstAidConfig.SERVER.naturalRegenMultiplier.get()).doubleValue();
            }
        } else {
            amount *= (float)((Double)FirstAidConfig.SERVER.otherRegenMultiplier.get()).doubleValue();
        }
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            CommonUtils.debugLogStacktrace("External healing: : " + amount);
        }
        HealthDistribution.distributeHealth(amount, (PlayerEntity)entity, true);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            FirstAid.LOGGER.debug("Sending damage model to " + event.getPlayer().func_200200_C_());
            AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(event.getPlayer());
            if (damageModel.hasTutorial) {
                CapProvider.tutorialDone.add(event.getPlayer().func_200200_C_().getString());
            }
            ServerPlayerEntity playerMP = (ServerPlayerEntity)event.getPlayer();
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> playerMP), (Object)new MessageConfiguration((CompoundNBT)damageModel.serializeNBT()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        hitList.remove(event.getPlayer());
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        if (!world.func_201670_d() && world instanceof World) {
            ((GameRules.BooleanValue)((World)world).func_82736_K().func_223585_a(GameRules.field_223606_i)).func_223570_a(((Boolean)FirstAidConfig.SERVER.allowNaturalRegeneration.get()).booleanValue(), ((World)world).func_73046_m());
        }
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.field_72995_K && player instanceof ServerPlayerEntity) {
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageSyncDamageModel(CommonUtils.getDamageModel(player), true));
        }
    }

    @SubscribeEvent
    public static void onServerStop(FMLServerStoppedEvent event) {
        FirstAid.LOGGER.debug("Cleaning up");
        CapProvider.tutorialDone.clear();
        hitList.clear();
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        DebugDamageCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!event.isEndConquered() && !player.field_70170_p.field_72995_K && player instanceof ServerPlayerEntity) {
            AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
            damageModel.runScaleLogic(player);
            damageModel.forEach(damageablePart -> damageablePart.heal(damageablePart.getMaxHealth(), player, false));
            damageModel.scheduleResync();
        }
    }
}

