/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.apiimpl;

import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import cpw.mods.modlauncher.TransformingClassLoader;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.FirstAidRegistry;
import ichttt.mods.firstaid.api.debuff.builder.DebuffBuilderFactory;
import ichttt.mods.firstaid.api.debuff.builder.IDebuffBuilder;
import ichttt.mods.firstaid.api.distribution.DamageDistributionBuilderFactory;
import ichttt.mods.firstaid.api.enums.EnumDebuffSlot;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.EventHandler;
import ichttt.mods.firstaid.common.apiimpl.DebuffBuilderFactoryImpl;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.apiimpl.distribution.DamageDistributionBuilderFactoryImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.ArrayUtils;

public class RegistryManager {
    public static final List<String> debuffConfigErrors = new ArrayList<String>();

    public static void setupRegistries() {
        FirstAidRegistry.setImpl(FirstAidRegistryImpl.INSTANCE);
        DebuffBuilderFactory.setInstance(DebuffBuilderFactoryImpl.INSTANCE);
        DamageDistributionBuilderFactory.setInstance(DamageDistributionBuilderFactoryImpl.INSTANCE);
        if (RegistryManager.class.getClassLoader() != FirstAidRegistry.class.getClassLoader()) {
            FirstAid.LOGGER.error("API and normal mod loaded on two different classloaders! Normal mod: {}, First Aid Registry: {}", (Object)RegistryManager.class.getName(), (Object)FirstAidRegistry.class.getName());
            throw new RuntimeException("API and normal mod loaded on two different classloaders!");
        }
        TransformingClassLoader tcl = (TransformingClassLoader)RegistryManager.class.getClassLoader();
        if (tcl.getLoadedClass(RegistryManager.class.getName()) != RegistryManager.class) {
            FirstAid.LOGGER.error("API is not the same as under tcl loaded classes! In TCL cache: {}, actual: {}", (Object)tcl.getLoadedClass(RegistryManager.class.getName()), RegistryManager.class);
            throw new RuntimeException("API is not under loaded classes in the TCL!");
        }
    }

    public static void registerDefaults() {
        FirstAid.LOGGER.debug("Registering defaults registry values");
        DamageDistributionBuilderFactory distributionBuilderFactory = Objects.requireNonNull(DamageDistributionBuilderFactory.getInstance());
        distributionBuilderFactory.newStandardBuilder().addDistributionLayer(EquipmentSlotType.FEET, EnumPlayerPart.LEFT_FOOT, EnumPlayerPart.RIGHT_FOOT).addDistributionLayer(EquipmentSlotType.LEGS, EnumPlayerPart.LEFT_LEG, EnumPlayerPart.RIGHT_LEG).registerStatic(DamageSource.field_76379_h, DamageSource.field_190095_e);
        distributionBuilderFactory.newStandardBuilder().addDistributionLayer(EquipmentSlotType.HEAD, EnumPlayerPart.HEAD).registerStatic(DamageSource.field_82728_o);
        distributionBuilderFactory.newStandardBuilder().addDistributionLayer(EquipmentSlotType.HEAD, EnumPlayerPart.HEAD).addDistributionLayer(EquipmentSlotType.CHEST, EnumPlayerPart.LEFT_ARM, EnumPlayerPart.RIGHT_ARM).ignoreOrder().registerStatic(DamageSource.field_180137_b);
        distributionBuilderFactory.newRandomBuilder().registerStatic(DamageSource.field_76376_m);
        if (((Boolean)FirstAidConfig.GENERAL.hardMode.get()).booleanValue()) {
            distributionBuilderFactory.newStandardBuilder().addDistributionLayer(EquipmentSlotType.CHEST, EnumPlayerPart.BODY).registerStatic(DamageSource.field_76366_f);
            distributionBuilderFactory.newStandardBuilder().addDistributionLayer(EquipmentSlotType.CHEST, EnumPlayerPart.BODY).addDistributionLayer(EquipmentSlotType.HEAD, EnumPlayerPart.HEAD).ignoreOrder().registerStatic(DamageSource.field_76369_e);
        } else {
            distributionBuilderFactory.newRandomBuilder().tryNoKill().registerStatic(DamageSource.field_76366_f, DamageSource.field_76369_e);
        }
        distributionBuilderFactory.newRandomBuilder().tryNoKill().registerStatic(DamageSource.field_76368_d, DamageSource.field_191291_g);
        distributionBuilderFactory.newEqualBuilder().reductionMultiplier(0.8f).registerDynamic(DamageSource::func_94541_c);
        DebuffBuilderFactory debuffBuilderFactory = DebuffBuilderFactory.getInstance();
        RegistryManager.loadValuesFromConfig(debuffBuilderFactory, "blindness", () -> EventHandler.HEARTBEAT, FirstAidConfig.GENERAL.head.blindnessConditions, EnumDebuffSlot.HEAD);
        RegistryManager.loadValuesFromConfig(debuffBuilderFactory, "nausea", null, FirstAidConfig.GENERAL.head.nauseaConditions, EnumDebuffSlot.HEAD);
        RegistryManager.loadValuesFromConfig(debuffBuilderFactory, "nausea", null, FirstAidConfig.GENERAL.body.nauseaConditions, EnumDebuffSlot.BODY);
        RegistryManager.loadValuesFromConfig(debuffBuilderFactory, "weakness", FirstAidConfig.GENERAL.body.weaknessConditions, EnumDebuffSlot.BODY);
        RegistryManager.loadValuesFromConfig(debuffBuilderFactory, "mining_fatigue", FirstAidConfig.GENERAL.arms.miningFatigueConditions, EnumDebuffSlot.ARMS);
        RegistryManager.loadValuesFromConfig(debuffBuilderFactory, "slowness", FirstAidConfig.GENERAL.legsAndFeet.slownessConditions, EnumDebuffSlot.LEGS_AND_FEET);
    }

    private static void loadValuesFromConfig(DebuffBuilderFactory factory, String potionName, Supplier<SoundEvent> event, FirstAidConfig.General.ConditionOnHit config, EnumDebuffSlot slot) {
        float[] damageTaken = Floats.toArray((Collection)((Collection)config.damageTaken.get()));
        int[] debuffLength = Ints.toArray((Collection)((Collection)config.debuffLength.get()));
        if (debuffLength.length != damageTaken.length) {
            RegistryManager.logError("The fields to not have the same amount of values!", potionName, slot);
            return;
        }
        if (debuffLength.length == 0) {
            RegistryManager.logError("The fields are empty!", potionName, slot);
            return;
        }
        float[] healthPercentageLeft = new float[damageTaken.length];
        System.arraycopy(damageTaken, 0, healthPercentageLeft, 0, damageTaken.length);
        Arrays.sort(healthPercentageLeft);
        ArrayUtils.reverse((float[])healthPercentageLeft);
        if (!Arrays.equals(healthPercentageLeft, damageTaken)) {
            RegistryManager.logError("The damageTaken field is not sorted right!", potionName, slot);
            return;
        }
        IDebuffBuilder builder = factory.newOnHitDebuffBuilder(potionName);
        builder.addEnableCondition(() -> ((ForgeConfigSpec.BooleanValue)config.enabled).get());
        for (int i = 0; i < damageTaken.length; ++i) {
            builder.addBound(damageTaken[i], debuffLength[i]);
        }
        if (event != null) {
            builder.addSoundEffect(event);
        }
        builder.register(slot);
    }

    private static void loadValuesFromConfig(DebuffBuilderFactory factory, String potionName, FirstAidConfig.General.ConditionConstant config, EnumDebuffSlot slot) {
        float[] healthPercentageLeft;
        int[] debuffStrength = Ints.toArray((Collection)((Collection)config.debuffStrength.get()));
        if (debuffStrength.length != (healthPercentageLeft = Floats.toArray((Collection)((Collection)config.healthPercentageLeft.get()))).length) {
            RegistryManager.logError("The fields to not have the same amount of values!", potionName, slot);
            return;
        }
        if (healthPercentageLeft.length == 0) {
            RegistryManager.logError("The fields are empty!", potionName, slot);
            return;
        }
        if (!ArrayUtils.isSorted((float[])healthPercentageLeft)) {
            RegistryManager.logError("The healthPercentageLeft field is not sorted right!", potionName, slot);
            return;
        }
        IDebuffBuilder builder = factory.newConstantDebuffBuilder(potionName);
        builder.addEnableCondition(() -> ((ForgeConfigSpec.BooleanValue)config.enabled).get());
        for (int i = 0; i < healthPercentageLeft.length; ++i) {
            builder.addBound(healthPercentageLeft[i], debuffStrength[i]);
        }
        builder.register(slot);
    }

    private static void logError(String error, String potionName, EnumDebuffSlot slot) {
        String errorMsg = String.format("Invalid config entry for debuff %s at part %s: %s", potionName, slot.toString(), error);
        FirstAid.LOGGER.warn(errorMsg);
        debuffConfigErrors.add(errorMsg);
    }

    public static void finalizeRegistries() {
        FirstAidRegistryImpl.finish();
        DebuffBuilderFactoryImpl.verify();
    }
}

