/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem.distribution;

import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.PreferredDamageDistribution;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.DamageSource;
import org.apache.commons.lang3.tuple.Pair;

public class StandardDamageDistribution
extends DamageDistribution {
    private final List<Pair<EquipmentSlotType, EnumPlayerPart[]>> partList;
    private final boolean shuffle;

    public StandardDamageDistribution(List<Pair<EquipmentSlotType, EnumPlayerPart[]>> partList, boolean shuffle) {
        this.partList = partList;
        for (Pair<EquipmentSlotType, EnumPlayerPart[]> pair : partList) {
            for (EnumPlayerPart part : (EnumPlayerPart[])pair.getRight()) {
                if (part.slot == pair.getLeft()) continue;
                throw new RuntimeException((Object)((Object)part) + " is not a member of " + pair.getLeft());
            }
        }
        this.shuffle = shuffle;
    }

    @Override
    @Nonnull
    protected List<Pair<EquipmentSlotType, EnumPlayerPart[]>> getPartList() {
        if (this.shuffle) {
            Collections.shuffle(this.partList);
        }
        return this.partList;
    }

    @Override
    public float distributeDamage(float damage, @Nonnull PlayerEntity player, @Nonnull DamageSource source, boolean addStat) {
        EnumPlayerPart[] parts;
        Optional<EnumPlayerPart> playerPart;
        float rest = super.distributeDamage(damage, player, source, addStat);
        if (rest > 0.0f && (playerPart = Arrays.stream(parts = (EnumPlayerPart[])this.partList.get(this.partList.size() - 1).getRight()).filter(enumPlayerPart -> !enumPlayerPart.getNeighbours().isEmpty()).findAny()).isPresent()) {
            Object neighbours = playerPart.get().getNeighbours();
            neighbours = neighbours.stream().filter(part -> this.partList.stream().noneMatch(pair -> Arrays.stream((Object[])pair.getRight()).anyMatch(p2 -> p2 == part))).collect(Collectors.toList());
            Iterator iterator = neighbours.iterator();
            while (iterator.hasNext()) {
                EnumPlayerPart part2 = (EnumPlayerPart)((Object)iterator.next());
                rest = new PreferredDamageDistribution(part2).distributeDamage(rest, player, source, addStat);
            }
        }
        return rest;
    }
}

