/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MessageClientRequest {
    private final Type type;

    public MessageClientRequest(PacketBuffer buffer) {
        this.type = Type.TYPES[buffer.readByte()];
    }

    public MessageClientRequest(Type type) {
        this.type = type;
    }

    public void encode(PacketBuffer buf) {
        buf.writeByte(this.type.ordinal());
    }

    public static class Handler {
        public static void onMessage(MessageClientRequest message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            ServerPlayerEntity player = CommonUtils.checkServer(ctx);
            if (message.type == Type.TUTORIAL_COMPLETE) {
                CapProvider.tutorialDone.add(player.func_200200_C_().getString());
                ctx.enqueueWork(() -> {
                    CommonUtils.getDamageModel((PlayerEntity)player).hasTutorial = true;
                });
            } else if (message.type == Type.REQUEST_REFRESH) {
                FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageSyncDamageModel(CommonUtils.getDamageModel((PlayerEntity)player), true));
            }
        }
    }

    public static enum Type {
        TUTORIAL_COMPLETE,
        REQUEST_REFRESH;

        private static final Type[] TYPES;

        static {
            TYPES = Type.values();
        }
    }
}

