/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client;

import com.flansmod.api.IControllable;
import com.flansmod.client.ClientProxy;
import com.flansmod.client.FlansModClient;
import com.flansmod.client.gui.teams.GuiTeamScores;
import com.flansmod.client.handlers.FlansModResourceHandler;
import com.flansmod.client.model.CustomItemRenderType;
import com.flansmod.client.model.CustomItemRenderer;
import com.flansmod.client.model.RenderGrenade;
import com.flansmod.client.model.RenderGun;
import com.flansmod.client.model.RenderMecha;
import com.flansmod.client.model.RenderPlane;
import com.flansmod.client.model.RenderVehicle;
import com.flansmod.client.util.WorldRenderer;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.network.PacketTeamInfo;
import com.flansmod.common.teams.ItemTeamArmour;
import com.flansmod.common.teams.Team;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.IPaintableItem;
import com.flansmod.common.types.InfoType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.MouseHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.glu.Project;

@SideOnly(value=Side.CLIENT)
public class ClientRenderHooks {
    public static final ResourceLocation hitMarker = new ResourceLocation("flansmod", "gui/hitMarker.png");
    private Minecraft mc;
    private float fovModifierHand;
    private float equippedProgress;
    private float prevEquippedProgress;
    private ItemStack itemToRender = ItemStack.field_190927_a.func_77946_l();
    private int equippedItemSlot;
    private float partialTicks;
    private MouseHelper constantMouseHelper = new MouseHelper(){

        public void func_74374_c() {
            this.field_74377_a = 0;
            this.field_74375_b = 0;
        }
    };
    private static RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
    private static List<KillMessage> killMessages = new ArrayList<KillMessage>();
    private CustomItemRenderer[] customRenderers = new CustomItemRenderer[EnumType.values().length];

    public ClientRenderHooks() {
        this.mc = Minecraft.func_71410_x();
        RenderManager rm = Minecraft.func_71410_x().func_175598_ae();
        ClientProxy.gunRenderer = new RenderGun();
        this.customRenderers[EnumType.gun.ordinal()] = ClientProxy.gunRenderer;
        this.customRenderers[EnumType.grenade.ordinal()] = new RenderGrenade(rm);
        this.customRenderers[EnumType.plane.ordinal()] = new RenderPlane(rm);
        this.customRenderers[EnumType.vehicle.ordinal()] = new RenderVehicle(rm);
        this.customRenderers[EnumType.mecha.ordinal()] = new RenderMecha(rm);
    }

    public void renderItemFrame(RenderItemInFrameEvent event) {
        if (event.getItem().func_77973_b() instanceof ItemGun) {
            GunType type = ((ItemGun)event.getItem().func_77973_b()).GetType();
            if (type.model != null) {
                event.setCanceled(true);
                int rotation = event.getEntityItemFrame().func_82333_j();
                GlStateManager.func_179114_b((float)((float)(-rotation) * 45.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                RenderHelper.func_74519_b();
                GlStateManager.func_179114_b((float)((float)rotation * 45.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179094_E();
                float scale = 0.75f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                GlStateManager.func_179109_b((float)0.15f, (float)-0.15f, (float)0.0f);
                ClientProxy.gunRenderer.renderItem(CustomItemRenderType.ENTITY, EnumHand.MAIN_HAND, event.getItem(), new Object[0]);
                GlStateManager.func_179121_F();
            }
        }
    }

    public void renderHeldItem(RenderSpecificHandEvent event) {
        InfoType type;
        EnumType typeType;
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof IFlanItem && this.customRenderers[(typeType = EnumType.getFromObject(type = ((IFlanItem)stack.func_77973_b()).getInfoType())).ordinal()] != null && type.GetModel() != null) {
            boolean flag;
            event.setCanceled(true);
            float partialTicks = event.getPartialTicks();
            EntityRenderer renderer = this.mc.field_71460_t;
            float farPlaneDistance = (float)this.mc.field_71474_y.field_151451_c * 16.0f;
            ItemRenderer itemRenderer = this.mc.func_175597_ag();
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            Project.gluPerspective((float)this.getFOVModifier(partialTicks), (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)(farPlaneDistance * 2.0f));
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179094_E();
            this.hurtCameraEffect(partialTicks);
            if (this.mc.field_71474_y.field_74336_f) {
                this.setupViewBobbing(partialTicks);
            }
            boolean bl = flag = this.mc.func_175606_aa() instanceof EntityLivingBase && ((EntityLivingBase)this.mc.func_175606_aa()).func_70608_bn();
            if (!(this.mc.field_71474_y.field_74320_O != 0 || flag || this.mc.field_71474_y.field_74319_N || this.mc.field_71442_b.func_78747_a())) {
                renderer.func_180436_i();
                float f1 = 1.0f - (this.prevEquippedProgress + (this.equippedProgress - this.prevEquippedProgress) * partialTicks);
                EntityPlayerSP entityplayersp = this.mc.field_71439_g;
                float f2 = entityplayersp.func_70678_g(partialTicks);
                float f3 = entityplayersp.field_70127_C + (entityplayersp.field_70125_A - entityplayersp.field_70127_C) * partialTicks;
                float f4 = entityplayersp.field_70126_B + (entityplayersp.field_70177_z - entityplayersp.field_70126_B) * partialTicks;
                GlStateManager.func_179140_f();
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)f3, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)f4, (float)0.0f, (float)1.0f, (float)0.0f);
                RenderHelper.func_74519_b();
                GlStateManager.func_179121_F();
                int i = this.mc.field_71441_e.func_175626_b(new BlockPos(entityplayersp.field_70165_t, entityplayersp.field_70163_u + (double)entityplayersp.func_70047_e(), entityplayersp.field_70161_v), 0);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(i & 0xFFFF), (float)(i >> 16));
                float f5 = entityplayersp.field_71164_i + (entityplayersp.field_71155_g - entityplayersp.field_71164_i) * partialTicks;
                float f6 = entityplayersp.field_71163_h + (entityplayersp.field_71154_f - entityplayersp.field_71163_h) * partialTicks;
                GlStateManager.func_179114_b((float)((entityplayersp.field_70125_A - f5) * 0.1f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((entityplayersp.field_70177_z - f6) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179091_B();
                GlStateManager.func_179094_E();
                float f7 = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f2) * (float)Math.PI));
                float f8 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f2) * (float)Math.PI * 2.0f));
                float f9 = -0.2f * MathHelper.func_76126_a((float)(f2 * (float)Math.PI));
                GlStateManager.func_179109_b((float)f7, (float)f8, (float)f9);
                GlStateManager.func_179109_b((float)0.56f, (float)-0.52f, (float)-0.71999997f);
                GlStateManager.func_179109_b((float)0.0f, (float)(f1 * -0.6f), (float)0.0f);
                GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                float f10 = MathHelper.func_76126_a((float)(f2 * f2 * (float)Math.PI));
                float f11 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f2) * (float)Math.PI));
                GlStateManager.func_179114_b((float)(f10 * -20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(f11 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)(f11 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
                this.customRenderers[typeType.ordinal()].renderItem(CustomItemRenderType.EQUIPPED_FIRST_PERSON, event.getHand(), stack, this.mc.field_71441_e, this.mc.field_71439_g);
                GlStateManager.func_179121_F();
                GlStateManager.func_179101_C();
                RenderHelper.func_74518_a();
                renderer.func_175072_h();
            }
            GlStateManager.func_179121_F();
            if (this.mc.field_71474_y.field_74320_O == 0 && !flag) {
                itemRenderer.func_78447_b(partialTicks);
                this.hurtCameraEffect(partialTicks);
            }
            if (this.mc.field_71474_y.field_74336_f) {
                this.setupViewBobbing(partialTicks);
            }
        }
    }

    private void hurtCameraEffect(float partialTicks) {
        if (this.mc.func_175606_aa() instanceof EntityLivingBase) {
            float f2;
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.mc.func_175606_aa();
            float f1 = (float)entitylivingbase.field_70737_aN - partialTicks;
            if (entitylivingbase.func_110143_aJ() <= 0.0f) {
                f2 = (float)entitylivingbase.field_70725_aQ + partialTicks;
                GlStateManager.func_179114_b((float)(40.0f - 8000.0f / (f2 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (f1 < 0.0f) {
                return;
            }
            f1 /= (float)entitylivingbase.field_70738_aO;
            f1 = MathHelper.func_76126_a((float)(f1 * f1 * f1 * f1 * (float)Math.PI));
            f2 = entitylivingbase.field_70739_aP;
            GlStateManager.func_179114_b((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-f1 * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)f2, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void setupViewBobbing(float partialTicks) {
        if (this.mc.func_175606_aa() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this.mc.func_175606_aa();
            float f1 = entityplayer.field_70140_Q - entityplayer.field_70141_P;
            float f2 = -(entityplayer.field_70140_Q + f1 * partialTicks);
            float f3 = entityplayer.field_71107_bF + (entityplayer.field_71109_bG - entityplayer.field_71107_bF) * partialTicks;
            float f4 = entityplayer.field_70727_aS + (entityplayer.field_70726_aT - entityplayer.field_70727_aS) * partialTicks;
            GlStateManager.func_179109_b((float)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 0.5f), (float)(-Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI)) * f3)), (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI - 0.2f)) * f3) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)f4, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private float getFOVModifier(float partialTicks) {
        IBlockState state;
        Entity entity = this.mc.func_175606_aa();
        float f1 = 70.0f;
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_110143_aJ() <= 0.0f) {
            float f2 = (float)((EntityLivingBase)entity).field_70725_aQ + partialTicks;
            f1 /= (1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f;
        }
        if ((state = ActiveRenderInfo.func_186703_a((World)this.mc.field_71441_e, (Entity)entity, (float)partialTicks)).func_185904_a() == Material.field_151586_h) {
            f1 = f1 * 60.0f / 70.0f;
        }
        return f1;
    }

    public void update() {
        Iterator<KillMessage> it = killMessages.iterator();
        while (it.hasNext()) {
            KillMessage message = it.next();
            --message.timer;
            if (message.timer != 0) continue;
            it.remove();
        }
        float fovModifier = 1.0f;
        if (this.mc.func_175606_aa() instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)this.mc.func_175606_aa();
            fovModifier = abstractclientplayer.func_175156_o();
        }
        this.fovModifierHand += (fovModifier - this.fovModifierHand) * 0.5f;
        if (this.fovModifierHand > 1.5f) {
            this.fovModifierHand = 1.5f;
        }
        if (this.fovModifierHand < 0.1f) {
            this.fovModifierHand = 0.1f;
        }
        this.prevEquippedProgress = this.equippedProgress;
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player != null) {
            ItemStack itemstack = player.field_71071_by.func_70448_g();
            boolean equippedGun = false;
            if (this.itemToRender != null && !this.itemToRender.func_190926_b() && !itemstack.func_190926_b()) {
                if (!ItemStack.func_179545_c((ItemStack)this.itemToRender, (ItemStack)itemstack)) {
                    if (!this.itemToRender.func_77973_b().shouldCauseReequipAnimation(this.itemToRender, itemstack, this.equippedItemSlot != player.field_71071_by.field_70461_c)) {
                        this.itemToRender = itemstack;
                        this.equippedItemSlot = player.field_71071_by.field_70461_c;
                        return;
                    }
                    equippedGun = true;
                }
            } else {
                equippedGun = this.itemToRender != null && !this.itemToRender.func_190926_b() || !itemstack.func_190926_b();
            }
            float maxChange = 0.4f;
            float targetProgress = equippedGun ? 0.0f : 1.0f;
            float difference = MathHelper.func_76131_a((float)(targetProgress - this.equippedProgress), (float)(-maxChange), (float)maxChange);
            this.equippedProgress += difference;
            if (this.equippedProgress < 0.1f) {
                this.itemToRender = itemstack;
                this.equippedItemSlot = player.field_71071_by.field_70461_c;
            }
            PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player);
            if (FlansMod.DEBUG && data != null && data.snapshots[0] != null) {
                data.snapshots[0].renderSnapshot();
            }
        }
    }

    public void setPartialTick(float partialTick) {
        this.partialTicks = partialTick;
    }

    public void renderThirdPersonWeapons(RenderLivingEvent.Pre event) {
        ModelBase mainModel = event.getRenderer().func_177087_b();
        EntityLivingBase entity = event.getEntity();
        for (int i = 0; i < 2; ++i) {
            float f5;
            EnumHand hand = EnumHand.values()[i];
            entity.func_184586_b(hand);
            if (!(entity.func_184586_b(hand).func_77973_b() instanceof ItemGun) || !(mainModel instanceof ModelBiped)) continue;
            ModelBiped biped = (ModelBiped)mainModel;
            ItemStack stack = entity.func_184586_b(hand);
            GunType type = ((ItemGun)stack.func_77973_b()).GetType();
            if (type.model == null) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            mainModel.field_78095_p = entity.func_70678_g(this.partialTicks);
            mainModel.field_78093_q = entity.func_184218_aH();
            mainModel.field_78091_s = entity.func_70631_g_();
            float f2 = this.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, this.partialTicks);
            float f3 = this.interpolateRotation(entity.field_70758_at, entity.field_70759_as, this.partialTicks);
            if (Math.abs(entity.field_70760_ar - entity.field_70761_aq) > 30.0f) {
                f2 = entity.field_70761_aq;
            }
            if (Math.abs(entity.field_70758_at - entity.field_70759_as) > 30.0f) {
                f3 = entity.field_70759_as;
            }
            float f4 = f3 - f2;
            if (entity.func_184218_aH() && entity.func_184187_bx() instanceof EntityLivingBase) {
                EntityLivingBase entityLivingBase = (EntityLivingBase)entity.func_184187_bx();
                f2 = this.interpolateRotation(entityLivingBase.field_70760_ar, entityLivingBase.field_70761_aq, this.partialTicks);
                f4 = f3 - f2;
                f5 = MathHelper.func_76142_g((float)f4);
                if (f5 < -85.0f) {
                    f5 = -85.0f;
                }
                if (f5 >= 85.0f) {
                    f5 = 85.0f;
                }
                f2 = f3 - f5;
                if (f5 * f5 > 2500.0f) {
                    f2 += f5 * 0.2f;
                }
            }
            float f9 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * this.partialTicks;
            if (Math.abs(entity.field_70127_C - entity.field_70125_A) > 5.0f) {
                f9 = entity.field_70125_A;
            }
            GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
            f5 = (float)entity.field_70173_aa + this.partialTicks;
            GlStateManager.func_179114_b((float)(180.0f - f2), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)-1.5078125f, (float)0.0f);
            float f7 = entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * this.partialTicks;
            float f8 = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - this.partialTicks);
            if (entity.func_70631_g_()) {
                f8 *= 3.0f;
            }
            if (f7 > 1.0f) {
                f7 = 1.0f;
            }
            GlStateManager.func_179141_d();
            biped.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
            biped.func_78086_a(entity, f8, f7, this.partialTicks);
            biped.func_78087_a(f8, f7, f5, f4, f9, 0.0625f, (Entity)entity);
            GlStateManager.func_179094_E();
            if (hand == EnumHand.MAIN_HAND) {
                biped.field_178723_h.func_78794_c(0.0625f);
                GlStateManager.func_179109_b((float)-0.05f, (float)0.4f, (float)0.05f);
                ClientProxy.gunRenderer.renderItem(CustomItemRenderType.EQUIPPED, hand, stack, this.mc.field_71441_e, entity);
            } else {
                biped.field_178724_i.func_78794_c(0.0625f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.6f, (float)0.0f, (float)-0.05f);
                ClientProxy.gunRenderer.renderOffHandGun((EntityPlayer)entity, stack);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179101_C();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179098_w();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }

    private float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    public void renderPlayer(RenderPlayerEvent.Pre event) {
        PlayerData data = PlayerHandler.getPlayerData(event.getEntityPlayer(), Side.CLIENT);
        RenderLivingBase.NAME_TAG_RANGE = 64.0f;
        RenderLivingBase.NAME_TAG_RANGE_SNEAK = 32.0f;
        if (event.getEntity() instanceof EntityPlayer && FlansModClient.teamInfo != null && FlansModClient.teamInfo.gametype != null && !"No Gametype".equals(FlansModClient.teamInfo.gametype)) {
            Team thePlayerTeam;
            PacketTeamInfo.PlayerScoreData rendering = PacketTeamInfo.getPlayerScoreData(event.getEntity().func_70005_c_());
            PacketTeamInfo.PlayerScoreData player = PacketTeamInfo.getPlayerScoreData(this.mc.field_71439_g.func_70005_c_());
            Team renderingTeam = rendering == null ? Team.spectators : rendering.team.team;
            Team team = thePlayerTeam = player == null ? Team.spectators : player.team.team;
            if (data.skin == null) {
                data.skin = ((AbstractClientPlayer)event.getEntityPlayer()).func_110306_p();
            }
            if (thePlayerTeam == Team.spectators) {
                return;
            }
            if (renderingTeam == Team.spectators) {
                event.setCanceled(true);
                return;
            }
            if (renderingTeam != thePlayerTeam) {
                RenderLivingBase.NAME_TAG_RANGE = 0.0f;
                RenderLivingBase.NAME_TAG_RANGE_SNEAK = 0.0f;
                return;
            }
            if (!FlansModClient.teamInfo.sortedByTeam) {
                RenderLivingBase.NAME_TAG_RANGE = 0.0f;
                RenderLivingBase.NAME_TAG_RANGE_SNEAK = 0.0f;
            }
        }
    }

    public void updatePlayerView() {
        if (this.mc.field_71439_g != null && this.mc.field_71439_g.func_184187_bx() instanceof IControllable) {
            EntitySeat seat;
            if (!this.mc.field_71417_B.equals(this.constantMouseHelper)) {
                Minecraft.func_71410_x().field_71417_B = this.constantMouseHelper;
            }
            if ((seat = ((IControllable)this.mc.field_71439_g.func_184187_bx()).getSeat((EntityLivingBase)this.mc.field_71439_g)) != null && seat.isDriverSeat() && FlansMod.proxy.mouseControlEnabled()) {
                seat.func_184190_l((Entity)this.mc.field_71439_g);
            }
        } else if (this.mc.field_71417_B.equals(this.constantMouseHelper)) {
            Minecraft.func_71410_x().field_71417_B = new MouseHelper();
        }
    }

    public void cameraSetup(EntityViewRenderEvent.CameraSetup event) {
        EntitySeat seat;
        if (this.mc.field_71439_g.func_184187_bx() instanceof IControllable && (seat = ((IControllable)this.mc.field_71439_g.func_184187_bx()).getSeat((EntityLivingBase)this.mc.field_71439_g)) != null) {
            float roll = this.interpolateRotation(seat.getPrevPlayerRoll(), seat.getPlayerRoll(), (float)event.getRenderPartialTicks());
            if (!(seat.driveable instanceof EntityPlane) || this.mc.field_71474_y.field_74320_O == 1) {
                roll = 0.0f;
            }
            event.setRoll(roll);
        }
    }

    public void modifyHUD(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && FlansModClient.currentScope != null) {
            event.setCanceled(true);
            return;
        }
        ScaledResolution scaledresolution = new ScaledResolution(FlansModClient.minecraft);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        Tessellator tessellator = Tessellator.func_178181_a();
        if (!event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
            this.renderScopeOverlay(i, j);
        }
        if (event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            this.renderHitMarker(tessellator, i, j);
        }
        if (!event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            this.renderPlayerAmmo(i, j);
            this.renderTeamInfo(tessellator, i, j);
            this.renderKillMessages(i, j);
            this.renderVehicleDebug();
        }
    }

    private void renderScopeOverlay(int i, int j) {
        ItemStack stack;
        String overlayTexture = null;
        if (FlansModClient.currentScope != null && FlansModClient.currentScope.hasZoomOverlay() && FMLClientHandler.instance().getClient().field_71462_r == null && FlansModClient.zoomProgress > 0.8f) {
            overlayTexture = FlansModClient.currentScope.getZoomOverlay();
        } else if (this.mc.field_71439_g != null && (stack = this.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD)).func_77973_b() instanceof ItemTeamArmour) {
            overlayTexture = ((ItemTeamArmour)stack.func_77973_b()).type.overlay;
        }
        if (overlayTexture != null) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            this.mc.field_71446_o.func_110577_a(FlansModResourceHandler.getScope(overlayTexture));
            WorldRenderer worldrenderer = FlansModClient.getWorldRenderer();
            worldrenderer.startDrawingQuads();
            worldrenderer.addVertexWithUV((double)i / 2.0 - (double)(2 * j), j, -90.0, 0.0, 1.0);
            worldrenderer.addVertexWithUV((double)i / 2.0 + (double)(2 * j), j, -90.0, 1.0, 1.0);
            worldrenderer.addVertexWithUV((double)i / 2.0 + (double)(2 * j), 0.0, -90.0, 1.0, 0.0);
            worldrenderer.addVertexWithUV((double)i / 2.0 - (double)(2 * j), 0.0, -90.0, 0.0, 0.0);
            worldrenderer.draw();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderHitMarker(Tessellator tessellator, int i, int j) {
        if (FlansModClient.hitMarkerTime > 0) {
            this.mc.field_71446_o.func_110577_a(hitMarker);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.max(((float)FlansModClient.hitMarkerTime - 10.0f + this.partialTicks) / 10.0f, 0.0f));
            double zLevel = 0.0;
            WorldRenderer worldrenderer = FlansModClient.getWorldRenderer();
            worldrenderer.startDrawingQuads();
            worldrenderer.addVertexWithUV((double)i / 2.0 - 4.0, (double)j / 2.0 + 5.0, zLevel, 0.0, 0.5625);
            worldrenderer.addVertexWithUV((double)i / 2.0 + 5.0, (double)j / 2.0 + 5.0, zLevel, 0.5625, 0.5625);
            worldrenderer.addVertexWithUV((double)i / 2.0 + 5.0, (double)j / 2.0 - 4.0, zLevel, 0.5625, 0.0);
            worldrenderer.addVertexWithUV((double)i / 2.0 - 4.0, (double)j / 2.0 - 4.0, zLevel, 0.0, 0.0);
            worldrenderer.draw();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
        }
    }

    private void renderPlayerAmmo(int i, int j) {
        if (this.mc.field_71439_g != null) {
            GunType gunType;
            ItemGun gunItem;
            ItemStack stack;
            int iNumHandsUsed = 0;
            for (EnumHand hand : EnumHand.values()) {
                stack = this.mc.field_71439_g.func_184586_b(hand);
                if (!(stack.func_77973_b() instanceof ItemGun)) continue;
                gunItem = (ItemGun)stack.func_77973_b();
                gunType = gunItem.GetType();
                if (gunType.oneHanded) {
                    ++iNumHandsUsed;
                    continue;
                }
                iNumHandsUsed += 2;
            }
            if (iNumHandsUsed > 2) {
                this.mc.field_71466_p.func_78276_b("Too many guns, not enough hands", i / 2 - 85, j - 35, 0);
                this.mc.field_71466_p.func_78276_b("Too many guns, not enough hands", i / 2 - 86, j - 36, 0xFFFFFF);
            } else {
                for (EnumHand hand : EnumHand.values()) {
                    stack = this.mc.field_71439_g.func_184586_b(hand);
                    if (!(stack.func_77973_b() instanceof ItemGun)) continue;
                    gunItem = (ItemGun)stack.func_77973_b();
                    gunType = gunItem.GetType();
                    int x = 0;
                    for (int n = 0; n < gunType.numAmmoItemsInGun; ++n) {
                        ItemStack bulletStack = ((ItemGun)stack.func_77973_b()).getBulletItemStack(stack, n);
                        if (bulletStack == null || bulletStack.func_190926_b() || bulletStack.func_77952_i() >= bulletStack.func_77958_k()) continue;
                        RenderHelper.func_74520_c();
                        GlStateManager.func_179091_B();
                        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                        int xPos = hand == EnumHand.MAIN_HAND ? i / 2 + 16 + x : i / 2 - 32 - x;
                        this.drawSlotInventory(this.mc.field_71466_p, bulletStack, xPos, j - 65);
                        GlStateManager.func_179101_C();
                        RenderHelper.func_74518_a();
                        String s = bulletStack.func_77958_k() - bulletStack.func_77952_i() + "/" + bulletStack.func_77958_k();
                        if (bulletStack.func_77958_k() == 1) {
                            s = "";
                        }
                        xPos = hand == EnumHand.MAIN_HAND ? i / 2 + 32 + x : i / 2 - 16 - x;
                        this.mc.field_71466_p.func_78276_b(s, xPos, j - 59, 0);
                        this.mc.field_71466_p.func_78276_b(s, xPos + 1, j - 60, 0xFFFFFF);
                        x += 16 + this.mc.field_71466_p.func_78256_a(s);
                    }
                }
            }
        }
    }

    private void renderTeamInfo(Tessellator tessellator, int i, int j) {
        PacketTeamInfo teamInfo = FlansModClient.teamInfo;
        if (!(teamInfo == null || FlansModClient.minecraft.field_71439_g == null || teamInfo.numTeams <= 0 && teamInfo.sortedByTeam || PacketTeamInfo.getPlayerScoreData(FlansModClient.minecraft.field_71439_g.func_70005_c_()) == null)) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            this.mc.field_71446_o.func_110577_a(GuiTeamScores.texture);
            WorldRenderer worldrenderer = FlansModClient.getWorldRenderer();
            worldrenderer.startDrawingQuads();
            worldrenderer.addVertexWithUV((double)i / 2.0 - 43.0, 27.0, -90.0, 0.33203125, 0.10546875);
            worldrenderer.addVertexWithUV((double)i / 2.0 + 43.0, 27.0, -90.0, 0.66796875, 0.10546875);
            worldrenderer.addVertexWithUV((double)i / 2.0 + 43.0, 0.0, -90.0, 0.66796875, 0.0);
            worldrenderer.addVertexWithUV((double)i / 2.0 - 43.0, 0.0, -90.0, 0.33203125, 0.0);
            worldrenderer.draw();
            if (teamInfo.numTeams == 2 && teamInfo.sortedByTeam) {
                if (teamInfo.teamData == null || teamInfo.teamData[0] == null || teamInfo.teamData[0].team == null || teamInfo.teamData[1] == null || teamInfo.teamData[1].team == null) {
                    FlansMod.Assert(false, "Failure in team data overlay");
                    return;
                }
                int colour = teamInfo.teamData[0].team.teamColour;
                GlStateManager.func_179131_c((float)((float)(colour >> 16 & 0xFF) / 256.0f), (float)((float)(colour >> 8 & 0xFF) / 256.0f), (float)((float)(colour & 0xFF) / 256.0f), (float)1.0f);
                worldrenderer.startDrawingQuads();
                worldrenderer.addVertexWithUV((double)i / 2.0 - 43.0, 27.0, -90.0, 0.0, 0.48828125);
                worldrenderer.addVertexWithUV((double)i / 2.0 - 19.0, 27.0, -90.0, 0.09375, 0.48828125);
                worldrenderer.addVertexWithUV((double)i / 2.0 - 19.0, 0.0, -90.0, 0.09375, 0.3828125);
                worldrenderer.addVertexWithUV((double)i / 2.0 - 43.0, 0.0, -90.0, 0.0, 0.3828125);
                worldrenderer.draw();
                colour = teamInfo.teamData[1].team.teamColour;
                GlStateManager.func_179131_c((float)((float)(colour >> 16 & 0xFF) / 256.0f), (float)((float)(colour >> 8 & 0xFF) / 256.0f), (float)((float)(colour & 0xFF) / 256.0f), (float)1.0f);
                worldrenderer.startDrawingQuads();
                worldrenderer.addVertexWithUV((double)i / 2.0 + 19.0, 27.0, -90.0, 0.2421875, 0.48828125);
                worldrenderer.addVertexWithUV((double)i / 2.0 + 43.0, 27.0, -90.0, 0.3359375, 0.48828125);
                worldrenderer.addVertexWithUV((double)i / 2.0 + 43.0, 0.0, -90.0, 0.3359375, 0.3828125);
                worldrenderer.addVertexWithUV((double)i / 2.0 + 19.0, 0.0, -90.0, 0.2421875, 0.3828125);
                worldrenderer.draw();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179126_j();
                GlStateManager.func_179141_d();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (teamInfo.teamData[0] != null && teamInfo.teamData[1] != null) {
                    this.mc.field_71466_p.func_78276_b(teamInfo.teamData[0].score + "", i / 2 - 35, 9, 0);
                    this.mc.field_71466_p.func_78276_b(teamInfo.teamData[0].score + "", i / 2 - 36, 8, 0xFFFFFF);
                    this.mc.field_71466_p.func_78276_b(teamInfo.teamData[1].score + "", i / 2 + 35 - this.mc.field_71466_p.func_78256_a(teamInfo.teamData[1].score + ""), 9, 0);
                    this.mc.field_71466_p.func_78276_b(teamInfo.teamData[1].score + "", i / 2 + 34 - this.mc.field_71466_p.func_78256_a(teamInfo.teamData[1].score + ""), 8, 0xFFFFFF);
                }
            }
            this.mc.field_71466_p.func_78276_b(teamInfo.gametype + "", i / 2 + 48, 9, 0);
            this.mc.field_71466_p.func_78276_b(teamInfo.gametype + "", i / 2 + 47, 8, 0xFFFFFF);
            this.mc.field_71466_p.func_78276_b(teamInfo.map + "", i / 2 - 47 - this.mc.field_71466_p.func_78256_a(teamInfo.map + ""), 9, 0);
            this.mc.field_71466_p.func_78276_b(teamInfo.map + "", i / 2 - 48 - this.mc.field_71466_p.func_78256_a(teamInfo.map + ""), 8, 0xFFFFFF);
            int secondsLeft = teamInfo.timeLeft / 20;
            int minutesLeft = secondsLeft / 60;
            String timeLeft = minutesLeft + ":" + ((secondsLeft %= 60) < 10 ? "0" + secondsLeft : Integer.valueOf(secondsLeft));
            this.mc.field_71466_p.func_78276_b(timeLeft, i / 2 - this.mc.field_71466_p.func_78256_a(timeLeft) / 2 - 1, 29, 0);
            this.mc.field_71466_p.func_78276_b(timeLeft, i / 2 - this.mc.field_71466_p.func_78256_a(timeLeft) / 2, 30, 0xFFFFFF);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String playerUsername = FlansModClient.minecraft.field_71439_g.func_70005_c_();
            PacketTeamInfo.PlayerScoreData data = PacketTeamInfo.getPlayerScoreData(playerUsername);
            if (data != null) {
                this.mc.field_71466_p.func_78276_b(data.score + "", i / 2 - 7, 1, 0);
                this.mc.field_71466_p.func_78276_b(data.kills + "", i / 2 - 7, 9, 0);
                this.mc.field_71466_p.func_78276_b(data.deaths + "", i / 2 - 7, 17, 0);
            }
        }
    }

    private void renderKillMessages(int i, int j) {
        for (KillMessage killMessage : killMessages) {
            String message = "\u00a7" + killMessage.killerName + (killMessage.headshot ? "         " : "     ") + "\u00a7" + killMessage.killedName;
            this.mc.field_71466_p.func_78276_b(message, i - this.mc.field_71466_p.func_78256_a(message) - 6, j - 32 - killMessage.line * 16, 0xFFFFFF);
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        for (KillMessage killMessage : killMessages) {
            this.drawSlotInventory(this.mc.field_71466_p, new ItemStack(killMessage.weapon.item, 1, killMessage.paint), i - this.mc.field_71466_p.func_78256_a((killMessage.headshot ? "         " : "     ") + killMessage.killedName), j - 36 - killMessage.line * 16);
            if (!killMessage.headshot) continue;
            this.drawSlotInventory(this.mc.field_71466_p, new ItemStack(FlansMod.crosshairsymbol), i - this.mc.field_71466_p.func_78256_a("     " + killMessage.killedName), j - 36 - killMessage.line * 16);
        }
        GlStateManager.func_179084_k();
        RenderHelper.func_74518_a();
    }

    private void renderVehicleDebug() {
        EntityDriveable ent;
        if (this.mc.field_71439_g.func_184187_bx() instanceof EntitySeat && (ent = ((EntitySeat)this.mc.field_71439_g.func_184187_bx()).driveable) != null) {
            double dX = ent.field_70165_t - ent.field_70169_q;
            double dY = ent.field_70163_u - ent.field_70167_r;
            double dZ = ent.field_70161_v - ent.field_70166_s;
            float speed = (float)Math.sqrt(dX * dX + dY * dY + dZ * dZ) * 1000.0f / 16.0f;
            speed = (float)((int)(speed * 10.0f)) / 10.0f;
            this.mc.field_71466_p.func_78276_b("Speed: " + speed + " chunks per hour", 2, 2, 0xFFFFFF);
            if (FlansMod.DEBUG) {
                this.mc.field_71466_p.func_78276_b("Throttle : " + ent.throttle, 2, 12, 0xFFFFFF);
            }
        }
    }

    private void drawSlotInventory(FontRenderer fontRenderer, ItemStack itemstack, int i, int j) {
        if (itemstack == null || itemstack.func_190926_b()) {
            return;
        }
        itemRenderer.func_175042_a(itemstack, i, j);
        itemRenderer.func_180453_a(fontRenderer, itemstack, i, j, null);
    }

    public static void addKillMessage(boolean headshot, InfoType infoType, String killer, String killed) {
        for (KillMessage killMessage : killMessages) {
            ++killMessage.line;
            if (killMessage.line <= 10) continue;
            killMessage.timer = 0;
        }
        killMessages.add(new KillMessage(headshot, infoType, killer, killed));
    }

    private static class KillMessage {
        public String killerName = "";
        public String killedName = "";
        public InfoType weapon = null;
        public int paint = 0;
        public int timer = 0;
        public int line = 0;
        public boolean headshot;

        public KillMessage(boolean head, InfoType infoType, String killer, String killed) {
            this.headshot = head;
            this.killerName = killer;
            this.killedName = killed;
            this.weapon = infoType;
            this.line = 0;
            this.timer = 200;
            for (Object o : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
                ItemStack stack;
                if (!((EntityPlayer)o).getDisplayNameString().equals(this.killerName) || !((stack = ((EntityPlayer)o).func_184614_ca()).func_77973_b() instanceof IPaintableItem)) continue;
                this.paint = stack.func_77952_i();
                break;
            }
        }
    }
}

