/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui;

import com.flansmod.client.handlers.FlansModResourceHandler;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.parts.EnumPartCategory;
import com.flansmod.common.parts.ItemPart;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.EnumType;
import io.vavr.collection.List;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.lang3.NotImplementedException;

public class GuiDriveableCrafting
extends GuiScreen {
    private static final ResourceLocation texture = new ResourceLocation("flansmod", "gui/driveableCrafting.png");
    private static final int CRAFT_BUTTON_ID = 0;
    private static final int BLUEPRINTS_UP_BUTTON_ID = 1;
    private static final int BLUEPRINTS_DOWN_BUTTON_ID = 2;
    private static final int RECIPE_UP_BUTTON_ID = 3;
    private static final int RECIPE_DOWN_BUTTON_ID = 4;
    private InventoryPlayer inventory;
    private Minecraft mc;
    private int guiOriginX;
    private int guiOriginY;
    private static int blueprintsScrollPos = 0;
    private int recipeScrollPos = 0;
    private static int selectedBlueprint = 0;
    private float spinner = 0.0f;
    private boolean canCraft = false;
    public static final int BLUEPRINT_ROW_COUNT = 4;
    public static final int BLUEPRINT_COLUMN_COUNT = 8;
    public static final int BLUEPRINT_WIDTH = 18;
    public static final int BLUEPRINT_HEIGHT = 18;
    private int blueprintsOriginX;
    private int blueprintsOriginY;
    private int statsOriginX;
    private int statsOriginY;
    private int vehicleCraftingTextX;
    private int vehicleCraftingTextY;
    private int requiresTextX;
    private int requiresTextY;
    private int engineTextX;
    private int engineTextY;
    public static final int GUI_WIDTH = 176;
    public static final int GUI_HEIGHT = 234;
    public static final int WHITE = Color.white.getRGB();
    private int recipeOriginX;
    private int recipeOriginY;
    private int engineOriginX;
    private int engineOriginY;
    private int modelCenterX;
    private int modelCenterY;
    private GuiButton craftButton;
    public static final int RECIPE_ROW_COUNT = 3;
    public static final int RECIPE_COLUMN_COUNT = 4;
    private ArrowButton blueprintsDownButton;
    private ArrowButton recipeDownButton;
    private ArrowButton recipeUpButton;
    private ArrowButton blueprintsUpButton;

    public GuiDriveableCrafting(InventoryPlayer playerInventory) {
        this.inventory = playerInventory;
        this.mc = FMLClientHandler.instance().getClient();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiOriginX = this.field_146294_l / 2 - 88;
        this.guiOriginY = this.field_146295_m / 2 - 117;
        this.blueprintsOriginX = this.guiOriginX + 8;
        this.blueprintsOriginY = this.guiOriginY + 18;
        this.statsOriginX = this.guiOriginX + 82;
        this.statsOriginY = this.guiOriginY + 64 + 36;
        this.vehicleCraftingTextX = this.guiOriginX + 6;
        this.vehicleCraftingTextY = this.guiOriginY + 6;
        this.requiresTextX = this.guiOriginX + 6;
        this.requiresTextY = this.guiOriginY + 125 + 36;
        this.engineTextX = this.guiOriginX + 114;
        this.engineTextY = this.guiOriginY + 141 + 36;
        this.recipeOriginX = this.guiOriginX + 8;
        this.recipeOriginY = this.guiOriginY + 138 + 36;
        this.engineOriginX = this.guiOriginX + 152;
        this.engineOriginY = this.guiOriginY + 138 + 36;
        this.modelCenterX = this.guiOriginX + 42;
        this.modelCenterY = this.guiOriginY + 89 + 36;
        this.craftButton = new GuiButton(0, this.guiOriginX + 110, this.guiOriginY + 162 + 36, 40, 20, "Craft");
        this.field_146292_n.add(this.craftButton);
        this.blueprintsUpButton = new ArrowButton(1, this.guiOriginX + 157, this.guiOriginY + 21, Direction.UP);
        this.field_146292_n.add(this.blueprintsUpButton);
        this.blueprintsDownButton = new ArrowButton(2, this.guiOriginX + 157, this.guiOriginY + 39 + 36, Direction.DOWN);
        this.field_146292_n.add(this.blueprintsDownButton);
        this.recipeUpButton = new ArrowButton(3, this.guiOriginX + 83, this.guiOriginY + 141 + 36, Direction.UP);
        this.field_146292_n.add(this.recipeUpButton);
        this.recipeDownButton = new ArrowButton(4, this.guiOriginX + 83, this.guiOriginY + 177 + 36, Direction.DOWN);
        this.field_146292_n.add(this.recipeDownButton);
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                FlansMod.proxy.craftDriveable(this.inventory.field_70458_d, DriveableType.types.get(selectedBlueprint));
                break;
            }
            case 1: {
                if (blueprintsScrollPos <= 0) break;
                --blueprintsScrollPos;
                break;
            }
            case 2: {
                if (blueprintsScrollPos * 8 + 16 >= DriveableType.types.size()) break;
                ++blueprintsScrollPos;
                break;
            }
            case 3: {
                if (this.recipeScrollPos <= 0) break;
                --this.recipeScrollPos;
                break;
            }
            case 4: {
                DriveableType selectedType = DriveableType.types.get(selectedBlueprint);
                int totalCells = 12;
                if (this.recipeScrollPos * 4 + totalCells >= selectedType.driveableRecipe.size()) break;
                ++this.recipeScrollPos;
            }
        }
        this.updateButtons();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.mc.field_71446_o.func_110577_a(texture);
        this.func_73729_b(this.guiOriginX, this.guiOriginY, 0, 0, 176, 234);
        this.func_73731_b(this.field_146289_q, "Vehicle Crafting", this.vehicleCraftingTextX, this.vehicleCraftingTextY, WHITE);
        List<ItemToRender> itemsToRender = this.getBlueprintItemsToRender();
        DriveableType selectedType = DriveableType.types.get(selectedBlueprint);
        this.drawPreview(selectedType);
        this.drawStats(selectedType);
        this.func_73731_b(this.field_146289_q, "Engine", this.engineTextX, this.engineTextY, WHITE);
        this.func_73731_b(this.field_146289_q, selectedType.numEngines() + "x", this.engineTextX - 14, this.engineTextY, WHITE);
        this.canCraft = true;
        itemsToRender = itemsToRender.pushAll(this.getRecipeItemsToRender(selectedType));
        ItemStack bestEngineStack = this.getBestEngineStackForType(selectedType);
        itemsToRender = itemsToRender.pushAll(this.getEngineItemToRender(bestEngineStack));
        this.craftButton.field_146124_l = this.canCraft;
        GlStateManager.func_179140_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        itemsToRender.forEach(item -> this.drawSlotInventory(item.itemStack, item.x, item.y, mouseX, mouseY));
    }

    private List<ItemToRender> getEngineItemToRender(ItemStack engineStack) {
        List<ItemToRender> itemsToRender = List.empty();
        this.mc.field_71446_o.func_110577_a(texture);
        if (engineStack.func_190926_b()) {
            this.func_73729_b(this.engineOriginX, this.engineOriginY, 195, 11, 16, 16);
            this.canCraft = false;
        } else {
            itemsToRender = itemsToRender.push(new ItemToRender(engineStack, this.engineOriginX, this.engineOriginY));
        }
        return itemsToRender;
    }

    private ItemStack getBestEngineStackForType(DriveableType selectedType) {
        HashMap<PartType, ItemStack> engines = this.getPlayersEnginesForType(selectedType);
        float bestEngineSpeed = -1.0f;
        ItemStack bestEngineStack = ItemStack.field_190927_a.func_77946_l();
        for (PartType part : engines.keySet()) {
            if (!(part.engineSpeed > bestEngineSpeed) || engines.get(part).func_190916_E() < selectedType.numEngines()) continue;
            bestEngineSpeed = part.engineSpeed;
            bestEngineStack = engines.get(part);
        }
        return bestEngineStack;
    }

    private HashMap<PartType, ItemStack> getPlayersEnginesForType(DriveableType selectedType) {
        HashMap<PartType, ItemStack> engines = new HashMap<PartType, ItemStack>();
        for (ItemStack itemStack : this.inventory.field_70462_a) {
            if (!(itemStack.func_77973_b() instanceof ItemPart)) continue;
            PartType partType = ((ItemPart)itemStack.func_77973_b()).type;
            if (partType.category != EnumPartCategory.ENGINE || !partType.worksWith.contains((Object)EnumType.getFromObject(selectedType))) continue;
            if (engines.containsKey(partType)) {
                engines.get(partType).func_190920_e(engines.get(partType).func_190916_E() + itemStack.func_190916_E());
                continue;
            }
            engines.put(partType, itemStack);
        }
        return engines;
    }

    private List<ItemToRender> getRecipeItemsToRender(DriveableType selectedType) {
        List<ItemToRender> itemsToRender = List.empty();
        this.func_73731_b(this.field_146289_q, "Requires", this.requiresTextX, this.requiresTextY, WHITE);
        for (int row = 0; row < 3; ++row) {
            for (int column = 3; column >= 0; --column) {
                ItemStack itemStack;
                int pageStartIndex = this.recipeScrollPos * 4;
                int rowStartInPageIndex = row * 4;
                int recipeItemNumber = pageStartIndex + rowStartInPageIndex + column;
                if (recipeItemNumber >= selectedType.driveableRecipe.size()) continue;
                ItemStack recipeStack = selectedType.driveableRecipe.get(recipeItemNumber);
                int totalAmountFound = 0;
                Iterator iterator = this.inventory.field_70462_a.iterator();
                while (iterator.hasNext() && ((itemStack = (ItemStack)iterator.next()).func_77973_b() != recipeStack.func_77973_b() || itemStack.func_77952_i() != recipeStack.func_77952_i() || (totalAmountFound += itemStack.func_190916_E()) != recipeStack.func_190916_E())) {
                }
                if (totalAmountFound < recipeStack.func_190916_E()) {
                    this.mc.field_71446_o.func_110577_a(texture);
                    this.func_73729_b(this.recipeOriginX + column * 18, this.recipeOriginY + row * 18, 195, 11, 16, 16);
                    this.canCraft = false;
                }
                itemsToRender = itemsToRender.push(new ItemToRender(recipeStack, this.recipeOriginX + column * 18, this.recipeOriginY + row * 18));
            }
        }
        return itemsToRender;
    }

    private void drawStats(DriveableType selectedType) {
        GlStateManager.func_179140_f();
        String recipeName = selectedType.name;
        if (recipeName.length() > 16) {
            recipeName = recipeName.substring(0, 15) + "...";
        }
        this.func_73731_b(this.field_146289_q, recipeName, this.statsOriginX, this.statsOriginY, WHITE);
        this.func_73731_b(this.field_146289_q, "Cargo Slots : " + selectedType.numCargoSlots, this.statsOriginX, this.statsOriginY + 10, WHITE);
        this.func_73731_b(this.field_146289_q, "Bomb Slots : " + selectedType.numBombSlots, this.statsOriginX, this.statsOriginY + 20, WHITE);
        this.func_73731_b(this.field_146289_q, "Passengers : " + selectedType.numPassengers, this.statsOriginX, this.statsOriginY + 30, WHITE);
        this.func_73731_b(this.field_146289_q, "Guns : " + selectedType.ammoSlots(), this.statsOriginX, this.statsOriginY + 40, WHITE);
    }

    private void drawPreview(DriveableType selectedType) {
        this.spinner += 1.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.modelCenterX, (float)this.modelCenterY, (float)100.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179091_B();
        if (selectedType instanceof MechaType) {
            GlStateManager.func_179109_b((float)0.0f, (float)15.0f, (float)0.0f);
        }
        GlStateManager.func_179152_a((float)(-50.0f * selectedType.modelScale / selectedType.cameraDistance), (float)(50.0f * selectedType.modelScale / selectedType.cameraDistance), (float)(50.0f * selectedType.modelScale / selectedType.cameraDistance));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(this.spinner / 5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.mc.field_71446_o.func_110577_a(FlansModResourceHandler.getTexture(selectedType));
        selectedType.model.render(selectedType);
        GlStateManager.func_179121_F();
    }

    private List<ItemToRender> getBlueprintItemsToRender() {
        List<ItemToRender> itemsToRender = List.empty();
        for (int row = 3; row >= 0; --row) {
            for (int column = 0; column < 8; ++column) {
                int pageStartIndex = blueprintsScrollPos * 8;
                int rowStartInPageIndex = row * 8;
                int blueprintNumber = pageStartIndex + rowStartInPageIndex + column;
                if (blueprintNumber == selectedBlueprint) {
                    this.mc.field_71446_o.func_110577_a(texture);
                    this.func_73729_b(this.blueprintsOriginX + column * 18, this.blueprintsOriginY + row * 18, 213, 11, 16, 16);
                }
                if (blueprintNumber >= DriveableType.types.size()) continue;
                DriveableType type = DriveableType.types.get(blueprintNumber);
                itemsToRender = itemsToRender.push(new ItemToRender(new ItemStack(type.item), this.blueprintsOriginX + column * 18, this.blueprintsOriginY + row * 18));
            }
        }
        return itemsToRender;
    }

    private void drawSlotInventory(ItemStack itemstack, int x, int y, int mouseX, int mouseY) {
        if (itemstack == null) {
            return;
        }
        this.field_146296_j.func_175042_a(itemstack, x, y);
        this.field_146296_j.func_180453_a(this.field_146289_q, itemstack, x, y, null);
        this.drawTooltip(itemstack.func_82833_r(), x, y, mouseX, mouseY, 16, 16);
    }

    private void drawTooltip(String text, int x, int y, int mouseX, int mouseY, int iconWidth, int iconHeight) {
        if (mouseX >= x && mouseY >= y && mouseX < x + iconWidth && mouseY < y + iconHeight) {
            this.func_146279_a(text, mouseX, mouseY);
        }
    }

    protected void func_73869_a(char c, int i) {
        if (i == 1 || i == this.mc.field_71474_y.field_151445_Q.func_151463_i()) {
            this.mc.field_71439_g.func_71053_j();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 || mouseButton == 1) {
            for (int row = 0; row < 4; ++row) {
                for (int column = 0; column < 8; ++column) {
                    int rowStartInPageIndex;
                    int pageStartIndex;
                    int result;
                    if (mouseX < this.blueprintsOriginX + column * 18 || mouseX >= this.blueprintsOriginX + column * 18 + 18 || mouseY < this.blueprintsOriginY + row * 18 || mouseY >= this.blueprintsOriginY + row * 18 + 18 || (result = (pageStartIndex = blueprintsScrollPos * 8) + (rowStartInPageIndex = row * 8) + column) >= DriveableType.types.size()) continue;
                    this.recipeScrollPos = 0;
                    selectedBlueprint = result;
                    return;
                }
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void updateButtons() {
        this.blueprintsUpButton.field_146124_l = blueprintsScrollPos > 0;
        int totalBlueprintsCells = 32;
        this.blueprintsDownButton.field_146124_l = blueprintsScrollPos * 8 + totalBlueprintsCells < DriveableType.types.size() - 1;
        this.recipeUpButton.field_146124_l = this.recipeScrollPos > 0;
        int totalRecipeItems = 12;
        DriveableType selectedType = DriveableType.types.get(selectedBlueprint);
        this.recipeDownButton.field_146124_l = this.recipeScrollPos * 4 + totalRecipeItems < selectedType.driveableRecipe.size() - 1;
    }

    private static enum Direction {
        UP,
        DOWN;

    }

    private static class ItemToRender {
        public ItemStack itemStack;
        public int x;
        public int y;

        public ItemToRender(ItemStack itemStack, int x, int y) {
            this.itemStack = itemStack;
            this.x = x;
            this.y = y;
        }
    }

    private static class ArrowButton
    extends GuiButton {
        public static final int WIDTH = 10;
        public static final int HEIGHT = 10;
        public final int enabledTextureX;
        public final int enabledTextureY = 0;
        public final int disabledTextureX;
        public final int disabledTextureY = 0;
        public final Direction direction;

        public ArrowButton(int buttonId, int x, int y, Direction direction) {
            super(buttonId, x, y, 10, 10, "");
            this.direction = direction;
            switch (direction) {
                case UP: {
                    this.enabledTextureX = 216;
                    this.disabledTextureX = 196;
                    break;
                }
                case DOWN: {
                    this.enabledTextureX = 226;
                    this.disabledTextureX = 206;
                    break;
                }
                default: {
                    throw new NotImplementedException("Texture location not set for direction");
                }
            }
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.field_71446_o.func_110577_a(texture);
                if (this.field_146124_l) {
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, this.enabledTextureX, 0, 10, 10);
                } else {
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, this.disabledTextureX, 0, 10, 10);
                }
            }
        }
    }
}

