/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui;

import com.flansmod.client.ClientProxy;
import com.flansmod.client.handlers.FlansModResourceHandler;
import com.flansmod.client.model.CustomItemRenderType;
import com.flansmod.client.model.ModelAttachment;
import com.flansmod.client.model.ModelDriveable;
import com.flansmod.client.model.RenderGun;
import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.network.PacketGunPaint;
import com.flansmod.common.paintjob.ContainerPaintjobTable;
import com.flansmod.common.paintjob.TileEntityPaintjobTable;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.IPaintableItem;
import com.flansmod.common.types.PaintableType;
import com.flansmod.common.vector.Vector3f;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;

public class GuiPaintjobTable
extends GuiContainer {
    private static final ResourceLocation texture = new ResourceLocation("flansmod", "gui/paintjobTable.png");
    private static final Random rand = new Random();
    private static final int paletteSizeX = 18;
    private static final int paletteSizeY = 4;
    private static final float componentBarLength = 68.0f;
    private Paintjob hoveringOver = null;
    private int mouseX;
    private int mouseY;
    private InventoryPlayer inventory;
    private boolean inCustomMode;
    private float customModeTransitionTimer = 0.0f;
    private float transitionSpeed = 0.9f;
    private int prevMainPageX;
    private RotatedAxes modelAxes = new RotatedAxes();
    private RotatedAxes prevModelAxes = new RotatedAxes();
    private static int[][] paletteColours = new int[18][4];
    private static int[] baseColours = new int[]{0, 0xFFFFFF, 0xFF0000, 0xFF5500, 0xFFAA00, 0xFFFF00, 0xAAFF00, 0x55FF00, 65280, 65365, 65450, 65535, 43775, 22015, 255, 0x5500FF, 0xAA00FF, 0xFF00FF};
    private static int currentColour;
    private static int flatTextureWindowX;
    private static int flatTextureWindowY;
    private static boolean movingFlatTextureWindow;
    private static DynamicTexture dynamicTexture;
    private static int dynamicTextureX;
    private static int dynamicTextureY;

    private static void ResetPalette() {
        for (int x = 0; x < 18; ++x) {
            for (int y = 0; y < 4; ++y) {
                int red = baseColours[x] >> 16 & 0xFF;
                int green = baseColours[x] >> 8 & 0xFF;
                int blue = baseColours[x] >> 0 & 0xFF;
                if (x == 0) {
                    green = blue = 255 * y / 7;
                    red = blue;
                } else if (x == 1) {
                    green = blue = 255 * (y + 4) / 7;
                    red = blue;
                } else {
                    if (y == 3) {
                        red /= 2;
                        green /= 2;
                        blue /= 2;
                    }
                    if (y == 1) {
                        red = 255 - (255 - red) / 2;
                        green = 255 - (255 - green) / 2;
                        blue = 255 - (255 - blue) / 2;
                    }
                    if (y == 0) {
                        red = 255 - (255 - red) / 4;
                        green = 255 - (255 - green) / 4;
                        blue = 255 - (255 - blue) / 4;
                    }
                }
                GuiPaintjobTable.paletteColours[x][y] = (red << 16) + (green << 8) + blue;
            }
        }
    }

    public GuiPaintjobTable(InventoryPlayer inv, World w, TileEntityPaintjobTable te) {
        super((Container)new ContainerPaintjobTable(inv, w, te));
        this.inventory = inv;
        this.field_146999_f = 224;
        this.field_147000_g = 264;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.prevModelAxes = this.modelAxes.clone();
        if (this.inCustomMode) {
            this.customModeTransitionTimer = 1.0f - (1.0f - this.customModeTransitionTimer) * this.transitionSpeed;
        } else {
            this.customModeTransitionTimer *= this.transitionSpeed;
            this.modelAxes.rotateLocalYaw(2.5f);
        }
        int xPos = this.GetMainPageX();
        int dPos = xPos - this.prevMainPageX;
        for (int i = 0; i < 38; ++i) {
            this.field_147002_h.func_75139_a((int)i).field_75223_e += dPos;
        }
        if (movingFlatTextureWindow) {
            flatTextureWindowX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.field_147003_i;
            flatTextureWindowY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.field_147009_r;
        }
        this.prevMainPageX = xPos;
    }

    private int GetMainPageX() {
        return (int)(-500.0f * this.customModeTransitionTimer);
    }

    private int GetMainPageY() {
        return 0;
    }

    private int GetCustomPageX() {
        return (int)(500.0f * (1.0f - this.customModeTransitionTimer));
    }

    private int GetCustomPageY() {
        return 0;
    }

    private int GetFlatTextureWindowX() {
        return this.GetCustomPageX() + flatTextureWindowX;
    }

    private int GetFlatTextureWindowY() {
        return this.GetCustomPageY() + flatTextureWindowY;
    }

    private Vector3f GetRenderOrigin() {
        return new Vector3f(100.0f, 64.0f, 100.0f);
    }

    protected void func_146979_b(int x, int y) {
        if (this.customModeTransitionTimer <= 0.999f) {
            this.field_146289_q.func_78276_b("Inventory", this.GetMainPageX() + 8, this.GetMainPageY() + (this.field_147000_g - 94) + 2, 0x404040);
            this.field_146289_q.func_78276_b("Paintjob Table", this.GetMainPageX() + 8, this.GetMainPageY() + 6, 0x404040);
        }
        if (this.customModeTransitionTimer >= 0.001f) {
            int xOrigin = (this.field_146294_l - this.field_146999_f) / 2 + this.GetCustomPageX() - 32;
            int yOrigin = (this.field_146295_m - this.field_147000_g) / 2 + this.GetCustomPageY();
            this.field_146289_q.func_78276_b("Confirm", xOrigin - 7, yOrigin + 169, 0);
            this.field_146289_q.func_78276_b("Cancel", xOrigin - 6, yOrigin + 186, 0);
            this.field_146289_q.func_78276_b("Inventory", xOrigin - 12, yOrigin + 203, 0);
        }
        Vector3f renderOrigin = this.GetRenderOrigin();
        ItemStack paintableStack = this.field_147002_h.func_75139_a(0).func_75211_c();
        if (paintableStack != null && paintableStack.func_77973_b() instanceof IPaintableItem) {
            ItemStack tempStack = paintableStack.func_77946_l();
            if (this.hoveringOver != null) {
                tempStack.func_77964_b(this.hoveringOver.ID);
            }
            PaintableType paintableType = ((IPaintableItem)paintableStack.func_77973_b()).GetPaintableType();
            EnumType eType = EnumType.getFromObject(paintableType);
            if (paintableType.GetModel() != null) {
                float dYaw;
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                RenderHelper.func_74519_b();
                GlStateManager.func_179121_F();
                GlStateManager.func_179091_B();
                GlStateManager.func_179109_b((float)renderOrigin.x, (float)renderOrigin.y, (float)renderOrigin.z);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                float scale = paintableType.GetRecommendedScale();
                GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
                for (dYaw = this.modelAxes.getYaw() - this.prevModelAxes.getYaw(); dYaw > 180.0f; dYaw -= 360.0f) {
                }
                while (dYaw < -180.0f) {
                    dYaw += 360.0f;
                }
                Paintjob paintjob = paintableType.paintjobs.get(tempStack.func_77952_i());
                if (this.inCustomMode) {
                    this.bindWorkingTexture();
                }
                switch (eType) {
                    case gun: {
                        if (this.inCustomMode) {
                            RenderGun.bindTextures = false;
                        }
                        ClientProxy.gunRenderer.renderItem(CustomItemRenderType.ENTITY, EnumHand.MAIN_HAND, tempStack, new Object[0]);
                        RenderGun.bindTextures = true;
                        break;
                    }
                    case attachment: {
                        if (!this.inCustomMode) {
                            this.field_146297_k.field_71446_o.func_110577_a(FlansModResourceHandler.getPaintjobTexture(paintjob));
                        }
                        ((ModelAttachment)paintableType.GetModel()).renderAttachment(0.0625f);
                        break;
                    }
                    case plane: 
                    case vehicle: 
                    case mecha: {
                        if (!this.inCustomMode) {
                            this.field_146297_k.field_71446_o.func_110577_a(FlansModResourceHandler.getPaintjobTexture(paintjob));
                        }
                        ((ModelDriveable)paintableType.GetModel()).render((DriveableType)paintableType);
                        break;
                    }
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    protected void func_146976_a(float f, int i, int j) {
        int yOrigin;
        int xOrigin;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179097_i();
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        int textureX = 512;
        int textureY = 256;
        if (this.customModeTransitionTimer <= 0.999f) {
            int numDyes;
            xOrigin = (this.field_146294_l - this.field_146999_f) / 2 + this.GetMainPageX();
            yOrigin = (this.field_146295_m - this.field_147000_g) / 2 + this.GetMainPageY();
            GuiPaintjobTable.func_146110_a((int)xOrigin, (int)yOrigin, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)114, (float)textureX, (float)textureY);
            GuiPaintjobTable.func_146110_a((int)xOrigin, (int)(yOrigin + 122), (float)0.0f, (float)114.0f, (int)this.field_146999_f, (int)142, (float)textureX, (float)textureY);
            ItemStack gunStack = this.field_147002_h.func_75139_a(0).func_75211_c();
            if (gunStack != null && gunStack.func_77973_b() instanceof IPaintableItem) {
                PaintableType gunType = ((IPaintableItem)gunStack.func_77973_b()).GetPaintableType();
                int numPaintjobs = gunType.paintjobs.size();
                int numRows = numPaintjobs / 9 + 1;
                for (int y = 0; y < numRows; ++y) {
                    for (int x = 0; x < 9; ++x) {
                        if (9 * y + x >= numPaintjobs) continue;
                        Paintjob paintjob = gunType.paintjobs.get(9 * y + x);
                        ItemStack stack = gunStack.func_77946_l();
                        stack.func_77964_b(paintjob.ID);
                        this.field_146296_j.func_175042_a(stack, xOrigin + 8 + x * 18, yOrigin + 130 + y * 18);
                    }
                }
            }
            if (this.hoveringOver != null && (numDyes = this.hoveringOver.dyesNeeded.length) != 0 && !this.inventory.field_70458_d.field_71075_bZ.field_75098_d) {
                int s;
                boolean[] haveDyes = new boolean[numDyes];
                for (int n = 0; n < numDyes; ++n) {
                    int amountNeeded = this.hoveringOver.dyesNeeded[n].func_190916_E();
                    for (s = 0; s < this.inventory.func_70302_i_(); ++s) {
                        ItemStack stack = this.inventory.func_70301_a(s);
                        if (stack == null || stack.func_77973_b() != Items.field_151100_aR || stack.func_77952_i() != this.hoveringOver.dyesNeeded[n].func_77952_i()) continue;
                        amountNeeded -= stack.func_190916_E();
                    }
                    if (amountNeeded > 0) continue;
                    haveDyes[n] = true;
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                this.field_146297_k.field_71446_o.func_110577_a(texture);
                int originX = this.mouseX + 6;
                int originY = this.mouseY - 20;
                if (numDyes == 1) {
                    GuiPaintjobTable.func_146110_a((int)originX, (int)originY, (float)(haveDyes[0] ? 379 : 356), (float)0.0f, (int)22, (int)22, (float)textureX, (float)textureY);
                } else {
                    GuiPaintjobTable.func_146110_a((int)originX, (int)originY, (float)256.0f, (float)(haveDyes[0] ? 23 : 0), (int)20, (int)22, (float)textureX, (float)textureY);
                    for (s = 1; s < numDyes - 1; ++s) {
                        GuiPaintjobTable.func_146110_a((int)(originX + 2 + 18 * s), (int)originY, (float)277.0f, (float)(haveDyes[s] ? 23 : 0), (int)18, (int)22, (float)textureX, (float)textureY);
                    }
                    GuiPaintjobTable.func_146110_a((int)(originX + 2 + 18 * (numDyes - 1)), (int)originY, (float)296.0f, (float)(haveDyes[numDyes - 1] ? 23 : 0), (int)20, (int)22, (float)textureX, (float)textureY);
                }
                for (s = 0; s < numDyes; ++s) {
                    this.field_146296_j.func_175042_a(this.hoveringOver.dyesNeeded[s], originX + 3 + s * 18, originY + 3);
                    this.field_146296_j.func_180453_a(this.field_146289_q, this.hoveringOver.dyesNeeded[s], originX + 3 + s * 18, originY + 3, null);
                }
            }
        }
        if (this.customModeTransitionTimer >= 0.001f) {
            this.field_146297_k.field_71446_o.func_110577_a(texture);
            xOrigin = (this.field_146294_l - this.field_146999_f) / 2 + this.GetCustomPageX() - 32;
            yOrigin = (this.field_146295_m - this.field_147000_g) / 2 + this.GetCustomPageY();
            GuiPaintjobTable.func_146110_a((int)xOrigin, (int)(yOrigin + 200), (float)224.0f, (float)206.0f, (int)288, (int)50, (float)textureX, (float)textureY);
            GlStateManager.func_179090_x();
            for (int x = 0; x < 18; ++x) {
                for (int y = 0; y < 4; ++y) {
                    int colour = paletteColours[x][y];
                    float scale = 0.00390625f;
                    GlStateManager.func_179124_c((float)(scale * (float)(colour >> 16 & 0xFF)), (float)(scale * (float)(colour >> 8 & 0xFF)), (float)(scale * (float)(colour >> 0 & 0xFF)));
                    GuiPaintjobTable.func_146110_a((int)(xOrigin + 8 + 9 * x), (int)(yOrigin + 200 + 8 + 9 * y), (float)0.0f, (float)0.0f, (int)7, (int)7, (float)textureX, (float)textureY);
                }
            }
            float scale = 0.00390625f;
            float red = scale * (float)(currentColour >> 16 & 0xFF);
            float green = scale * (float)(currentColour >> 8 & 0xFF);
            float blue = scale * (float)(currentColour >> 0 & 0xFF);
            GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
            GuiPaintjobTable.func_146110_a((int)(xOrigin + 172), (int)(yOrigin + 208), (float)0.0f, (float)0.0f, (int)34, (int)34, (float)textureX, (float)textureY);
            int n = 0;
            while ((float)n < 68.0f) {
                GlStateManager.func_179124_c((float)((float)n / 68.0f), (float)green, (float)blue);
                GuiPaintjobTable.func_146110_a((int)(xOrigin + 212 + n), (int)(yOrigin + 208), (float)0.0f, (float)0.0f, (int)1, (int)10, (float)textureX, (float)textureY);
                ++n;
            }
            n = 0;
            while ((float)n < 68.0f) {
                GlStateManager.func_179124_c((float)red, (float)((float)n / 68.0f), (float)blue);
                GuiPaintjobTable.func_146110_a((int)(xOrigin + 212 + n), (int)(yOrigin + 220), (float)0.0f, (float)0.0f, (int)1, (int)10, (float)textureX, (float)textureY);
                ++n;
            }
            n = 0;
            while ((float)n < 68.0f) {
                GlStateManager.func_179124_c((float)red, (float)green, (float)((float)n / 68.0f));
                GuiPaintjobTable.func_146110_a((int)(xOrigin + 212 + n), (int)(yOrigin + 232), (float)0.0f, (float)0.0f, (int)1, (int)10, (float)textureX, (float)textureY);
                ++n;
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GuiPaintjobTable.func_146110_a((int)(xOrigin + 212 + (int)(red * 68.0f)), (int)(yOrigin + 207), (float)317.0f, (float)21.0f, (int)3, (int)12, (float)textureX, (float)textureY);
            GuiPaintjobTable.func_146110_a((int)(xOrigin + 212 + (int)(green * 68.0f)), (int)(yOrigin + 219), (float)317.0f, (float)21.0f, (int)3, (int)12, (float)textureX, (float)textureY);
            GuiPaintjobTable.func_146110_a((int)(xOrigin + 212 + (int)(blue * 68.0f)), (int)(yOrigin + 231), (float)317.0f, (float)21.0f, (int)3, (int)12, (float)textureX, (float)textureY);
            for (n = 0; n < 3; ++n) {
                GuiPaintjobTable.func_146110_a((int)(xOrigin + 290), (int)(yOrigin + 200 + 17 * n), (float)401.0f, (float)0.0f, (int)78, (int)16, (float)textureX, (float)textureY);
            }
            int xFlatOrigin = this.GetFlatTextureWindowX();
            int yFlatOrigin = this.GetFlatTextureWindowY();
            if (dynamicTextureX != dynamicTextureY) {
                // empty if block
            }
            GuiPaintjobTable.func_146110_a((int)xFlatOrigin, (int)yFlatOrigin, (float)242.0f, (float)54.0f, (int)71, (int)152, (float)textureX, (float)textureY);
            GuiPaintjobTable.func_146110_a((int)(xFlatOrigin + 64 + 7), (int)yFlatOrigin, (float)441.0f, (float)54.0f, (int)71, (int)152, (float)textureX, (float)textureY);
            this.bindWorkingTexture();
            GuiPaintjobTable.func_146110_a((int)(xFlatOrigin + 7), (int)(yFlatOrigin + 17), (float)0.0f, (float)0.0f, (int)128, (int)128, (float)dynamicTextureX, (float)dynamicTextureY);
        }
        GlStateManager.func_179126_j();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public static void copyImageToTexture() {
        dynamicTexture.func_110564_a();
    }

    public void bindWorkingTexture() {
        this.field_146297_k.func_110434_K().func_110577_a(this.field_146297_k.func_110434_K().func_110578_a("customPaintjob", dynamicTexture));
    }

    private void SetCustomMode(boolean active) {
        if (active && dynamicTexture == null) {
            this.copyTextureFromGunToCustomTexture();
        }
        this.inCustomMode = active;
    }

    private void copyTextureFromGunToCustomTexture() {
        ItemStack gunStack = this.field_147002_h.func_75139_a(0).func_75211_c();
        if (gunStack != null && gunStack.func_77973_b() instanceof IPaintableItem) {
            PaintableType paintableType = ((IPaintableItem)gunStack.func_77973_b()).GetPaintableType();
            Paintjob paintjob = paintableType.getPaintjob(gunStack.func_77952_i());
            try {
                String imageLocation = "Flan/" + paintableType.contentPack + "/assets/flansmod/skins/" + paintjob.textureName + ".png";
                BufferedImage bufferedImage = ImageIO.read(new File(imageLocation));
                dynamicTexture = new DynamicTexture(bufferedImage);
                dynamicTextureX = bufferedImage.getWidth();
                dynamicTextureY = bufferedImage.getHeight();
            }
            catch (IOException e) {
                FlansMod.log.throwing((Throwable)e);
            }
            GuiPaintjobTable.copyImageToTexture();
        }
    }

    public void func_146269_k() throws IOException {
        super.func_146269_k();
        if (this.inCustomMode) {
            this.mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            this.mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            int mouseXInGUI = this.mouseX - this.field_147003_i;
            int mouseYInGUI = this.mouseY - this.field_147009_r;
            int flatTexOriginX = this.GetFlatTextureWindowX();
            int flatTexOriginY = this.GetFlatTextureWindowY();
            if (Mouse.isButtonDown((int)0)) {
                int pixelX = mouseXInGUI + 64 - (flatTexOriginX + 7) - 4;
                int pixelY = mouseYInGUI - (flatTexOriginY + 17) + 5;
                if (pixelX >= 0 && pixelX < 128 && pixelY >= 0 && pixelY < 128) {
                    for (int i = -2; i < 2; ++i) {
                        for (int j = -2; j < 2; ++j) {
                            if (!(i != -2 && i != 2 || j != -2 && j != 2)) continue;
                            int px = Math.min(Math.max(0, pixelX + i), dynamicTextureX - 1);
                            int py = Math.min(Math.max(0, pixelY + j), dynamicTextureY - 1);
                            GuiPaintjobTable.dynamicTexture.func_110565_c()[px + py * GuiPaintjobTable.dynamicTextureX] = -16777216 + currentColour;
                            GuiPaintjobTable.copyImageToTexture();
                        }
                    }
                }
            }
            if (mouseXInGUI >= flatTexOriginX - 64 + 7 && mouseXInGUI <= flatTexOriginX + 64 + 14 && mouseYInGUI >= flatTexOriginY - 4 && mouseYInGUI <= flatTexOriginY + 6) {
                movingFlatTextureWindow = Mouse.isButtonDown((int)0);
            }
        }
    }

    public void func_146274_d() throws IOException {
        block13: {
            int mouseYInGUI;
            int mouseXInGUI;
            block12: {
                super.func_146274_d();
                if (Mouse.getEventButton() == 2 && Mouse.getEventButtonState()) {
                    this.SetCustomMode(!this.inCustomMode);
                }
                this.mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
                this.mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
                mouseXInGUI = this.mouseX - this.field_147003_i;
                mouseYInGUI = this.mouseY - this.field_147009_r;
                this.hoveringOver = null;
                if (!this.inCustomMode) break block12;
                int xOrigin = this.GetCustomPageX() - 32;
                int yOrigin = this.GetCustomPageY();
                for (int x = 0; x < 18; ++x) {
                    block5: for (int y = 0; y < 4; ++y) {
                        if (mouseXInGUI < xOrigin + 8 + 9 * x || mouseXInGUI >= xOrigin + 15 + 9 * x || mouseYInGUI < yOrigin + 208 + 9 * y || mouseYInGUI >= yOrigin + 215 + 9 * y) continue;
                        switch (Mouse.getEventButton()) {
                            case 0: {
                                currentColour = paletteColours[x][y];
                                continue block5;
                            }
                            case 1: {
                                GuiPaintjobTable.paletteColours[x][y] = currentColour;
                            }
                        }
                    }
                }
                if (Mouse.getEventButton() != 0 || !Mouse.getEventButtonState()) break block13;
                if (mouseXInGUI >= xOrigin + 212 && (float)mouseXInGUI < (float)(xOrigin + 212) + 68.0f && mouseYInGUI >= yOrigin + 208 && mouseYInGUI < yOrigin + 218) {
                    int red = (int)((float)((mouseXInGUI - (xOrigin + 212)) * 255) / 68.0f);
                    currentColour &= 0xFFFF;
                    currentColour |= red << 16;
                }
                if (mouseXInGUI >= xOrigin + 212 && (float)mouseXInGUI < (float)(xOrigin + 212) + 68.0f && mouseYInGUI >= yOrigin + 220 && mouseYInGUI < yOrigin + 230) {
                    int green = (int)((float)((mouseXInGUI - (xOrigin + 212)) * 255) / 68.0f);
                    currentColour &= 0xFF00FF;
                    currentColour |= green << 8;
                }
                if (mouseXInGUI < xOrigin + 212 || !((float)mouseXInGUI < (float)(xOrigin + 212) + 68.0f) || mouseYInGUI < yOrigin + 232 || mouseYInGUI >= yOrigin + 242) break block13;
                int blue = (int)((float)((mouseXInGUI - (xOrigin + 212)) * 255) / 68.0f);
                currentColour &= 0xFFFF00;
                currentColour |= blue << 0;
                break block13;
            }
            ItemStack gunStack = this.field_147002_h.func_75139_a(0).func_75211_c();
            if (gunStack != null && gunStack.func_77973_b() instanceof IPaintableItem) {
                PaintableType paintableType = ((IPaintableItem)gunStack.func_77973_b()).GetPaintableType();
                int numPaintjobs = paintableType.paintjobs.size();
                int numRows = numPaintjobs / 9 + 1;
                for (int j = 0; j < numRows; ++j) {
                    for (int i = 0; i < 9; ++i) {
                        if (9 * j + i >= numPaintjobs) continue;
                        Paintjob paintjob = paintableType.paintjobs.get(9 * j + i);
                        ItemStack stack = gunStack.func_77946_l();
                        stack.func_77978_p().func_74778_a("Paint", paintjob.iconName);
                        int slotX = 7 + i * 18;
                        int slotY = 129 + j * 18;
                        if (mouseXInGUI < slotX || mouseXInGUI >= slotX + 18 || mouseYInGUI < slotY || mouseYInGUI >= slotY + 18) continue;
                        this.hoveringOver = paintjob;
                    }
                }
            }
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (button != 0) {
            return;
        }
        if (this.hoveringOver == null) {
            return;
        }
        FlansMod.getPacketHandler().sendToServer(new PacketGunPaint(this.hoveringOver.ID));
        ((ContainerPaintjobTable)this.field_147002_h).clickPaintjob(this.hoveringOver.ID);
    }

    public boolean func_73868_f() {
        return false;
    }

    static {
        flatTextureWindowX = 300;
        flatTextureWindowY = 100;
        movingFlatTextureWindow = false;
        GuiPaintjobTable.ResetPalette();
    }
}

