/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.common.vector.Vector3f;
import java.util.Random;

public class GunAnimations {
    public static GunAnimations defaults = new GunAnimations();
    public float gunSlide = 0.0f;
    public float lastGunSlide = 0.0f;
    public int timeUntilPump = 0;
    public int timeToPumpFor = 0;
    public float pumped = -1.0f;
    public float lastPumped = -1.0f;
    public boolean pumping = false;
    public boolean reloading = false;
    public float reloadAnimationTime = 0.0f;
    public float reloadAnimationProgress = 0.0f;
    public float lastReloadAnimationProgress = 0.0f;
    public float minigunBarrelRotation = 0.0f;
    public float minigunBarrelRotationSpeed = 0.0f;
    public int meleeAnimationProgress = 0;
    public int meleeAnimationLength = 0;
    public float recoil = 0.0f;
    public float antiRecoil = 0.0f;
    public float recoilAngle = 0.0f;
    public Vector3f recoilOffset = new Vector3f();
    public Vector3f recoilVelocity = new Vector3f();
    public Random random = new Random();
    public LookAtState lookAt = LookAtState.NONE;
    public float lookAtTimer = 0.0f;
    public static final int[] lookAtTimes = new int[]{1, 10, 20, 10, 20, 10};

    public void update() {
        this.lastPumped = this.pumped;
        if (this.timeUntilPump > 0) {
            --this.timeUntilPump;
            if (this.timeUntilPump == 0) {
                this.pumping = true;
                this.pumped = -1.0f;
                this.lastPumped = -1.0f;
            }
        }
        if (this.pumping) {
            this.pumped += 2.0f / (float)this.timeToPumpFor;
            if (this.pumped >= 0.999f) {
                this.pumping = false;
            }
        }
        this.lastGunSlide = this.gunSlide;
        if (this.gunSlide > 0.0f) {
            this.gunSlide *= 0.4f;
        }
        this.lastReloadAnimationProgress = this.reloadAnimationProgress;
        if (this.reloading) {
            this.reloadAnimationProgress += 1.0f / this.reloadAnimationTime;
        }
        if (this.reloading && this.reloadAnimationProgress >= 1.0f) {
            this.reloading = false;
        }
        this.minigunBarrelRotation += this.minigunBarrelRotationSpeed;
        this.minigunBarrelRotationSpeed *= 0.9f;
        if (this.meleeAnimationLength > 0) {
            ++this.meleeAnimationProgress;
            if (this.meleeAnimationProgress == this.meleeAnimationLength) {
                this.meleeAnimationLength = 0;
                this.meleeAnimationProgress = 0;
            }
        }
        float scale = 0.5f;
        float offsetScale = 0.005f;
        if (this.recoil > 0.0f) {
            this.recoil *= 0.5f;
        }
        this.recoilVelocity.x = (float)((double)this.recoilVelocity.x + (this.random.nextGaussian() - 0.5) * (double)this.recoil * (double)offsetScale);
        this.recoilVelocity.y = (float)((double)this.recoilVelocity.y + (this.random.nextGaussian() - 0.5) * (double)this.recoil * (double)offsetScale);
        this.recoilVelocity.z = (float)((double)this.recoilVelocity.z + (this.random.nextGaussian() - 0.25) * (double)this.recoil * (double)offsetScale);
        this.recoilVelocity.scale(0.5f);
        Vector3f.add(this.recoilOffset, this.recoilVelocity, this.recoilOffset);
        this.recoilOffset.scale(0.9f);
        this.recoilAngle -= this.recoil * scale;
        this.antiRecoil += this.recoil;
        this.recoilAngle += this.antiRecoil * 0.2f * scale;
        this.antiRecoil *= 0.8f;
        switch (this.lookAt) {
            case NONE: {
                this.lookAtTimer = 0.0f;
                break;
            }
            case TILT1: 
            case LOOK1: 
            case TILT2: 
            case LOOK2: 
            case UNTILT: {
                this.lookAtTimer += 1.0f;
                if (!(this.lookAtTimer >= (float)lookAtTimes[this.lookAt.ordinal()])) break;
                this.lookAt = LookAtState.values()[(this.lookAt.ordinal() + 1) % LookAtState.values().length];
                this.lookAtTimer = 0.0f;
                break;
            }
        }
    }

    public void addMinigunBarrelRotationSpeed(Float speed) {
        this.minigunBarrelRotationSpeed += speed.floatValue();
    }

    public void doShoot(int pumpDelay, int pumpTime) {
        this.gunSlide = 1.0f;
        this.lastGunSlide = 1.0f;
        this.timeUntilPump = pumpDelay;
        this.timeToPumpFor = pumpTime;
    }

    public void doReload(int reloadTime, int pumpDelay, int pumpTime) {
        this.reloading = true;
        this.reloadAnimationProgress = 0.0f;
        this.lastReloadAnimationProgress = 0.0f;
        this.reloadAnimationTime = reloadTime;
        this.timeUntilPump = pumpDelay;
        this.timeToPumpFor = pumpTime;
    }

    public void doMelee(int meleeTime) {
        this.meleeAnimationLength = meleeTime;
    }

    public static enum LookAtState {
        NONE,
        TILT1,
        LOOK1,
        TILT2,
        LOOK2,
        UNTILT;

    }
}

