/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.model.ModelDriveable;
import com.flansmod.client.tmt.ModelRendererTurbo;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.vector.Vector3f;

public class ModelVehicle
extends ModelDriveable {
    public ModelRendererTurbo[] turretModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] barrelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[][] ammoModel = new ModelRendererTurbo[0][0];
    public ModelRendererTurbo[] frontWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] backWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftFrontWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightFrontWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftBackWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightBackWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightTrackModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftTrackModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightTrackWheelModels = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftTrackWheelModels = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] fancyTrackModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[][] leftAnimTrackModel = new ModelRendererTurbo[0][0];
    public ModelRendererTurbo[][] rightAnimTrackModel = new ModelRendererTurbo[0][0];
    public ModelRendererTurbo[] bodyDoorOpenModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] bodyDoorCloseModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] trailerModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] steeringWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] drillHeadModel = new ModelRendererTurbo[0];
    public Vector3f drillHeadOrigin = new Vector3f();
    public ModelRendererTurbo[] animBarrelModel = new ModelRendererTurbo[0];
    public Vector3f barrelAttach = new Vector3f();
    public int animFrame = 0;

    @Override
    public void render(EntityDriveable driveable, float f1) {
        this.render(0.0625f, (EntityVehicle)driveable, f1);
    }

    @Override
    public void render(DriveableType type) {
        super.render(type);
        this.renderPart(this.leftBackWheelModel);
        this.renderPart(this.rightBackWheelModel);
        this.renderPart(this.leftFrontWheelModel);
        this.renderPart(this.rightFrontWheelModel);
        this.renderPart(this.rightTrackModel);
        this.renderPart(this.leftTrackModel);
        this.renderPart(this.rightTrackWheelModels);
        this.renderPart(this.leftTrackWheelModels);
        this.renderPart(this.bodyDoorCloseModel);
        this.renderPart(this.trailerModel);
        this.renderPart(this.turretModel);
        this.renderPart(this.barrelModel);
        this.renderPart(this.drillHeadModel);
        for (ModelRendererTurbo[] mods : this.ammoModel) {
            this.renderPart(mods);
        }
        for (ModelRendererTurbo[] latm : this.leftAnimTrackModel) {
            this.renderPart(latm);
        }
        for (ModelRendererTurbo[] ratm : this.rightAnimTrackModel) {
            this.renderPart(ratm);
        }
        this.renderPart(this.steeringWheelModel);
    }

    public void render(float f5, EntityVehicle vehicle, float f) {
        int n;
        boolean rotateWheels = vehicle.getVehicleType().rotateWheels;
        this.animFrame = vehicle.animFrame;
        if (vehicle.isPartIntact(EnumDriveablePart.core)) {
            for (ModelRendererTurbo aBodyModel : this.bodyModel) {
                aBodyModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo aBodyDoorOpenModel : this.bodyDoorOpenModel) {
                if (!vehicle.varDoor) continue;
                aBodyDoorOpenModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo aBodyDoorCloseModel : this.bodyDoorCloseModel) {
                if (vehicle.varDoor) continue;
                aBodyDoorCloseModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo aSteeringWheelModel : this.steeringWheelModel) {
                aSteeringWheelModel.field_78795_f = vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                aSteeringWheelModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.backLeftWheel)) {
            for (ModelRendererTurbo aLeftBackWheelModel : this.leftBackWheelModel) {
                aLeftBackWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                aLeftBackWheelModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.backRightWheel)) {
            for (ModelRendererTurbo aRightBackWheelModel : this.rightBackWheelModel) {
                aRightBackWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                aRightBackWheelModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.frontLeftWheel)) {
            for (ModelRendererTurbo aLeftFrontWheelModel : this.leftFrontWheelModel) {
                aLeftFrontWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                aLeftFrontWheelModel.field_78796_g = -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                aLeftFrontWheelModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.frontRightWheel)) {
            for (ModelRendererTurbo aRightFrontWheelModel : this.rightFrontWheelModel) {
                aRightFrontWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                aRightFrontWheelModel.field_78796_g = -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                aRightFrontWheelModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.frontWheel)) {
            for (ModelRendererTurbo aFrontWheelModel : this.frontWheelModel) {
                aFrontWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                aFrontWheelModel.field_78796_g = -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                aFrontWheelModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.backWheel)) {
            for (ModelRendererTurbo aBackWheelModel : this.backWheelModel) {
                aBackWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                aBackWheelModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.leftTrack)) {
            for (ModelRendererTurbo aLeftTrackModel : this.leftTrackModel) {
                aLeftTrackModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo leftTrackWheelModel : this.leftTrackWheelModels) {
                leftTrackWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                leftTrackWheelModel.render(f5, this.oldRotateOrder);
            }
            for (int i = 0; i < this.leftAnimTrackModel.length; ++i) {
                if (i != this.animFrame) continue;
                ModelRendererTurbo[] modelRendererTurboArray = this.leftAnimTrackModel[i];
                n = modelRendererTurboArray.length;
                for (int leftTrackWheelModel = 0; leftTrackWheelModel < n; ++leftTrackWheelModel) {
                    ModelRendererTurbo aLeftAnimTrackModel = modelRendererTurboArray[leftTrackWheelModel];
                    aLeftAnimTrackModel.render(f5, this.oldRotateOrder);
                }
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.rightTrack)) {
            for (ModelRendererTurbo aRightTrackModel : this.rightTrackModel) {
                aRightTrackModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo rightTrackWheelModel : this.rightTrackWheelModels) {
                rightTrackWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                rightTrackWheelModel.render(f5, this.oldRotateOrder);
            }
            for (int i = 0; i < this.rightAnimTrackModel.length; ++i) {
                if (i != this.animFrame) continue;
                ModelRendererTurbo[] modelRendererTurboArray = this.rightAnimTrackModel[i];
                n = modelRendererTurboArray.length;
                for (int rightTrackWheelModel = 0; rightTrackWheelModel < n; ++rightTrackWheelModel) {
                    ModelRendererTurbo aRightAnimTrackModel = modelRendererTurboArray[rightTrackWheelModel];
                    aRightAnimTrackModel.render(f5, this.oldRotateOrder);
                }
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.trailer)) {
            for (ModelRendererTurbo aTrailerModel : this.trailerModel) {
                aTrailerModel.render(f5, this.oldRotateOrder);
            }
        }
        for (EntitySeat seat : vehicle.getSeats()) {
            if (seat == null || seat.seatInfo == null || seat.seatInfo.gunName == null || this.gunModels.get(seat.seatInfo.gunName) == null || !vehicle.isPartIntact(seat.seatInfo.part) || vehicle.rotateWithTurret(seat.seatInfo)) continue;
            float yaw = seat.prevLooking.getYaw() + (seat.looking.getYaw() - seat.prevLooking.getYaw()) * f;
            float pitch = seat.prevLooking.getPitch() + (seat.looking.getPitch() - seat.prevLooking.getPitch()) * f;
            ModelRendererTurbo[][] gunModel = (ModelRendererTurbo[][])this.gunModels.get(seat.seatInfo.gunName);
            for (ModelRendererTurbo gunModelPart : gunModel[0]) {
                gunModelPart.field_78796_g = -yaw * (float)Math.PI / 180.0f;
                gunModelPart.func_78785_a(f5);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[1]) {
                gunModelPart.field_78796_g = -yaw * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.func_78785_a(f5);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[2]) {
                gunModelPart.field_78796_g = -yaw * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.func_78785_a(f5);
            }
        }
    }

    public void renderTurret(float f, float f1, float f2, float f3, float f4, float f5, EntityVehicle vehicle, float dt) {
        VehicleType type = vehicle.getVehicleType();
        float yaw = vehicle.getSeat((int)0).looking.getYaw();
        float pitch = vehicle.getSeat((int)0).looking.getPitch();
        for (ModelRendererTurbo aTurretModel : this.turretModel) {
            aTurretModel.render(f5, this.oldRotateOrder);
        }
        for (ModelRendererTurbo aBarrelModel : this.barrelModel) {
            aBarrelModel.field_78808_h = -pitch * (float)Math.PI / 180.0f;
            aBarrelModel.render(f5, this.oldRotateOrder);
        }
        for (int i = 0; i < this.ammoModel.length; ++i) {
            if (i < type.numMissileSlots && vehicle.getDriveableData().missiles[i] == null) continue;
            for (int j = 0; j < this.ammoModel[i].length; ++j) {
                this.ammoModel[i][j].field_78808_h = -pitch * (float)Math.PI / 180.0f;
                this.ammoModel[i][j].render(f5, this.oldRotateOrder);
            }
        }
        for (EntitySeat seat : vehicle.getSeats()) {
            if (seat == null || seat.seatInfo == null || seat.seatInfo.gunName == null || this.gunModels.get(seat.seatInfo.gunName) == null || !vehicle.isPartIntact(seat.seatInfo.part) || !vehicle.rotateWithTurret(seat.seatInfo)) continue;
            EntitySeat driverSeat = vehicle.getSeat(0);
            float driverYaw = driverSeat.prevLooking.getYaw() + (driverSeat.looking.getYaw() - driverSeat.prevLooking.getYaw()) * dt;
            float yaw2 = seat.prevLooking.getYaw() + (seat.looking.getYaw() - seat.prevLooking.getYaw()) * dt;
            float pitch2 = seat.prevLooking.getPitch() + (seat.looking.getPitch() - seat.prevLooking.getPitch()) * dt;
            float effectiveYaw = yaw2 - driverYaw;
            ModelRendererTurbo[][] gunModel = (ModelRendererTurbo[][])this.gunModels.get(seat.seatInfo.gunName);
            for (ModelRendererTurbo gunModelPart : gunModel[0]) {
                gunModelPart.field_78796_g = -effectiveYaw * (float)Math.PI / 180.0f;
                gunModelPart.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[1]) {
                gunModelPart.field_78796_g = -effectiveYaw * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch2 * (float)Math.PI / 180.0f;
                gunModelPart.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[2]) {
                gunModelPart.field_78796_g = -effectiveYaw * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch2 * (float)Math.PI / 180.0f;
                gunModelPart.render(f5, this.oldRotateOrder);
            }
        }
    }

    public void renderAnimBarrel(float f, float f1, float f2, float f3, float f4, float f5, EntityVehicle vehicle, float dt) {
        if (vehicle.isPartIntact(EnumDriveablePart.turret)) {
            for (ModelRendererTurbo aAnimBarrelModel : this.animBarrelModel) {
                aAnimBarrelModel.render(f5, this.oldRotateOrder);
            }
        }
    }

    public void renderDrillBit(EntityVehicle vehicle, float f) {
        if (vehicle.isPartIntact(EnumDriveablePart.harvester)) {
            for (ModelRendererTurbo adrillHeadModel : this.drillHeadModel) {
                adrillHeadModel.render(0.0625f, this.oldRotateOrder);
            }
        }
    }

    public void renderFancyTracks(EntityVehicle vehicle, float f) {
        for (ModelRendererTurbo adrillHeadModel : this.fancyTrackModel) {
            adrillHeadModel.render(0.0625f, this.oldRotateOrder);
        }
    }

    @Override
    public void flipAll() {
        super.flipAll();
        this.flip(this.bodyDoorOpenModel);
        this.flip(this.bodyDoorCloseModel);
        this.flip(this.turretModel);
        this.flip(this.barrelModel);
        this.flip(this.leftFrontWheelModel);
        this.flip(this.rightFrontWheelModel);
        this.flip(this.leftBackWheelModel);
        this.flip(this.rightBackWheelModel);
        this.flip(this.rightTrackModel);
        this.flip(this.leftTrackModel);
        this.flip(this.rightTrackWheelModels);
        this.flip(this.leftTrackWheelModels);
        this.flip(this.trailerModel);
        this.flip(this.steeringWheelModel);
        this.flip(this.frontWheelModel);
        this.flip(this.backWheelModel);
        this.flip(this.drillHeadModel);
        this.flip(this.fancyTrackModel);
        for (ModelRendererTurbo[] latm : this.leftAnimTrackModel) {
            this.flip(latm);
        }
        for (ModelRendererTurbo[] ratm : this.rightAnimTrackModel) {
            this.flip(ratm);
        }
    }

    @Override
    public void translateAll(float x, float y, float z) {
        super.translateAll(x, y, z);
        this.translate(this.bodyDoorOpenModel, x, y, z);
        this.translate(this.bodyDoorCloseModel, x, y, z);
        this.translate(this.turretModel, x, y, z);
        this.translate(this.barrelModel, x, y, z);
        this.translate(this.leftFrontWheelModel, x, y, z);
        this.translate(this.rightFrontWheelModel, x, y, z);
        this.translate(this.leftBackWheelModel, x, y, z);
        this.translate(this.rightBackWheelModel, x, y, z);
        this.translate(this.rightTrackModel, x, y, z);
        this.translate(this.leftTrackModel, x, y, z);
        this.translate(this.rightTrackWheelModels, x, y, z);
        this.translate(this.leftTrackWheelModels, x, y, z);
        this.translate(this.trailerModel, x, y, z);
        this.translate(this.steeringWheelModel, x, y, z);
        this.translate(this.frontWheelModel, x, y, z);
        this.translate(this.backWheelModel, x, y, z);
        this.translate(this.drillHeadModel, x, y, z);
        for (ModelRendererTurbo[] latm : this.leftAnimTrackModel) {
            this.translate(latm, x, y, z);
        }
        for (ModelRendererTurbo[] ratm : this.rightAnimTrackModel) {
            this.translate(ratm, x, y, z);
        }
    }
}

