/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.handlers.FlansModResourceHandler;
import com.flansmod.client.model.CustomItemRenderType;
import com.flansmod.client.model.CustomItemRenderer;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.client.model.ModelAttachment;
import com.flansmod.client.model.ModelGun;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.types.PaintableType;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;

public class RenderGun
implements CustomItemRenderer {
    private static TextureManager renderEngine;
    public static float smoothing;
    public static boolean bindTextures;

    @Override
    public void renderItem(CustomItemRenderType type, EnumHand hand, ItemStack item, Object ... data) {
        if (!(item.func_77973_b() instanceof ItemGun)) {
            return;
        }
        GunType gunType = ((ItemGun)item.func_77973_b()).GetType();
        if (gunType == null) {
            return;
        }
        ModelGun model = gunType.model;
        if (model == null) {
            return;
        }
        GunAnimations animations = type == CustomItemRenderType.ENTITY || type == CustomItemRenderType.INVENTORY ? new GunAnimations() : FlansModClient.getGunAnimations((EntityLivingBase)data[1], hand);
        this.renderGun(type, item, gunType, animations, hand, data);
    }

    public void renderOffHandGun(EntityPlayer player, ItemStack offHandItemStack) {
        GunAnimations animations = FlansModClient.gunAnimationsLeft.get(player);
        if (animations == null) {
            animations = new GunAnimations();
            FlansModClient.gunAnimationsLeft.put((EntityLivingBase)player, animations);
        }
        GunType offHandGunType = ((ItemGun)offHandItemStack.func_77973_b()).GetType();
        this.renderGun(CustomItemRenderType.INVENTORY, offHandItemStack, offHandGunType, animations, EnumHand.OFF_HAND, player);
    }

    private void renderGun(CustomItemRenderType type, ItemStack item, GunType gunType, GunAnimations animations, EnumHand hand, Object ... data) {
        float f = 0.0625f;
        ModelGun model = gunType.model;
        int flip = hand == EnumHand.OFF_HAND ? -1 : 1;
        GlStateManager.func_179094_E();
        float reloadRotate = 0.0f;
        block0 : switch (type) {
            case ENTITY: {
                GlStateManager.func_179109_b((float)(-0.45f + model.itemFrameOffset.x), (float)(-0.05f + model.itemFrameOffset.y), (float)model.itemFrameOffset.z);
                break;
            }
            case INVENTORY: {
                GlStateManager.func_179109_b((float)model.itemFrameOffset.x, (float)model.itemFrameOffset.y, (float)model.itemFrameOffset.z);
                break;
            }
            case EQUIPPED: {
                if (hand == EnumHand.OFF_HAND) {
                    GlStateManager.func_179114_b((float)-70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)48.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)105.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)-0.1f, (float)-0.22f, (float)-0.15f);
                } else {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.2f, (float)0.05f, (float)-0.0f);
                    GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)-1.0f);
                }
                GlStateManager.func_179109_b((float)model.thirdPersonOffset.x, (float)model.thirdPersonOffset.y, (float)model.thirdPersonOffset.z);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                Vector3f startAngles;
                Vector3f endAngles;
                Vector3f startPos;
                Vector3f endPos;
                IScope scope = gunType.getCurrentScope(item);
                if (FlansModClient.zoomProgress > 0.9f && scope.hasZoomOverlay()) {
                    GlStateManager.func_179121_F();
                    return;
                }
                float adsSwitch = FlansModClient.lastZoomProgress + (FlansModClient.zoomProgress - FlansModClient.lastZoomProgress) * smoothing;
                if (hand == EnumHand.OFF_HAND) {
                    GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)-1.0f, (float)0.675f, (float)-1.8f);
                } else {
                    GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(0.0f - 5.0f * adsSwitch), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)-1.0f, (float)(0.675f + 0.18f * adsSwitch), (float)(-1.0f - 0.395f * adsSwitch));
                    if (gunType.hasScopeOverlay) {
                        GlStateManager.func_179109_b((float)(-0.7f * adsSwitch), (float)(-0.12f * adsSwitch), (float)(-0.05f * adsSwitch));
                    }
                    GlStateManager.func_179114_b((float)(4.5f * adsSwitch), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)(-0.03f * adsSwitch), (float)0.0f);
                }
                if (animations.meleeAnimationProgress > 0 && animations.meleeAnimationProgress < gunType.meleePath.size()) {
                    Vector3f meleePos = gunType.meleePath.get(animations.meleeAnimationProgress);
                    Vector3f nextMeleePos = animations.meleeAnimationProgress + 1 < gunType.meleePath.size() ? gunType.meleePath.get(animations.meleeAnimationProgress + 1) : new Vector3f();
                    GlStateManager.func_179109_b((float)(meleePos.x + (nextMeleePos.x - meleePos.x) * smoothing), (float)(meleePos.y + (nextMeleePos.y - meleePos.y) * smoothing), (float)(meleePos.z + (nextMeleePos.z - meleePos.z) * smoothing));
                    Vector3f meleeAngles = gunType.meleePathAngles.get(animations.meleeAnimationProgress);
                    Vector3f nextMeleeAngles = animations.meleeAnimationProgress + 1 < gunType.meleePathAngles.size() ? gunType.meleePathAngles.get(animations.meleeAnimationProgress + 1) : new Vector3f();
                    GlStateManager.func_179114_b((float)(meleeAngles.y + (nextMeleeAngles.y - meleeAngles.y) * smoothing), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(meleeAngles.z + (nextMeleeAngles.z - meleeAngles.z) * smoothing), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)(meleeAngles.x + (nextMeleeAngles.x - meleeAngles.x) * smoothing), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                float interp = animations.lookAtTimer + smoothing;
                interp /= (float)GunAnimations.lookAtTimes[animations.lookAt.ordinal()];
                Vector3f idlePos = new Vector3f(0.0f, 0.0f, 0.0f);
                Vector3f look1Pos = new Vector3f(0.25f, 0.25f, 0.0f);
                Vector3f look2Pos = new Vector3f(0.25f, 0.25f, -0.5f);
                Vector3f idleAngles = new Vector3f(0.0f, 0.0f, 0.0f);
                Vector3f look1Angles = new Vector3f(0.0f, 70.0f, 0.0f);
                Vector3f look2Angles = new Vector3f(0.0f, -60.0f, 60.0f);
                switch (animations.lookAt) {
                    default: {
                        startPos = endPos = idlePos;
                        startAngles = endAngles = idleAngles;
                        break;
                    }
                    case LOOK1: {
                        startPos = endPos = look1Pos;
                        startAngles = endAngles = look1Angles;
                        break;
                    }
                    case LOOK2: {
                        startPos = endPos = look2Pos;
                        startAngles = endAngles = look2Angles;
                        break;
                    }
                    case TILT1: {
                        startPos = idlePos;
                        startAngles = idleAngles;
                        endPos = look1Pos;
                        endAngles = look1Angles;
                        break;
                    }
                    case TILT2: {
                        startPos = look1Pos;
                        startAngles = look1Angles;
                        endPos = look2Pos;
                        endAngles = look2Angles;
                        break;
                    }
                    case UNTILT: {
                        startPos = look2Pos;
                        startAngles = look2Angles;
                        endPos = idlePos;
                        endAngles = idleAngles;
                    }
                }
                GlStateManager.func_179114_b((float)(startAngles.y + (endAngles.y - startAngles.y) * interp), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(startAngles.z + (endAngles.z - startAngles.z) * interp), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(startPos.x + (endPos.x - startPos.x) * interp), (float)(startPos.y + (endPos.y - startPos.y) * interp), (float)(startPos.z + (endPos.z - startPos.z) * interp));
                GlStateManager.func_179114_b((float)(-animations.recoilAngle * (float)Math.sqrt(gunType.recoil) * 1.5f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)animations.recoilOffset.x, (float)animations.recoilOffset.y, (float)animations.recoilOffset.z);
                if (model.spinningCocking) {
                    GlStateManager.func_179109_b((float)model.spinPoint.x, (float)model.spinPoint.y, (float)model.spinPoint.z);
                    float pumped = animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing;
                    GlStateManager.func_179114_b((float)(pumped * 180.0f + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)(-model.spinPoint.x), (float)(-model.spinPoint.y), (float)(-model.spinPoint.z));
                }
                if (!animations.reloading) break;
                float effectiveReloadAnimationProgress = animations.lastReloadAnimationProgress + (animations.reloadAnimationProgress - animations.lastReloadAnimationProgress) * smoothing;
                reloadRotate = 1.0f;
                if (effectiveReloadAnimationProgress < model.tiltGunTime) {
                    reloadRotate = effectiveReloadAnimationProgress / model.tiltGunTime;
                }
                if (effectiveReloadAnimationProgress > model.tiltGunTime + model.unloadClipTime + model.loadClipTime) {
                    reloadRotate = 1.0f - (effectiveReloadAnimationProgress - (model.tiltGunTime + model.unloadClipTime + model.loadClipTime)) / model.untiltGunTime;
                }
                switch (model.animationType) {
                    case BOTTOM_CLIP: 
                    case PISTOL_CLIP: 
                    case SHOTGUN: 
                    case END_LOADED: {
                        GlStateManager.func_179114_b((float)(60.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179114_b((float)(30.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)(0.25f * reloadRotate), (float)0.0f, (float)0.0f);
                        break block0;
                    }
                    case BACK_LOADED: {
                        GlStateManager.func_179114_b((float)(-75.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179114_b((float)(-30.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)(0.5f * reloadRotate), (float)0.0f, (float)0.0f);
                        break block0;
                    }
                    case BULLPUP: {
                        GlStateManager.func_179114_b((float)(70.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179114_b((float)(10.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)(0.5f * reloadRotate), (float)(-0.2f * reloadRotate), (float)0.0f);
                        break block0;
                    }
                    case RIFLE: {
                        GlStateManager.func_179114_b((float)(30.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179114_b((float)(-30.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)(0.5f * reloadRotate), (float)0.0f, (float)(-0.5f * reloadRotate));
                        break block0;
                    }
                    case RIFLE_TOP: 
                    case REVOLVER: {
                        GlStateManager.func_179114_b((float)(30.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179114_b((float)(10.0f * reloadRotate), (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)(-10.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)(0.1f * reloadRotate), (float)(-0.2f * reloadRotate), (float)(-0.1f * reloadRotate));
                        break block0;
                    }
                    case ALT_PISTOL_CLIP: {
                        GlStateManager.func_179114_b((float)(60.0f * reloadRotate * (float)flip), (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)(0.15f * reloadRotate), (float)(0.25f * reloadRotate), (float)0.0f);
                        break block0;
                    }
                    case STRIKER: {
                        GlStateManager.func_179114_b((float)(-35.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)(0.2f * reloadRotate), (float)0.0f, (float)(-0.1f * reloadRotate));
                        break block0;
                    }
                    case GENERIC: {
                        GlStateManager.func_179114_b((float)(45.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179109_b((float)(-0.2f * reloadRotate), (float)(-0.5f * reloadRotate), (float)0.0f);
                        break block0;
                    }
                    case CUSTOM: {
                        GlStateManager.func_179114_b((float)(model.rotateGunVertical * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179114_b((float)(model.rotateGunHorizontal * reloadRotate), (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)(model.tiltGun * reloadRotate), (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)(model.translateGun.x * reloadRotate), (float)(model.translateGun.y * reloadRotate), (float)(model.translateGun.z * reloadRotate));
                        break block0;
                    }
                }
                break;
            }
        }
        this.renderGun(item, gunType, f, model, animations, reloadRotate);
        GlStateManager.func_179121_F();
    }

    public void renderGun(ItemStack item, GunType type, float f, ModelGun model, GunAnimations animations, float reloadRotate) {
        if (renderEngine == null) {
            renderEngine = Minecraft.func_71410_x().field_71446_o;
        }
        if (animations == null) {
            animations = GunAnimations.defaults;
        }
        AttachmentType scopeAttachment = type.getScope(item);
        AttachmentType barrelAttachment = type.getBarrel(item);
        AttachmentType stockAttachment = type.getStock(item);
        AttachmentType gripAttachment = type.getGrip(item);
        ItemStack scopeItemStack = type.getScopeItemStack(item);
        ItemStack barrelItemStack = type.getBarrelItemStack(item);
        ItemStack stockItemStack = type.getStockItemStack(item);
        ItemStack gripItemStack = type.getGripItemStack(item);
        ItemStack[] bulletStacks = new ItemStack[type.numAmmoItemsInGun];
        boolean empty = true;
        for (int i = 0; i < type.numAmmoItemsInGun; ++i) {
            bulletStacks[i] = ((ItemGun)item.func_77973_b()).getBulletItemStack(item, i);
            if (bulletStacks[i] == null || !(bulletStacks[i].func_77973_b() instanceof ItemBullet) || bulletStacks[i].func_77952_i() >= bulletStacks[i].func_77958_k()) continue;
            empty = false;
        }
        Paintjob paintjob = type.getPaintjob(item.func_77952_i());
        if (bindTextures) {
            if (PaintableType.HasCustomPaintjob(item)) {
                renderEngine.func_110577_a(PaintableType.GetCustomPaintjobSkinResource(item));
            } else {
                renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(paintjob));
            }
        }
        if (scopeAttachment != null) {
            GlStateManager.func_179109_b((float)0.0f, (float)(-scopeAttachment.model.renderOffset / 16.0f), (float)0.0f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)type.modelScale, (float)type.modelScale, (float)type.modelScale);
        model.renderGun(f);
        model.renderCustom(f, animations);
        if (scopeAttachment == null && !model.scopeIsOnSlide && !model.scopeIsOnBreakAction) {
            model.renderDefaultScope(f);
        }
        if (barrelAttachment == null) {
            model.renderDefaultBarrel(f);
        }
        if (stockAttachment == null) {
            model.renderDefaultStock(f);
        }
        if (gripAttachment == null && !model.gripIsOnPump) {
            model.renderDefaultGrip(f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-(animations.lastGunSlide + (animations.gunSlide - animations.lastGunSlide) * smoothing) * model.gunSlideDistance), (float)0.0f, (float)0.0f);
        model.renderSlide(f);
        if (scopeAttachment == null && model.scopeIsOnSlide) {
            model.renderDefaultScope(f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)model.barrelBreakPoint.x, (float)model.barrelBreakPoint.y, (float)model.barrelBreakPoint.z);
        GlStateManager.func_179114_b((float)(reloadRotate * -model.breakAngle), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-model.barrelBreakPoint.x), (float)(-model.barrelBreakPoint.y), (float)(-model.barrelBreakPoint.z));
        model.renderBreakAction(f);
        if (scopeAttachment == null && model.scopeIsOnBreakAction) {
            model.renderDefaultScope(f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.pumpHandleDistance), (float)0.0f, (float)0.0f);
        model.renderPump(f);
        if (gripAttachment == null && model.gripIsOnPump) {
            model.renderDefaultGrip(f);
        }
        GlStateManager.func_179121_F();
        if (type.mode == EnumFireMode.MINIGUN) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)model.minigunBarrelOrigin.x, (float)model.minigunBarrelOrigin.y, (float)model.minigunBarrelOrigin.z);
            GlStateManager.func_179114_b((float)animations.minigunBarrelRotation, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)(-model.minigunBarrelOrigin.x), (float)(-model.minigunBarrelOrigin.y), (float)(-model.minigunBarrelOrigin.z));
            model.renderMinigunBarrel(f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)model.revolverFlipPoint.x, (float)model.revolverFlipPoint.y, (float)model.revolverFlipPoint.z);
        GlStateManager.func_179114_b((float)(reloadRotate * model.revolverFlipAngle), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-model.revolverFlipPoint.x), (float)(-model.revolverFlipPoint.y), (float)(-model.revolverFlipPoint.z));
        model.renderRevolverBarrel(f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        boolean shouldRender = true;
        switch (model.animationType) {
            case END_LOADED: 
            case BACK_LOADED: {
                if (!empty) break;
                shouldRender = false;
                break;
            }
        }
        if (shouldRender && animations.reloading && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            float effectiveReloadAnimationProgress = animations.lastReloadAnimationProgress + (animations.reloadAnimationProgress - animations.lastReloadAnimationProgress) * smoothing;
            float clipPosition = 0.0f;
            if (effectiveReloadAnimationProgress > model.tiltGunTime && effectiveReloadAnimationProgress < model.tiltGunTime + model.unloadClipTime) {
                clipPosition = (effectiveReloadAnimationProgress - model.tiltGunTime) / model.unloadClipTime;
            }
            if (effectiveReloadAnimationProgress >= model.tiltGunTime + model.unloadClipTime && effectiveReloadAnimationProgress < model.tiltGunTime + model.unloadClipTime + model.loadClipTime) {
                clipPosition = 1.0f - (effectiveReloadAnimationProgress - (model.tiltGunTime + model.unloadClipTime)) / model.loadClipTime;
            }
            float loadOnlyClipPosition = Math.max(0.0f, Math.min(1.0f, 1.0f - (effectiveReloadAnimationProgress - model.tiltGunTime) / (model.unloadClipTime + model.loadClipTime)));
            switch (model.animationType) {
                case BREAK_ACTION: {
                    GlStateManager.func_179109_b((float)model.barrelBreakPoint.x, (float)model.barrelBreakPoint.y, (float)model.barrelBreakPoint.z);
                    GlStateManager.func_179114_b((float)(reloadRotate * -model.breakAngle), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)(-model.barrelBreakPoint.x), (float)(-model.barrelBreakPoint.y), (float)(-model.barrelBreakPoint.z));
                    GlStateManager.func_179109_b((float)(-1.0f * clipPosition), (float)0.0f, (float)0.0f);
                    break;
                }
                case REVOLVER: {
                    GlStateManager.func_179109_b((float)model.revolverFlipPoint.x, (float)model.revolverFlipPoint.y, (float)model.revolverFlipPoint.z);
                    GlStateManager.func_179114_b((float)(reloadRotate * model.revolverFlipAngle), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)(-model.revolverFlipPoint.x), (float)(-model.revolverFlipPoint.y), (float)(-model.revolverFlipPoint.z));
                    GlStateManager.func_179109_b((float)(-1.0f * clipPosition), (float)0.0f, (float)0.0f);
                    break;
                }
                case BOTTOM_CLIP: {
                    GlStateManager.func_179114_b((float)(-180.0f * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)(60.0f * clipPosition), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)(0.5f * clipPosition), (float)0.0f, (float)0.0f);
                    break;
                }
                case PISTOL_CLIP: {
                    GlStateManager.func_179114_b((float)(-90.0f * clipPosition * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)(-1.0f * clipPosition), (float)0.0f);
                    break;
                }
                case ALT_PISTOL_CLIP: {
                    GlStateManager.func_179114_b((float)(5.0f * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)(-3.0f * clipPosition), (float)0.0f);
                    break;
                }
                case SIDE_CLIP: {
                    GlStateManager.func_179114_b((float)(180.0f * clipPosition), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(60.0f * clipPosition), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)(0.5f * clipPosition), (float)0.0f, (float)0.0f);
                    break;
                }
                case BULLPUP: {
                    GlStateManager.func_179114_b((float)(-150.0f * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)(60.0f * clipPosition), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)(1.0f * clipPosition), (float)(-0.5f * clipPosition), (float)0.0f);
                    break;
                }
                case P90: {
                    GlStateManager.func_179114_b((float)(-15.0f * reloadRotate * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)(0.075f * reloadRotate), (float)0.0f);
                    GlStateManager.func_179109_b((float)(-2.0f * clipPosition), (float)(-0.3f * clipPosition), (float)(0.5f * clipPosition));
                    break;
                }
                case RIFLE: {
                    float thing = clipPosition * model.numBulletsInReloadAnimation;
                    int bulletNum = MathHelper.func_76141_d((float)thing);
                    float bulletProgress = thing - (float)bulletNum;
                    GlStateManager.func_179114_b((float)(bulletProgress * 15.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(bulletProgress * 15.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)(bulletProgress * -1.0f), (float)0.0f, (float)(bulletProgress * 0.5f));
                    break;
                }
                case RIFLE_TOP: {
                    float thing = clipPosition * model.numBulletsInReloadAnimation;
                    int bulletNum = MathHelper.func_76141_d((float)thing);
                    float bulletProgress = thing - (float)bulletNum;
                    GlStateManager.func_179114_b((float)(bulletProgress * 55.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(bulletProgress * 95.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)(bulletProgress * -0.1f), (float)(bulletProgress * 1.0f), (float)(bulletProgress * 0.5f));
                    break;
                }
                case SHOTGUN: 
                case STRIKER: {
                    float thing = clipPosition * model.numBulletsInReloadAnimation;
                    int bulletNum = MathHelper.func_76141_d((float)thing);
                    float bulletProgress = thing - (float)bulletNum;
                    GlStateManager.func_179114_b((float)(bulletProgress * -30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)(bulletProgress * -0.5f), (float)(bulletProgress * -1.0f), (float)0.0f);
                    break;
                }
                case CUSTOM: {
                    GlStateManager.func_179114_b((float)(model.rotateClipVertical * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)(model.rotateClipHorizontal * clipPosition), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(model.tiltClip * clipPosition), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)(model.translateClip.x * clipPosition), (float)(model.translateClip.y * clipPosition), (float)(model.translateClip.z * clipPosition));
                    break;
                }
                case END_LOADED: {
                    float dYaw = loadOnlyClipPosition > 0.5f ? loadOnlyClipPosition * 2.0f - 1.0f : 0.0f;
                    GlStateManager.func_179114_b((float)(-45.0f * dYaw), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)(-model.endLoadedAmmoDistance * dYaw), (float)(-0.5f * dYaw), (float)0.0f);
                    float xDisplacement = loadOnlyClipPosition < 0.5f ? loadOnlyClipPosition * 2.0f : 1.0f;
                    GlStateManager.func_179109_b((float)(model.endLoadedAmmoDistance * xDisplacement), (float)0.0f, (float)0.0f);
                    break;
                }
                case BACK_LOADED: {
                    float dYaw = loadOnlyClipPosition > 0.5f ? loadOnlyClipPosition * 2.0f - 1.0f : 0.0f;
                    GlStateManager.func_179109_b((float)(model.endLoadedAmmoDistance * dYaw), (float)(-0.5f * dYaw), (float)0.0f);
                    float xDisplacement = loadOnlyClipPosition < 0.5f ? loadOnlyClipPosition * 2.0f : 1.0f;
                    GlStateManager.func_179109_b((float)(-model.endLoadedAmmoDistance * xDisplacement), (float)0.0f, (float)0.0f);
                }
            }
        }
        if (shouldRender) {
            model.renderAmmo(f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        if (scopeAttachment != null) {
            GlStateManager.func_179094_E();
            Paintjob scopepaintjob = scopeAttachment.getPaintjob(scopeItemStack.func_77952_i());
            renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(scopepaintjob));
            if (model.scopeIsOnBreakAction) {
                GlStateManager.func_179109_b((float)model.barrelBreakPoint.x, (float)model.barrelBreakPoint.y, (float)model.barrelBreakPoint.z);
                GlStateManager.func_179114_b((float)(reloadRotate * -model.breakAngle), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(-model.barrelBreakPoint.x), (float)(-model.barrelBreakPoint.y), (float)(-model.barrelBreakPoint.z));
            }
            GlStateManager.func_179109_b((float)(model.scopeAttachPoint.x * type.modelScale), (float)(model.scopeAttachPoint.y * type.modelScale), (float)(model.scopeAttachPoint.z * type.modelScale));
            if (model.scopeIsOnSlide) {
                GlStateManager.func_179109_b((float)(-(animations.lastGunSlide + (animations.gunSlide - animations.lastGunSlide) * smoothing) * model.gunSlideDistance), (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)scopeAttachment.modelScale, (float)scopeAttachment.modelScale, (float)scopeAttachment.modelScale);
            ModelAttachment scopeModel = scopeAttachment.model;
            if (scopeModel != null) {
                scopeModel.renderAttachment(f);
            }
            renderEngine.func_110577_a(FlansModResourceHandler.getTexture(type));
            GlStateManager.func_179121_F();
        }
        if (gripAttachment != null) {
            GlStateManager.func_179094_E();
            Paintjob grippaintjob = gripAttachment.getPaintjob(gripItemStack.func_77952_i());
            renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(grippaintjob));
            GlStateManager.func_179109_b((float)(model.gripAttachPoint.x * type.modelScale), (float)(model.gripAttachPoint.y * type.modelScale), (float)(model.gripAttachPoint.z * type.modelScale));
            if (model.gripIsOnPump) {
                GlStateManager.func_179109_b((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.pumpHandleDistance), (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)gripAttachment.modelScale, (float)gripAttachment.modelScale, (float)gripAttachment.modelScale);
            ModelAttachment gripModel = gripAttachment.model;
            if (gripModel != null) {
                gripModel.renderAttachment(f);
            }
            renderEngine.func_110577_a(FlansModResourceHandler.getTexture(type));
            GlStateManager.func_179121_F();
        }
        if (barrelAttachment != null) {
            GlStateManager.func_179094_E();
            Paintjob barrelpaintjob = barrelAttachment.getPaintjob(barrelItemStack.func_77952_i());
            renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(barrelpaintjob));
            GlStateManager.func_179109_b((float)(model.barrelAttachPoint.x * type.modelScale), (float)(model.barrelAttachPoint.y * type.modelScale), (float)(model.barrelAttachPoint.z * type.modelScale));
            GlStateManager.func_179152_a((float)barrelAttachment.modelScale, (float)barrelAttachment.modelScale, (float)barrelAttachment.modelScale);
            ModelAttachment barrelModel = barrelAttachment.model;
            if (barrelModel != null) {
                barrelModel.renderAttachment(f);
            }
            renderEngine.func_110577_a(FlansModResourceHandler.getTexture(type));
            GlStateManager.func_179121_F();
        }
        if (stockAttachment != null) {
            GlStateManager.func_179094_E();
            Paintjob stockpaintjob = stockAttachment.getPaintjob(stockItemStack.func_77952_i());
            renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(stockpaintjob));
            GlStateManager.func_179109_b((float)(model.stockAttachPoint.x * type.modelScale), (float)(model.stockAttachPoint.y * type.modelScale), (float)(model.stockAttachPoint.z * type.modelScale));
            GlStateManager.func_179152_a((float)stockAttachment.modelScale, (float)stockAttachment.modelScale, (float)stockAttachment.modelScale);
            ModelAttachment stockModel = stockAttachment.model;
            if (stockModel != null) {
                stockModel.renderAttachment(f);
            }
            renderEngine.func_110577_a(FlansModResourceHandler.getTexture(type));
            GlStateManager.func_179121_F();
        }
    }

    static {
        bindTextures = true;
    }
}

