/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.handlers.FlansModResourceHandler;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.guns.AAGunType;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.FireableGun;
import com.flansmod.common.guns.FiredShot;
import com.flansmod.common.guns.ShotHandler;
import com.flansmod.common.network.PacketAAGunAngles;
import com.flansmod.common.network.PacketMGFire;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

public class EntityAAGun
extends Entity
implements IEntityAdditionalSpawnData {
    private int sUpdateTime;
    private double sPosX;
    private double sPosY;
    private double sPosZ;
    private double sYaw;
    private double sPitch;
    private double field_9388_j;
    private double field_9387_k;
    private double field_9386_l;
    private int health;
    private int shootDelay;
    public float gunYaw;
    public float gunPitch;
    public float prevGunYaw;
    public float prevGunPitch;
    public float[] barrelRecoil;
    public AAGunType type;
    public Entity towedByEntity;
    public ItemStack[] ammo;
    public int reloadTimer;
    public int currentBarrel;
    public boolean mouseHeld;
    public boolean wasShooting;
    public EntityPlayer placer = null;
    public String placerName = null;
    public Entity target = null;
    public static final float targetAcquireInterval = 10.0f;
    public int ticksSinceUsed = 0;
    private float yOffset;

    public EntityAAGun(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(2.0f, 2.0f);
        this.yOffset = 0.0f;
        this.gunYaw = 0.0f;
        this.gunPitch = 0.0f;
        this.shootDelay = 0;
    }

    public EntityAAGun(World world, AAGunType type1, double d, double d1, double d2, EntityPlayer p) {
        this(world);
        this.placer = p;
        this.placerName = p.func_70005_c_();
        this.type = type1;
        this.initType();
        this.func_70107_b(d, d1, d2);
    }

    public void func_70107_b(double d, double d1, double d2) {
        this.field_70165_t = d;
        this.field_70163_u = d1;
        this.field_70161_v = d2;
        float f = this.field_70130_N / 2.0f;
        float f1 = this.field_70131_O;
        this.func_174826_a(new AxisAlignedBB(d - (double)f, d1 - (double)this.yOffset, d2 - (double)f, d + (double)f, d1 - (double)this.yOffset + (double)f1, d2 + (double)f));
    }

    public void func_180426_a(double d, double d1, double d2, float f, float f1, int i, boolean b) {
        this.sPosX = d;
        this.sPosY = d1;
        this.sPosZ = d2;
        this.sYaw = f;
        this.sPitch = f1;
        this.sUpdateTime = i;
    }

    public void initType() {
        this.health = this.type.health;
        this.barrelRecoil = new float[this.type.numBarrels];
        this.ammo = new ItemStack[this.type.numBarrels];
        for (int i = 0; i < this.type.numBarrels; ++i) {
            this.ammo[i] = ItemStack.field_190927_a.func_77946_l();
        }
    }

    protected void func_70088_a() {
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
    }

    public void func_70108_f(Entity entity) {
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return 0.0;
    }

    public void setMouseHeld(boolean held) {
        this.mouseHeld = held;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (damagesource.field_76373_n.equals("player")) {
            Entity player = damagesource.func_76346_g();
            if (!this.func_184215_y(player)) {
                if (this.func_184207_aI()) {
                    return ((Entity)this.func_184188_bt().get(0)).func_70097_a(damagesource, i);
                }
                if (TeamsManager.canBreakGuns) {
                    this.func_70106_y();
                }
            }
        } else {
            this.health = (int)((float)this.health - i);
            if (!this.field_70170_p.field_72995_K && this.health <= 0) {
                this.func_70106_y();
            }
        }
        return true;
    }

    public Vec3d rotate(double x, double y, double z) {
        double cosYaw = Math.cos(180.0f - this.gunYaw * (float)Math.PI / 180.0f);
        double sinYaw = Math.sin(180.0f - this.gunYaw * (float)Math.PI / 180.0f);
        double cosPitch = Math.cos(this.gunPitch * (float)Math.PI / 180.0f);
        double sinPitch = Math.sin(this.gunPitch * (float)Math.PI / 180.0f);
        double newX = x * cosYaw + (y * sinPitch + z * cosPitch) * sinYaw;
        double newY = y * cosPitch - z * sinPitch;
        double newZ = -x * sinYaw + (y * sinPitch + z * cosPitch) * cosYaw;
        return new Vec3d(newX, newY, newZ);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevGunYaw = this.gunYaw;
        this.prevGunPitch = this.gunPitch;
        ++this.ticksSinceUsed;
        if (TeamsManager.aaLife > 0 && this.ticksSinceUsed > TeamsManager.aaLife * 20) {
            this.func_70106_y();
        }
        if (this.func_184179_bs() != null) {
            this.ticksSinceUsed = 0;
            this.gunYaw = this.func_184179_bs().field_70177_z - 90.0f;
            this.gunPitch = this.func_184179_bs().field_70125_A;
        }
        if (this.gunPitch > this.type.bottomViewLimit) {
            this.gunPitch = this.type.bottomViewLimit;
        }
        if (this.gunPitch < -this.type.topViewLimit) {
            this.gunPitch = -this.type.topViewLimit;
        }
        int i = 0;
        while (i < this.type.numBarrels) {
            int n = i++;
            this.barrelRecoil[n] = this.barrelRecoil[n] * 0.9f;
        }
        if (this.shootDelay > 0) {
            --this.shootDelay;
        }
        if (this.isSentry()) {
            if (this.target != null && this.target.field_70128_L) {
                this.target = null;
            }
            if (this.target == null && (float)this.field_70173_aa % 10.0f == 0.0f) {
                this.target = this.getValidTarget();
            }
            if (this.target != null) {
                double dX = this.target.field_70165_t - this.field_70165_t;
                double dY = this.target.field_70163_u - (this.field_70163_u + 1.5);
                double dZ = this.target.field_70161_v - this.field_70161_v;
                double distanceToTarget = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
                if (distanceToTarget > (double)this.type.targetRange) {
                    this.target = null;
                } else {
                    float newYaw = 180.0f + (float)Math.atan2(dZ, dX) * 180.0f / 3.14159f;
                    float newPitch = -((float)Math.atan2(dY, Math.sqrt(dX * dX + dZ * dZ))) * 180.0f / 3.14159f;
                    float turnSpeed = 0.25f;
                    this.gunYaw += (newYaw - this.gunYaw) * turnSpeed;
                    this.gunPitch += (newPitch - this.gunPitch) * turnSpeed;
                }
            }
        }
        if (!this.field_70122_E && !this.field_70170_p.field_72995_K) {
            this.field_70181_x -= 0.0245;
        }
        this.field_70159_w *= 0.5;
        this.field_70179_y *= 0.5;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70170_p.field_72995_K && this.func_184179_bs() != null && this.func_184179_bs() == FMLClientHandler.instance().getClient().field_71439_g) {
            this.checkForShooting();
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.sUpdateTime > 0) {
                double d12;
                double d1 = this.field_70165_t + (this.sPosX - this.field_70165_t) / (double)this.sUpdateTime;
                double d5 = this.field_70163_u + (this.sPosY - this.field_70163_u) / (double)this.sUpdateTime;
                double d9 = this.field_70161_v + (this.sPosZ - this.field_70161_v) / (double)this.sUpdateTime;
                for (d12 = this.sYaw - (double)this.field_70177_z; d12 < -180.0; d12 += 360.0) {
                }
                while (d12 >= 180.0) {
                    d12 -= 360.0;
                }
                this.field_70177_z = (float)((double)this.field_70177_z + d12 / (double)this.sUpdateTime);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.sPitch - (double)this.field_70125_A) / (double)this.sUpdateTime);
                --this.sUpdateTime;
                this.func_70107_b(d1, d5, d9);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            return;
        }
        if (this.func_184179_bs() != null && this.func_184179_bs().field_70128_L) {
            this.func_184226_ay();
        }
        if (this.reloadTimer > 0) {
            --this.reloadTimer;
        } else {
            for (i = 0; i < this.type.numBarrels; ++i) {
                int slot;
                if (this.ammo[i] != null && !this.ammo[i].func_190926_b() && this.ammo[i].func_77952_i() == this.ammo[i].func_77958_k()) {
                    this.ammo[i] = ItemStack.field_190927_a.func_77946_l();
                }
                if (this.ammo[i] != null && !this.ammo[i].func_190926_b() || this.func_184179_bs() == null || !(this.func_184179_bs() instanceof EntityPlayer) || (slot = this.findAmmo((EntityPlayer)this.func_184179_bs())) < 0) continue;
                this.ammo[i] = ((EntityPlayer)this.func_184179_bs()).field_71071_by.func_70301_a(slot);
                if (!((EntityPlayer)this.func_184179_bs()).field_71075_bZ.field_75098_d) {
                    ((EntityPlayer)this.func_184179_bs()).field_71071_by.func_70298_a(slot, 1);
                }
                this.reloadTimer = this.type.reloadTime;
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.type.reloadSound, true);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.reloadTimer <= 0 && this.shootDelay <= 0) {
            Boolean shootPlayer = this.mouseHeld && this.func_184179_bs() instanceof EntityPlayerMP;
            if (this.target != null || shootPlayer.booleanValue()) {
                EntityPlayerMP player = shootPlayer != false ? (EntityPlayerMP)this.func_184179_bs() : null;
                for (int j = 0; j < this.type.numBarrels; ++j) {
                    if (this.type.shareAmmo) {
                        j = 0;
                    }
                    if (this.shootDelay > 0 || this.ammo[j] == null || this.ammo[j].func_190926_b() || this.type.fireAlternately && (!this.type.fireAlternately || this.currentBarrel != j)) continue;
                    BulletType bullet = BulletType.getBullet(this.ammo[j].func_77973_b());
                    if (shootPlayer.booleanValue()) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            this.ammo[j].func_77972_a(1, (EntityLivingBase)player);
                        }
                    } else {
                        this.ammo[j].func_77964_b(this.ammo[j].func_77952_i() + 1);
                    }
                    this.shootDelay = this.type.shootDelay;
                    this.barrelRecoil[j] = this.type.recoil;
                    Vec3d origin = this.rotate((double)this.type.barrelX[this.currentBarrel] / 16.0 - (double)this.type.barrelZ[this.currentBarrel] / 16.0, (double)this.type.barrelY[this.currentBarrel] / 16.0, (double)this.type.barrelX[this.currentBarrel] / 16.0 + (double)this.type.barrelZ[this.currentBarrel] / 16.0).func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    Double radianYaw = Math.toRadians(this.gunYaw + 90.0f);
                    Double radianPitch = Math.toRadians(this.gunPitch);
                    Vector3f shootingDirection = new Vector3f(-Math.sin(radianYaw), Math.cos(radianYaw) * -Math.sin(radianPitch), Math.cos(radianYaw) * Math.cos(radianPitch));
                    FireableGun weapon = new FireableGun(this.type, this.type.damage, this.type.accuracy, this.type.damage);
                    FiredShot shot = new FiredShot(weapon, bullet, this, player);
                    ShotHandler.fireGun(this.field_70170_p, shot, bullet.numBullets, new Vector3f(origin), shootingDirection);
                    PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.type.shootSound, true);
                }
                this.currentBarrel = (this.currentBarrel + 1) % this.type.numBarrels;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketAAGunAngles(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0f, this.field_71093_bK);
        }
    }

    public boolean isSentry() {
        return this.type.targetMobs || this.type.targetPlayers;
    }

    public Entity getValidTarget() {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        if (this.placer == null && this.placerName != null) {
            this.placer = this.field_70170_p.func_72924_a(this.placerName);
        }
        for (Object obj : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)this.type.targetRange, (double)this.type.targetRange, (double)this.type.targetRange))) {
            Entity candidateEntity = (Entity)obj;
            if ((!this.type.targetMobs || !(candidateEntity instanceof EntityMob)) && (!this.type.targetPlayers || !(candidateEntity instanceof EntityPlayer)) || !(candidateEntity.func_70068_e((Entity)this) < (double)(this.type.targetRange * this.type.targetRange))) continue;
            if (candidateEntity instanceof EntityPlayer) {
                if (candidateEntity == this.placer || candidateEntity.func_70005_c_().equals(this.placerName)) continue;
                if (TeamsManager.enabled && TeamsManager.getInstance().currentRound != null && this.placer != null) {
                    PlayerData placerData = PlayerHandler.getPlayerData(this.placer, this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
                    PlayerData candidateData = PlayerHandler.getPlayerData((EntityPlayer)candidateEntity, this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
                    if (candidateData.team == Team.spectators || candidateData.team == null || !TeamsManager.getInstance().currentRound.gametype.playerCanAttack((EntityPlayerMP)this.placer, placerData.team, (EntityPlayerMP)candidateEntity, candidateData.team)) continue;
                }
            }
            return candidateEntity;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void checkForShooting() {
        if (Mouse.isButtonDown((int)0) && !this.wasShooting && !FlansMod.proxy.isScreenOpen()) {
            FlansMod.getPacketHandler().sendToServer(new PacketMGFire(true));
            this.wasShooting = true;
        } else if (!Mouse.isButtonDown((int)0) && this.wasShooting) {
            FlansMod.getPacketHandler().sendToServer(new PacketMGFire(false));
            this.wasShooting = false;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.func_145779_a(this.type.getItem(), 1);
        for (ItemStack stack : this.ammo) {
            if (stack == null || stack.func_190926_b()) continue;
            this.func_70099_a(stack, 0.5f);
        }
    }

    public void func_184232_k(Entity passenger) {
        double x = (double)this.type.gunnerX / 16.0;
        double y = (double)this.type.gunnerY / 16.0;
        double z = (double)this.type.gunnerZ / 16.0;
        double cosYaw = Math.cos((double)(-this.gunYaw) / 180.0 * Math.PI);
        double sinYaw = Math.sin((double)(-this.gunYaw) / 180.0 * Math.PI);
        double cosPitch = Math.cos((double)this.gunPitch / 180.0 * Math.PI);
        double sinPitch = Math.sin((double)this.gunPitch / 180.0 * Math.PI);
        double x2 = x * cosYaw + z * sinYaw;
        double z2 = -x * sinYaw + z * cosYaw;
        passenger.func_70107_b(this.field_70165_t + x2, this.field_70163_u + y, this.field_70161_v + z2);
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("Type", this.type.shortName);
        nbttagcompound.func_74768_a("Health", this.health);
        nbttagcompound.func_74776_a("RotationYaw", this.field_70177_z);
        nbttagcompound.func_74776_a("RotationPitch", this.field_70125_A);
        for (int i = 0; i < this.type.numBarrels; ++i) {
            if (this.ammo[i] == null) continue;
            nbttagcompound.func_74782_a("Ammo " + i, (NBTBase)this.ammo[i].func_77955_b(new NBTTagCompound()));
        }
        if (this.placer != null) {
            nbttagcompound.func_74778_a("Placer", this.placer.func_70005_c_());
        } else if (this.placerName != null) {
            nbttagcompound.func_74778_a("Placer", this.placerName);
        }
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.type = AAGunType.getAAGun(nbttagcompound.func_74779_i("Type"));
        this.initType();
        this.health = nbttagcompound.func_74762_e("Health");
        this.field_70177_z = nbttagcompound.func_74760_g("RotationYaw");
        this.field_70125_A = nbttagcompound.func_74760_g("RotationPitch");
        for (int i = 0; i < this.type.numBarrels; ++i) {
            this.ammo[i] = new ItemStack(nbttagcompound.func_74775_l("Ammo " + i));
        }
        this.placerName = nbttagcompound.func_74779_i("Placer");
    }

    public boolean func_184230_a(EntityPlayer entityplayer, EnumHand hand) {
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer && this.func_184179_bs() != entityplayer) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_184179_bs() == entityplayer) {
                entityplayer.func_184210_p();
                return true;
            }
            if (!this.isSentry()) {
                entityplayer.func_184220_m((Entity)this);
            }
            for (int i = 0; i < (this.type.shareAmmo ? 1 : this.type.numBarrels); ++i) {
                int slot;
                if (this.ammo[i] != null && !this.ammo[i].func_190926_b() || (slot = this.findAmmo(entityplayer)) < 0) continue;
                this.ammo[i] = entityplayer.field_71071_by.func_70301_a(slot).func_77946_l();
                this.ammo[i].func_190920_e(1);
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    entityplayer.field_71071_by.func_70298_a(slot, 1);
                }
                this.reloadTimer = this.type.reloadTime;
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, FlansModResourceHandler.getSoundEvent(this.type.reloadSound), SoundCategory.PLAYERS, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f), true);
            }
        }
        return true;
    }

    public int findAmmo(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!this.type.isAmmo(stack)) continue;
            return i;
        }
        return -1;
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.type.shortName);
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.type = AAGunType.getAAGun(ByteBufUtils.readUTF8String((ByteBuf)data));
            this.initType();
        }
        catch (Exception e) {
            FlansMod.log.error("Failed to retreive AA gun type from server.");
            super.func_70106_y();
            FlansMod.log.throwing((Throwable)e);
        }
    }

    public boolean canRiderInteract() {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.type.item, 1, 0);
    }
}

