/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.debug.EntityDebugDot;
import com.flansmod.client.handlers.FlansModResourceHandler;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.common.EntityItemCustomRender;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityDamageSourceFlan;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.EntityMG;
import com.flansmod.common.guns.EnumSecondaryFunction;
import com.flansmod.common.guns.FireableGun;
import com.flansmod.common.guns.FiredShot;
import com.flansmod.common.guns.GrenadeType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.InventoryHelper;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGrenade;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.guns.ShootBulletHandler;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.guns.ShotHandler;
import com.flansmod.common.guns.raytracing.FlansModRaytracer;
import com.flansmod.common.network.PacketGunFire;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.network.PacketReload;
import com.flansmod.common.teams.EntityFlag;
import com.flansmod.common.teams.EntityFlagpole;
import com.flansmod.common.teams.EntityGunItem;
import com.flansmod.common.types.IPaintableItem;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.PaintableType;
import com.flansmod.common.vector.Vector3f;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

public class ItemGun
extends Item
implements IPaintableItem {
    private GunType type;
    private int soundDelay = 0;
    private static boolean rightMouseHeld;
    private static boolean lastRightMouseHeld;
    private static boolean leftMouseHeld;
    private static boolean lastLeftMouseHeld;
    protected static final UUID KNOCKBACK_RESIST_MODIFIER;
    protected static final UUID MOVEMENT_SPEED_MODIFIER;

    public GunType GetType() {
        return this.type;
    }

    @Override
    public InfoType getInfoType() {
        return this.type;
    }

    @Override
    public PaintableType GetPaintableType() {
        return this.type;
    }

    private static boolean GetMouseHeld(EnumHand hand) {
        if (FlansMod.shootOnRightClick) {
            return hand == EnumHand.MAIN_HAND ? rightMouseHeld : leftMouseHeld;
        }
        return hand == EnumHand.MAIN_HAND ? leftMouseHeld : rightMouseHeld;
    }

    private static boolean GetLastMouseHeld(EnumHand hand) {
        if (FlansMod.shootOnRightClick) {
            return hand == EnumHand.MAIN_HAND ? lastRightMouseHeld : lastLeftMouseHeld;
        }
        return hand == EnumHand.MAIN_HAND ? lastLeftMouseHeld : lastRightMouseHeld;
    }

    public ItemGun(GunType type) {
        this.field_77777_bU = 1;
        this.type = type;
        type.item = this;
        this.func_77656_e(0);
        this.setRegistryName(type.shortName);
        this.func_77637_a(FlansMod.tabFlanGuns);
    }

    public ItemStack getBulletItemStack(ItemStack gun, int id) {
        if (!gun.func_77942_o()) {
            gun.func_77982_d(new NBTTagCompound());
            return ItemStack.field_190927_a.func_77946_l();
        }
        if (!gun.func_77978_p().func_74764_b("ammo")) {
            NBTTagList ammoTagsList = new NBTTagList();
            for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
                ammoTagsList.func_74742_a((NBTBase)new NBTTagCompound());
            }
            gun.func_77978_p().func_74782_a("ammo", (NBTBase)ammoTagsList);
            return ItemStack.field_190927_a.func_77946_l();
        }
        NBTTagList ammoTagsList = gun.func_77978_p().func_150295_c("ammo", 10);
        NBTTagCompound ammoTags = ammoTagsList.func_150305_b(id);
        return new ItemStack(ammoTags);
    }

    public void setBulletItemStack(ItemStack gun, ItemStack bullet, int id) {
        NBTTagList ammoTagsList;
        if (!gun.func_77942_o()) {
            gun.func_77982_d(new NBTTagCompound());
        }
        if (!gun.func_77978_p().func_74764_b("ammo")) {
            ammoTagsList = new NBTTagList();
            for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
                ammoTagsList.func_74742_a((NBTBase)new NBTTagCompound());
            }
            gun.func_77978_p().func_74782_a("ammo", (NBTBase)ammoTagsList);
        }
        ammoTagsList = gun.func_77978_p().func_150295_c("ammo", 10);
        NBTTagCompound ammoTags = ammoTagsList.func_150305_b(id);
        if (bullet == null) {
            ammoTags = new NBTTagCompound();
        }
        bullet.func_77955_b(ammoTags);
    }

    public static void dropItem(World world, Entity entity, String itemName) {
        if (itemName != null && !world.field_72995_K) {
            int damage = 0;
            if (itemName.contains(".")) {
                damage = Integer.parseInt(itemName.split("\\.")[1]);
                itemName = itemName.split("\\.")[0];
            }
            ItemStack dropStack = InfoType.getRecipeElement(itemName, damage);
            entity.func_70099_a(dropStack, 0.5f);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityplayer, EnumHand hand) {
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        if (this.type.deployable) {
            Vec3d lookVec;
            float cosYaw = MathHelper.func_76134_b((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
            float sinYaw = MathHelper.func_76126_a((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
            float cosPitch = -MathHelper.func_76134_b((float)(-entityplayer.field_70125_A * 0.01745329f));
            float sinPitch = MathHelper.func_76126_a((float)(-entityplayer.field_70125_A * 0.01745329f));
            double length = 5.0;
            Vec3d posVec = new Vec3d(entityplayer.field_70165_t, entityplayer.field_70163_u + 1.62 - entityplayer.func_70033_W(), entityplayer.field_70161_v);
            RayTraceResult look = world.func_72901_a(posVec, lookVec = posVec.func_72441_c((double)(sinYaw * cosPitch) * length, (double)sinPitch * length, (double)(cosYaw * cosPitch) * length), true);
            if (look != null && look.field_72313_a == RayTraceResult.Type.BLOCK && look.field_178784_b == EnumFacing.UP) {
                int playerDir = MathHelper.func_76128_c((double)((double)(entityplayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                int i = look.func_178782_a().func_177958_n();
                int j = look.func_178782_a().func_177956_o();
                int k = look.func_178782_a().func_177952_p();
                if (!world.field_72995_K) {
                    if (world.func_180495_p(new BlockPos(i, j, k)).func_177230_c() == Blocks.field_150433_aE) {
                        --j;
                    }
                    if (!(!this.isSolid(world, i, j, k) || world.func_180495_p(new BlockPos(i, j + 1, k)).func_177230_c() != Blocks.field_150350_a && world.func_180495_p(new BlockPos(i, j + 1, k)).func_177230_c() != Blocks.field_150433_aE || world.func_180495_p(new BlockPos(i + (playerDir == 1 ? 1 : 0) - (playerDir == 3 ? 1 : 0), j + 1, k - (playerDir == 0 ? 1 : 0) + (playerDir == 2 ? 1 : 0))).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(new BlockPos(i + (playerDir == 1 ? 1 : 0) - (playerDir == 3 ? 1 : 0), j, k - (playerDir == 0 ? 1 : 0) + (playerDir == 2 ? 1 : 0))).func_177230_c() != Blocks.field_150350_a && world.func_180495_p(new BlockPos(i + (playerDir == 1 ? 1 : 0) - (playerDir == 3 ? 1 : 0), j, k - (playerDir == 0 ? 1 : 0) + (playerDir == 2 ? 1 : 0))).func_177230_c() != Blocks.field_150433_aE)) {
                        for (EntityMG mg : EntityMG.mgs) {
                            if (mg.blockX != i || mg.blockY != j + 1 || mg.blockZ != k || mg.field_70128_L) continue;
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
                        }
                        EntityMG mg = new EntityMG(world, i, j + 1, k, playerDir, this.type);
                        if (this.getBulletItemStack(itemstack, 0) != null) {
                            mg.ammo = this.getBulletItemStack(itemstack, 0);
                        }
                        world.func_72838_d((Entity)mg);
                        if (!entityplayer.field_71075_bZ.field_75098_d) {
                            itemstack.func_190920_e(0);
                        }
                    }
                }
            }
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                Minecraft.func_71410_x().field_71460_t.field_78516_c.func_78441_a();
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient(ItemStack gunstack, int gunSlot, World world, Entity entity, EnumHand hand, boolean hasOffHand) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        if (this.type.deployable) {
            return;
        }
        IScope currentScope = this.type.getCurrentScope(gunstack);
        if (!hasOffHand) {
            switch (hand) {
                case MAIN_HAND: {
                    if (!ItemGun.GetMouseHeld(EnumHand.OFF_HAND) || ItemGun.GetLastMouseHeld(EnumHand.OFF_HAND) || this.type.secondaryFunction != EnumSecondaryFunction.ADS_ZOOM && this.type.secondaryFunction != EnumSecondaryFunction.ZOOM) break;
                    FlansModClient.setScope(currentScope);
                    break;
                }
                case OFF_HAND: {
                    if (!ItemGun.GetMouseHeld(EnumHand.MAIN_HAND) || ItemGun.GetLastMouseHeld(EnumHand.MAIN_HAND) || this.type.secondaryFunction != EnumSecondaryFunction.ADS_ZOOM && this.type.secondaryFunction != EnumSecondaryFunction.ZOOM) break;
                    FlansModClient.setScope(currentScope);
                }
            }
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayer player = (EntityPlayer)entity;
        PlayerData data = PlayerHandler.getPlayerData(player);
        data.minigunSpeed *= 0.9f;
        Boolean hold = ItemGun.GetMouseHeld(hand);
        Boolean held = ItemGun.GetLastMouseHeld(hand);
        if (mc.field_71476_x != null && (mc.field_71476_x.field_72308_g instanceof EntityFlagpole || mc.field_71476_x.field_72308_g instanceof EntityFlag || mc.field_71476_x.field_72308_g instanceof EntityGunItem || mc.field_71476_x.field_72308_g instanceof EntityGrenade && ((EntityGrenade)mc.field_71476_x.field_72308_g).type.isDeployableBag)) {
            hold = false;
        }
        if (this.soundDelay <= 0 && this.type.idleSound != null) {
            PacketPlaySound.sendSoundPacket(player.field_70165_t, player.field_70163_u, player.field_70161_v, 50.0, player.field_71093_bK, this.type.idleSound, false);
            this.soundDelay = this.type.idleSoundLength;
        }
        if (this.gunCantBeHandeled(this.type, player).booleanValue()) {
            return;
        }
        if (this.type.usableByPlayers) {
            GunAnimations animations = FlansModClient.getGunAnimations((EntityLivingBase)player, hand);
            boolean needsToReload = this.needsToReload(gunstack);
            boolean shouldShootThisTick = false;
            switch (this.type.getFireMode(gunstack)) {
                case BURST: {
                    if (data.GetBurstRoundsRemaining(hand) > 0) {
                        shouldShootThisTick = true;
                    }
                }
                case SEMIAUTO: {
                    if (hold.booleanValue() && !held.booleanValue()) {
                        shouldShootThisTick = true;
                        break;
                    }
                    needsToReload = false;
                    break;
                }
                case MINIGUN: {
                    if (needsToReload) {
                        needsToReload = hold;
                        break;
                    }
                    if (hold.booleanValue()) {
                        if (data.minigunSpeed < this.type.minigunMaxSpeed) {
                            data.minigunSpeed += 2.0f;
                            animations.addMinigunBarrelRotationSpeed(Float.valueOf(2.0f));
                        }
                        if (data.minigunSpeed < this.type.minigunStartSpeed) {
                            if (!this.type.useLoopingSounds) break;
                            data.shouldPlayWarmupSound = true;
                            break;
                        }
                    }
                }
                case FULLAUTO: {
                    shouldShootThisTick = hold;
                    if (shouldShootThisTick) break;
                    needsToReload = false;
                    break;
                }
                default: {
                    needsToReload = false;
                }
            }
            if (needsToReload) {
                FlansMod.getPacketHandler().sendToServer(new PacketReload(hand, false));
            } else if (shouldShootThisTick) {
                this.shoot(hand, player, gunstack, data, world, animations);
            }
        }
    }

    public Boolean gunCantBeHandeled(GunType type, EntityPlayer player) {
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        Boolean hasItemInBothHands = !main.func_190926_b() && !off.func_190926_b();
        if (hasItemInBothHands.booleanValue() && !type.oneHanded) {
            return true;
        }
        return false;
    }

    public void shoot(EnumHand hand, EntityPlayer player, ItemStack gunstack, PlayerData data, World world, @Nullable GunAnimations animations) {
        if (this.type.usableByPlayers) {
            float shootTime;
            if (!world.field_72995_K && shootTime > 0.0f && shootTime < 4.0f) {
                for (shootTime = data.GetShootTime(hand); shootTime > 0.0f; shootTime -= 1.0f) {
                }
            }
            if (world.field_72995_K && shootTime <= 0.0f) {
                FlansMod.getPacketHandler().sendToServer(new PacketGunFire(hand));
            }
            while (shootTime <= 0.0f) {
                int bulletID;
                shootTime += this.type.GetShootDelay(gunstack);
                ItemStack bulletStack = ItemStack.field_190927_a.func_77946_l();
                for (bulletID = 0; bulletID < this.type.numAmmoItemsInGun; ++bulletID) {
                    ItemStack checkingStack = this.getBulletItemStack(gunstack, bulletID);
                    if (checkingStack == null || checkingStack.func_77952_i() >= checkingStack.func_77958_k()) continue;
                    bulletStack = checkingStack;
                    break;
                }
                if (bulletStack.func_190926_b()) continue;
                ItemStack bullet = bulletStack;
                Integer bulletid = bulletID;
                ItemShootable shootableItem = (ItemShootable)bulletStack.func_77973_b();
                ShootableType shootableType = shootableItem.type;
                Vector3f rayTraceOrigin = new Vector3f(player.func_174824_e(0.0f));
                ShootBulletHandler handler = isExtraBullet -> {
                    if (!isExtraBullet.booleanValue()) {
                        if (shootableType.dropItemOnShoot != null && !player.field_71075_bZ.field_75098_d) {
                            ItemGun.dropItem(world, (Entity)player, shootableType.dropItemOnShoot);
                        }
                        if (this.type.dropItemOnShoot != null) {
                            ItemGun.dropItem(world, (Entity)player, this.type.dropItemOnShoot);
                        }
                        if (this.type.knockback > 0.0f) {
                            // empty if block
                        }
                        bullet.func_77964_b(bullet.func_77952_i() + 1);
                        this.setBulletItemStack(gunstack, bullet, bulletid);
                        if (this.type.consumeGunUponUse) {
                            player.func_184611_a(hand, ItemStack.field_190927_a.func_77946_l());
                        }
                    }
                };
                if (world.field_72995_K) {
                    Integer bulletAmount = this.type.numBullets * shootableType.numBullets;
                    for (int i = 0; i < bulletAmount; ++i) {
                        handler.shooting(i < bulletAmount - 1);
                    }
                    animations.doShoot(this.type.getPumpDelay(), this.type.getPumpTime());
                    Float recoil = Float.valueOf(this.type.getRecoil(gunstack));
                    FlansModClient.playerRecoil += recoil.floatValue();
                    animations.recoil += recoil.floatValue();
                } else {
                    Vector3f rayTraceDirection = new Vector3f(player.func_70040_Z());
                    if (shootableType instanceof BulletType) {
                        FireableGun fireableGun = new FireableGun(this.type, this.type.getDamage(gunstack), this.type.getSpread(gunstack), this.type.bulletSpeed);
                        FiredShot shot = new FiredShot(fireableGun, (BulletType)shootableType, (EntityPlayerMP)player);
                        ShotHandler.fireGun(world, shot, this.type.numBullets * shootableType.numBullets, rayTraceOrigin, rayTraceDirection, handler);
                    } else if (shootableType instanceof GrenadeType) {
                        ItemGrenade grenade = (ItemGrenade)shootableItem;
                        grenade.throwGrenade(world, (EntityLivingBase)player);
                        handler.shooting(false);
                    }
                    boolean silenced = this.type.getBarrel(gunstack) != null && this.type.getBarrel((ItemStack)gunstack).silencer;
                    this.playShotSound(world, rayTraceOrigin, silenced);
                }
                int gunSlot = player.field_71071_by.field_70461_c;
                if (!this.type.consumeGunUponUse) continue;
                player.field_71071_by.func_70299_a(gunSlot, ItemStack.field_190927_a.func_77946_l());
            }
            data.SetShootTime(hand, shootTime);
        }
    }

    public void shootServer(EnumHand hand, EntityPlayerMP player, ItemStack gunstack) {
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player, Side.SERVER);
        WorldServer world = player.func_71121_q();
        if (this.type.deployable) {
            return;
        }
        if (this.gunCantBeHandeled(this.type, (EntityPlayer)player).booleanValue()) {
            return;
        }
        this.shoot(hand, (EntityPlayer)player, gunstack, data, (World)world, null);
        if (FlansMod.DEBUG) {
            Vector3f gunOrigin = FlansModRaytracer.GetPlayerMuzzlePosition((EntityPlayer)player, hand);
            world.func_72838_d((Entity)new EntityDebugDot((World)world, gunOrigin, 100, 1.0f, 1.0f, 1.0f));
        }
    }

    public void playShotSound(World world, Vector3f position, Boolean silenced) {
        if (this.soundDelay <= 0 && this.type.shootSound != null) {
            PacketPlaySound.sendSoundPacket(position.x, position.y, position.z, 50.0, world.field_73011_w.getDimension(), this.type.shootSound, silenced);
            this.soundDelay = this.type.idleSoundLength;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void PlayShotSound(World world, boolean silenced, float x, float y, float z) {
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(FlansModResourceHandler.getSoundEvent(this.type.shootSound), SoundCategory.PLAYERS, silenced ? 5.0f : 10.0f, (this.type.distortSound ? 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f) : 1.0f) * (silenced ? 2.0f : 1.0f), x, y, z));
    }

    public void onUpdateServer(ItemStack itemstack, int gunSlot, World world, Entity entity, EnumHand hand, boolean hasOffHand) {
        if (!(entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player);
        if (player.field_71071_by.func_70448_g() != itemstack) {
            if (player.field_71071_by.func_70448_g().func_190926_b() || !(player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemGun)) {
                data.isShootingLeft = false;
                data.isShootingRight = false;
            }
            return;
        }
        if (this.soundDelay > 0) {
            --this.soundDelay;
        }
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (entity instanceof EntityPlayer) {
            EnumHand hand;
            EntityPlayer player = (EntityPlayer)entity;
            if (itemstack == player.func_184614_ca()) {
                hand = EnumHand.MAIN_HAND;
            } else if (itemstack == player.func_184592_cb()) {
                hand = EnumHand.OFF_HAND;
            } else {
                return;
            }
            if (world.field_72995_K && Minecraft.func_71410_x().field_71462_r == null) {
                lastRightMouseHeld = rightMouseHeld;
                lastLeftMouseHeld = leftMouseHeld;
                rightMouseHeld = Mouse.isButtonDown((int)1);
                leftMouseHeld = Mouse.isButtonDown((int)0);
            }
            ItemStack main = player.func_184614_ca();
            ItemStack off = player.func_184592_cb();
            boolean hasOffHand = !main.func_190926_b() && !off.func_190926_b();
            this.onUpdateEach(itemstack, i, world, entity, hand, hasOffHand);
        }
    }

    private void onUpdateEach(ItemStack itemstack, int gunSlot, World world, Entity entity, EnumHand hand, boolean hasOffHand) {
        if (world.field_72995_K) {
            this.onUpdateClient(itemstack, gunSlot, world, entity, hand, hasOffHand);
        } else {
            this.onUpdateServer(itemstack, gunSlot, world, entity, hand, hasOffHand);
        }
    }

    public boolean Reload(ItemStack gunstack, World world, Entity entity, IInventory inventory, EnumHand hand, boolean hasOffHand, boolean forceReload, boolean isCreative) {
        if (this.type.deployable) {
            return false;
        }
        if (forceReload && !this.type.canForceReload) {
            return false;
        }
        boolean reloadedSomething = false;
        for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
            ItemStack bulletStack = this.getBulletItemStack(gunstack, i);
            if (bulletStack != null && !bulletStack.func_190926_b() && bulletStack.func_77952_i() != bulletStack.func_77958_k() && !forceReload) continue;
            int bestSlot = -1;
            int bulletsInBestSlot = 0;
            for (int j = 0; j < inventory.func_70302_i_(); ++j) {
                int bulletsInThisSlot;
                ItemStack item = inventory.func_70301_a(j);
                if (!(item.func_77973_b() instanceof ItemShootable) || !this.type.isCorrectAmmo(((ItemShootable)item.func_77973_b()).type) || (bulletsInThisSlot = item.func_77958_k() - item.func_77952_i()) <= bulletsInBestSlot) continue;
                bestSlot = j;
                bulletsInBestSlot = bulletsInThisSlot;
            }
            if (bestSlot == -1) continue;
            ItemStack newBulletStack = inventory.func_70301_a(bestSlot);
            ShootableType newBulletType = ((ItemShootable)newBulletStack.func_77973_b()).type;
            if (bulletStack != null && bulletStack.func_77973_b() instanceof ItemShootable && ((ItemShootable)bulletStack.func_77973_b()).type.dropItemOnReload != null && !isCreative && bulletStack.func_77952_i() == bulletStack.func_77958_k() && !world.field_72995_K) {
                ItemGun.dropItem(world, entity, ((ItemShootable)bulletStack.func_77973_b()).type.dropItemOnReload);
            }
            if (!(bulletStack == null || bulletStack.func_190926_b() || bulletStack.func_77952_i() >= bulletStack.func_77958_k() || InventoryHelper.addItemStackToInventory(inventory, bulletStack, isCreative) || world.field_72995_K)) {
                entity.func_70099_a(bulletStack, 0.5f);
            }
            ItemStack stackToLoad = newBulletStack.func_77946_l();
            stackToLoad.func_190920_e(1);
            this.setBulletItemStack(gunstack, stackToLoad, i);
            if (!isCreative) {
                newBulletStack.func_190920_e(newBulletStack.func_190916_E() - 1);
            }
            if (newBulletStack.func_190916_E() <= 0) {
                newBulletStack = ItemStack.field_190927_a.func_77946_l();
            }
            inventory.func_70299_a(bestSlot, newBulletStack);
            reloadedSomething = true;
        }
        return reloadedSomething;
    }

    private boolean needsToReload(ItemStack stack) {
        for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
            ItemStack bulletStack = this.getBulletItemStack(stack, i);
            if (bulletStack == null || bulletStack.func_190926_b() || bulletStack.func_77952_i() >= bulletStack.func_77958_k()) continue;
            return false;
        }
        return true;
    }

    public boolean CanReload(ItemStack gunstack, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!this.type.isCorrectAmmo(stack)) continue;
            return true;
        }
        return false;
    }

    private ItemStack getBestNonEmptyShootableStack(ItemStack stack) {
        for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
            ItemStack shootableStack = this.getBulletItemStack(stack, i);
            if (shootableStack == null || shootableStack.func_190926_b() || shootableStack.func_77952_i() >= shootableStack.func_77958_k()) continue;
            return shootableStack;
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> lines, ITooltipFlag b) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("LegendaryCrafter")) {
            String crafter = stack.func_77978_p().func_74779_i("LegendaryCrafter");
            lines.add("Legendary Skin Crafted by " + (String)crafter);
        }
        if (this.type.description != null) {
            Collections.addAll(lines, this.type.description.split("_"));
        }
        if (this.type.showDamage) {
            lines.add("\u00a79Damage\u00a77: " + this.type.getDamage(stack));
        }
        if (this.type.showRecoil) {
            lines.add("\u00a79Recoil\u00a77: " + this.type.getRecoil(stack));
        }
        if (this.type.showSpread) {
            lines.add("\u00a79Accuracy\u00a77: " + this.type.getSpread(stack));
        }
        if (this.type.showReloadTime) {
            lines.add("\u00a79Reload Time\u00a77: " + this.type.getReloadTime(stack) / 20.0f + "s");
        }
        for (AttachmentType attachment : this.type.getCurrentAttachments(stack)) {
            if (!this.type.showAttachments) continue;
            String line = attachment.name;
            lines.add(line);
        }
        for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
            ItemStack bulletStack = this.getBulletItemStack(stack, i);
            if (bulletStack == null || !(bulletStack.func_77973_b() instanceof ItemBullet)) continue;
            BulletType bulletType = ((ItemBullet)bulletStack.func_77973_b()).type;
            String line = bulletType.name + " " + (bulletStack.func_77958_k() - bulletStack.func_77952_i()) + "/" + bulletStack.func_77958_k();
            lines.add(line);
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    public DamageSource getMeleeDamage(EntityPlayer attacker) {
        return new EntityDamageSourceFlan(this.type.shortName, (Entity)attacker, attacker, this.type);
    }

    private boolean isSolid(World world, int i, int j, int k) {
        IBlockState state = world.func_180495_p(new BlockPos(i, j, k));
        return state.func_185904_a().func_76220_a() && state.func_185914_p();
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return this.type.secondaryFunction != EnumSecondaryFunction.MELEE;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityItemCustomRender(location, itemstack);
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (this.type.meleeSound != null) {
            PacketPlaySound.sendSoundPacket(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 50.0, entityLiving.field_71093_bK, this.type.meleeSound, true);
        }
        if (this.type.secondaryFunction == EnumSecondaryFunction.CUSTOM_MELEE) {
            if (entityLiving.field_70170_p.field_72995_K) {
                GunAnimations animations = FlansModClient.getGunAnimations(entityLiving, EnumHand.MAIN_HAND);
                animations.doMelee(this.type.meleeTime);
            }
            if (entityLiving instanceof EntityPlayer) {
                PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)entityLiving);
                data.doMelee((EntityPlayer)entityLiving, this.type.meleeTime, this.type);
            }
        }
        return this.type.secondaryFunction != EnumSecondaryFunction.MELEE;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
        }
        return true;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return false;
    }

    public boolean isItemStackDamageable() {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab != FlansMod.tabFlanGuns && tab != CreativeTabs.field_78027_g) {
            return;
        }
        PaintableType type = this.GetPaintableType();
        if (FlansMod.addAllPaintjobsToCreative) {
            for (Paintjob paintjob : type.paintjobs) {
                this.addPaintjobToList(this, type, paintjob, (List<ItemStack>)items);
            }
        } else {
            this.addPaintjobToList(this, type, type.defaultPaintjob, (List<ItemStack>)items);
        }
    }

    private void addPaintjobToList(Item item, PaintableType type, Paintjob paintjob, List<ItemStack> list) {
        ItemStack paintableStack = new ItemStack(item, 1, paintjob.ID);
        NBTTagCompound tags = new NBTTagCompound();
        paintableStack.func_77982_d(tags);
        list.add(paintableStack);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 100;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(KNOCKBACK_RESIST_MODIFIER, "KnockbackResist", (double)this.type.knockbackModifier, 0));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(MOVEMENT_SPEED_MODIFIER, "MovementSpeed", (double)(this.type.moveSpeedModifier - 1.0f), 2));
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.type.meleeDamage, 0));
        }
        return multimap;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public boolean func_82788_x() {
        return false;
    }

    static {
        KNOCKBACK_RESIST_MODIFIER = UUID.fromString("77777777-645C-4F38-A497-9C13A33DB5CF");
        MOVEMENT_SPEED_MODIFIER = UUID.fromString("99999999-4180-4865-B01B-BCCE9785ACA3");
    }
}

