/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.client.model.InstantBulletRenderer;
import com.flansmod.common.FlansMod;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketBulletTrail
extends PacketBase {
    private Vector3f origin;
    private Vector3f hitPos;
    private Float width;
    private Float length;
    private Float bulletSpeed;
    private String trailTexture;

    public PacketBulletTrail() {
    }

    public PacketBulletTrail(Vector3f origin, Vector3f hitPos, Float width, Float length, Float bulletSpeed, String trailTexture) {
        this.origin = origin;
        this.hitPos = hitPos;
        this.width = width;
        this.length = length;
        this.bulletSpeed = bulletSpeed;
        this.trailTexture = trailTexture;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeFloat(this.origin.x);
        data.writeFloat(this.origin.y);
        data.writeFloat(this.origin.z);
        data.writeFloat(this.hitPos.x);
        data.writeFloat(this.hitPos.y);
        data.writeFloat(this.hitPos.z);
        data.writeFloat(this.width.floatValue());
        data.writeFloat(this.length.floatValue());
        data.writeFloat(this.bulletSpeed.floatValue());
        PacketBulletTrail.writeUTF(data, this.trailTexture);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.origin = new Vector3f(data.readFloat(), data.readFloat(), data.readFloat());
        this.hitPos = new Vector3f(data.readFloat(), data.readFloat(), data.readFloat());
        this.width = Float.valueOf(data.readFloat());
        this.length = Float.valueOf(data.readFloat());
        this.bulletSpeed = Float.valueOf(data.readFloat());
        this.trailTexture = PacketBulletTrail.readUTF(data);
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        FlansMod.log.warn("Received PacketBulletTrail on Server. This packet should only be send to clients");
    }

    @Override
    public void handleClientSide(EntityPlayer clientPlayer) {
        InstantBulletRenderer.AddTrail(new InstantBulletRenderer.InstantShotTrail(this.origin, this.hitPos, this.width.floatValue(), this.length.floatValue(), this.bulletSpeed.floatValue(), this.trailTexture));
    }
}

