/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketDriveableDamage
extends PacketBase {
    public int entityId;
    public short[] health;
    public boolean[] onFire;

    public PacketDriveableDamage() {
        this.health = new short[EnumDriveablePart.values().length];
        this.onFire = new boolean[EnumDriveablePart.values().length];
    }

    public PacketDriveableDamage(EntityDriveable driveable) {
        this.entityId = driveable.func_145782_y();
        this.health = new short[EnumDriveablePart.values().length];
        this.onFire = new boolean[EnumDriveablePart.values().length];
        for (int i = 0; i < EnumDriveablePart.values().length; ++i) {
            EnumDriveablePart ep = EnumDriveablePart.values()[i];
            DriveablePart part = driveable.getDriveableData().parts.get((Object)ep);
            this.health[i] = (short)part.health;
            this.onFire[i] = part.onFire;
        }
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.entityId);
        for (int i = 0; i < EnumDriveablePart.values().length; ++i) {
            data.writeShort((int)this.health[i]);
            data.writeBoolean(this.onFire[i]);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.entityId = data.readInt();
        for (int i = 0; i < EnumDriveablePart.values().length; ++i) {
            this.health[i] = data.readShort();
            this.onFire[i] = data.readBoolean();
        }
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        FlansMod.log.warn("Driveable damage packet received on server. Skipping.");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        EntityDriveable driveable = null;
        for (Object obj : clientPlayer.field_70170_p.field_72996_f) {
            if (!(obj instanceof EntityDriveable) || ((Entity)obj).func_145782_y() != this.entityId) continue;
            driveable = (EntityDriveable)obj;
            break;
        }
        if (driveable != null) {
            for (int i = 0; i < EnumDriveablePart.values().length; ++i) {
                EnumDriveablePart ep = EnumDriveablePart.values()[i];
                DriveablePart part = driveable.getDriveableData().parts.get((Object)ep);
                part.health = this.health[i];
                part.onFire = this.onFire[i];
            }
        }
    }
}

