/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.teams.Gametype;
import com.flansmod.common.teams.LoadoutPool;
import com.flansmod.common.teams.PlayerRankData;
import com.flansmod.common.teams.RewardBox;
import com.flansmod.common.teams.RewardBoxInstance;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.teams.TeamsManagerRanked;
import com.flansmod.common.teams.TeamsMap;
import com.flansmod.common.teams.TeamsRound;
import com.mojang.authlib.GameProfile;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandTeams
extends CommandBase {
    public static TeamsManager teamsManager = TeamsManager.getInstance();

    public String func_71517_b() {
        return "teams";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] split) throws CommandException {
        if (teamsManager == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Teams mod is broken. You will need to look at the server side logs to see what's wrong"));
            return;
        }
        if (split == null || split.length == 0 || split[0].equals("help") || split[0].equals("?")) {
            if (split.length == 2) {
                this.sendHelpInformation(sender, Integer.parseInt(split[1]));
            } else {
                this.sendHelpInformation(sender, 1);
            }
            return;
        }
        if (split[0].equals("off")) {
            CommandTeams.teamsManager.currentRound = null;
            TeamsManager.enabled = false;
            TeamsManager.messageAll("Flan's Teams Mod disabled");
            return;
        }
        if (split[0].equals("on")) {
            TeamsManager.enabled = true;
            TeamsManager.messageAll("Flan's Teams Mod enabled");
            return;
        }
        if (!TeamsManager.enabled) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Teams mod is disabled. Try /teams on"));
            return;
        }
        if (split[0].equals("survival")) {
            TeamsManager.explosions = true;
            TeamsManager.driveablesBreakBlocks = true;
            TeamsManager.bombsEnabled = true;
            TeamsManager.bulletsEnabled = true;
            TeamsManager.forceAdventureMode = false;
            TeamsManager.overrideHunger = false;
            TeamsManager.canBreakGuns = true;
            TeamsManager.canBreakGlass = true;
            TeamsManager.armourDrops = true;
            TeamsManager.weaponDrops = 1;
            TeamsManager.vehiclesNeedFuel = true;
            TeamsManager.mechaLove = 0;
            TeamsManager.aaLife = 0;
            TeamsManager.vehicleLife = 0;
            TeamsManager.planeLife = 0;
            TeamsManager.mgLife = 0;
            TeamsManager.messageAll("Flan's Mod switching to survival presets");
            return;
        }
        if (split[0].equals("arena")) {
            TeamsManager.explosions = false;
            TeamsManager.driveablesBreakBlocks = false;
            TeamsManager.bombsEnabled = true;
            TeamsManager.bulletsEnabled = true;
            TeamsManager.forceAdventureMode = true;
            TeamsManager.overrideHunger = true;
            TeamsManager.canBreakGuns = true;
            TeamsManager.canBreakGlass = false;
            TeamsManager.armourDrops = false;
            TeamsManager.weaponDrops = 2;
            TeamsManager.vehiclesNeedFuel = false;
            TeamsManager.mechaLove = 120;
            TeamsManager.aaLife = 120;
            TeamsManager.vehicleLife = 120;
            TeamsManager.planeLife = 120;
            TeamsManager.mgLife = 120;
            TeamsManager.messageAll("Flan's Mod switching to arena mode presets");
            return;
        }
        if (split[0].equals("motd")) {
            CommandTeams.teamsManager.motd = "";
            for (int i = 0; i < split.length - 1; ++i) {
                CommandTeams.teamsManager.motd = CommandTeams.teamsManager.motd + split[i + 1];
                if (i == split.length - 2) continue;
                CommandTeams.teamsManager.motd = CommandTeams.teamsManager.motd + " ";
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Server message of the day is now:"));
            sender.func_145747_a((ITextComponent)new TextComponentString(CommandTeams.teamsManager.motd));
            return;
        }
        if (split[0].equals("listGametypes")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a72Showing all avaliable gametypes"));
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a72To pick a gametype, use \"/teams setGametype <gametype>\" with the name in brackets"));
            for (Gametype gametype : Gametype.gametypes.values()) {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7f" + gametype.name + " (" + gametype.shortName + ")"));
            }
            return;
        }
        if (split[0].equals("listMaps")) {
            if (CommandTeams.teamsManager.maps == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("The map list is null"));
                return;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a72Listing maps"));
            for (TeamsMap map : CommandTeams.teamsManager.maps.values()) {
                sender.func_145747_a((ITextComponent)new TextComponentString((CommandTeams.teamsManager.currentRound != null && map == CommandTeams.teamsManager.currentRound.map ? "\u00a74" : "") + map.name + " (" + map.shortName + ")"));
            }
            return;
        }
        if (split[0].equals("addMap")) {
            if (split.length < 3) {
                sender.func_145747_a((ITextComponent)new TextComponentString("You need to specify a map name"));
                return;
            }
            String shortName = split[1];
            String name = split[2];
            for (int i = 3; i < split.length; ++i) {
                name = name + " " + split[i];
            }
            CommandTeams.teamsManager.maps.put(shortName, new TeamsMap(sender.func_130014_f_(), shortName, name));
            sender.func_145747_a((ITextComponent)new TextComponentString("Added new map : " + name + " (" + shortName + ")"));
            return;
        }
        if (split[0].equals("removeMap")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("You need to specify a map's short name"));
                return;
            }
            if (CommandTeams.teamsManager.maps.containsKey(split[1])) {
                CommandTeams.teamsManager.maps.remove(split[1]);
                sender.func_145747_a((ITextComponent)new TextComponentString("Removed map " + split[1]));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Map (" + split[1] + ") not found"));
            }
            return;
        }
        if (split[0].equals("setRound")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("You need to specify the round index (see /teams listRounds)"));
                return;
            }
            TeamsRound round = CommandTeams.teamsManager.rounds.get(Integer.parseInt(split[1]));
            if (round != null) {
                CommandTeams.teamsManager.nextRound = round;
                TeamsManager.messageAll("\u00a72Next round will be " + round.gametype.shortName + " in " + round.map.name);
            }
            return;
        }
        if (split[0].equals("listTeams") || split[0].equals("listAllTeams")) {
            if (Team.teams.isEmpty()) {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a74No teams available. You need a content pack that has some teams with it"));
                return;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a72Showing all avaliable teams"));
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a72To pick these teams, use /teams setTeams <team1> <team2> with the names in brackets"));
            for (Team team : Team.teams) {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7" + team.textColour + team.name + " (" + team.shortName + ")"));
            }
            return;
        }
        if (split[0].equals("getSticks") || split[0].equals("getOpSticks") || split[0].equals("getOpKit")) {
            EntityPlayerMP player = this.getPlayer(sender.func_70005_c_());
            if (player != null) {
                player.field_71071_by.func_70441_a(new ItemStack((Item)FlansMod.opStick, 1, 0));
                player.field_71071_by.func_70441_a(new ItemStack((Item)FlansMod.opStick, 1, 1));
                player.field_71071_by.func_70441_a(new ItemStack((Item)FlansMod.opStick, 1, 2));
                player.field_71071_by.func_70441_a(new ItemStack((Item)FlansMod.opStick, 1, 3));
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a72Enjoy your op sticks."));
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a77The Stick of Connecting connects objects (spawners, banners etc) to bases (flagpoles etc)"));
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a77The Stick of Ownership sets the team that currently owns a base"));
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a77The Stick of Mapping sets the map that a base is currently associated with"));
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a77The Stick of Destruction deletes bases and team objects"));
            }
            return;
        }
        if (split[0].toLowerCase().equals("autobalance")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.autoBalance = Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Autobalance is now " + (TeamsManager.autoBalance ? "enabled" : "disabled")));
            return;
        }
        if (split[0].equals("useRotation")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.voting = !Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Voting is now " + (TeamsManager.voting ? "enabled" : "disabled")));
            return;
        }
        if (split[0].equals("voting")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.voting = Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Voting is now " + (TeamsManager.voting ? "enabled" : "disabled")));
            return;
        }
        if (split[0].equals("listRounds") || split[0].equals("listRotation")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a72Current Round List"));
            for (int i = 0; i < TeamsManager.getInstance().rounds.size(); ++i) {
                TeamsRound entry = TeamsManager.getInstance().rounds.get(i);
                if (entry.map == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Round had null map"));
                    return;
                }
                if (entry.gametype == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Round had null gametype"));
                    return;
                }
                String s = i + ". " + entry.map.shortName + ", " + entry.gametype.shortName;
                if (entry == TeamsManager.getInstance().currentRound) {
                    s = "\u00a74" + s;
                }
                for (int j = 0; j < entry.teams.length; ++j) {
                    s = s + ", " + entry.teams[j].shortName;
                }
                s = s + ", " + entry.timeLimit;
                s = s + ", " + entry.scoreLimit;
                s = s + ", Pop : " + (int)(entry.popularity * 100.0f) + "%";
                sender.func_145747_a((ITextComponent)new TextComponentString(s));
            }
            return;
        }
        if (split[0].equals("removeRound") || split[0].equals("removeMapFromRotation") || split[0].equals("removeFromRotation") || split[0].equals("removeRotation")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <ID>"));
                return;
            }
            int map = Integer.parseInt(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Removed map " + map + " (" + TeamsManager.getInstance().rounds.get((int)map).map.shortName + ") from rotation"));
            TeamsManager.getInstance().rounds.remove(map);
            return;
        }
        if (split[0].equals("addMapToRotation") || split[0].equals("addToRotation") || split[0].equals("addRotation") || split[0].equals("addRound")) {
            if (split.length < 7) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <Map> <Gametype> <Team1> <Team2> ... <TimeLimit> <ScoreLimit>"));
                return;
            }
            TeamsMap map = TeamsManager.getInstance().maps.get(split[1]);
            if (map == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Could not find map : " + split[1]));
                return;
            }
            Gametype gametype = Gametype.getGametype(split[2]);
            if (gametype == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Could not find gametype : " + split[2]));
                return;
            }
            if (split.length != 5 + gametype.numTeamsRequired) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <Map> <Gametype> <Team1> <Team2> ... <ScoreLimit> <TimeLimit>"));
                return;
            }
            Team[] teams = new Team[gametype.numTeamsRequired];
            for (int i = 0; i < teams.length; ++i) {
                teams[i] = Team.getTeam(split[3 + i]);
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Added map (" + map.shortName + ") to rotation"));
            TeamsManager.getInstance().rounds.add(new TeamsRound(map, gametype, teams, Integer.parseInt(split[3 + gametype.numTeamsRequired]), Integer.parseInt(split[4 + gametype.numTeamsRequired])));
            return;
        }
        if (split[0].equals("start") || split[0].equals("begin")) {
            teamsManager.start();
            sender.func_145747_a((ITextComponent)new TextComponentString("Started teams map rotation"));
            return;
        }
        if (split[0].equals("nextMap") || split[0].equals("next") || split[0].equals("nextRound")) {
            CommandTeams.teamsManager.roundTimeLeft = 1;
            return;
        }
        if (split[0].equals("forceAdventure") || split[0].equals("forceAdventureMode")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.forceAdventureMode = Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Adventure mode will " + (TeamsManager.forceAdventureMode ? "now" : "no longer") + " be forced"));
            return;
        }
        if (split[0].equals("overrideHunger") || split[0].equals("noHunger")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.overrideHunger = Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Players will " + (TeamsManager.overrideHunger ? "no longer" : "now") + " get hungry during rounds"));
            return;
        }
        if (split[0].equals("explosions")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.explosions = Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Expolsions are now " + (TeamsManager.explosions ? "enabled" : "disabled")));
            return;
        }
        if (split[0].equals("bombs") || split[0].equals("allowBombs")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.bombsEnabled = Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Bombs are now " + (TeamsManager.bombsEnabled ? "enabled" : "disabled")));
            return;
        }
        if (split[0].equals("bullets") || split[0].equals("bulletsEnabled")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.bulletsEnabled = Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Bullets are now " + (TeamsManager.bulletsEnabled ? "enabled" : "disabled")));
            return;
        }
        if (split[0].equals("canBreakGuns")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.canBreakGuns = Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("AAGuns and MGs can " + (TeamsManager.canBreakGuns ? "now" : "no longer") + " be broken"));
            return;
        }
        if (split[0].equals("canBreakGlass")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.canBreakGlass = Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Glass and glowstone can " + (TeamsManager.canBreakGlass ? "now" : "no longer") + " be broken"));
            return;
        }
        if (split[0].equals("armourDrops") || split[0].equals("armorDrops")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.armourDrops = Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Armour will " + (TeamsManager.armourDrops ? "now" : "no longer") + " be dropped"));
            return;
        }
        if (split[0].equals("weaponDrops")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <on/off/smart>"));
                return;
            }
            if (split[1].toLowerCase().equals("on")) {
                TeamsManager.weaponDrops = 1;
                sender.func_145747_a((ITextComponent)new TextComponentString("Weapons will be dropped normally"));
            } else if (split[1].toLowerCase().equals("off")) {
                TeamsManager.weaponDrops = 0;
                sender.func_145747_a((ITextComponent)new TextComponentString("Weapons will be not be dropped"));
            } else if (split[1].toLowerCase().equals("smart")) {
                TeamsManager.weaponDrops = 2;
                sender.func_145747_a((ITextComponent)new TextComponentString("Smart drops enabled"));
            }
            return;
        }
        if (split[0].equals("fuelNeeded")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.vehiclesNeedFuel = Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Vehicles will " + (TeamsManager.vehiclesNeedFuel ? "now" : "no longer") + " require fuel"));
            return;
        }
        if (split[0].equals("mgLife")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <time>"));
                return;
            }
            TeamsManager.mgLife = Integer.parseInt(split[1]);
            if (TeamsManager.mgLife > 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString("MGs will despawn after " + TeamsManager.mgLife + " seconds"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("MGs will not despawn"));
            }
            return;
        }
        if (split[0].equals("planeLife")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <time>"));
                return;
            }
            TeamsManager.planeLife = Integer.parseInt(split[1]);
            if (TeamsManager.planeLife > 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Planes will despawn after " + TeamsManager.planeLife + " seconds"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Planes will not despawn"));
            }
            return;
        }
        if (split[0].equals("vehicleLife")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <time>"));
                return;
            }
            TeamsManager.vehicleLife = Integer.parseInt(split[1]);
            if (TeamsManager.vehicleLife > 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Vehicles will despawn after " + TeamsManager.vehicleLife + " seconds"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Vehicles will not despawn"));
            }
            return;
        }
        if (split[0].equals("mechaLife")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <time>"));
                return;
            }
            TeamsManager.mechaLove = Integer.parseInt(split[1]);
            if (TeamsManager.mechaLove > 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Mechas will despawn after " + TeamsManager.mechaLove + " seconds"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Mechas will not despawn"));
            }
            return;
        }
        if (split[0].equals("aaLife")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <time>"));
                return;
            }
            TeamsManager.aaLife = Integer.parseInt(split[1]);
            if (TeamsManager.aaLife > 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString("AA Guns will despawn after " + TeamsManager.aaLife + " seconds"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("AA Guns will not despawn"));
            }
            return;
        }
        if (split[0].equals("vehiclesBreakBlocks")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <true/false>"));
                return;
            }
            TeamsManager.driveablesBreakBlocks = Boolean.parseBoolean(split[1]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Vehicles will " + (TeamsManager.driveablesBreakBlocks ? "now" : "no longer") + " break blocks"));
            return;
        }
        if (split[0].equals("scoreDisplayTime")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <time>"));
                return;
            }
            TeamsManager.scoreDisplayTime = Integer.parseInt(split[1]) * 20;
            sender.func_145747_a((ITextComponent)new TextComponentString("Score summary menu will appear for " + TeamsManager.scoreDisplayTime / 20 + " seconds"));
            return;
        }
        if (split[0].equals("rankUpdateTime")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <time>"));
                return;
            }
            TeamsManager.rankUpdateTime = Integer.parseInt(split[1]) * 20;
            sender.func_145747_a((ITextComponent)new TextComponentString("Rank update menu will appear for " + TeamsManager.rankUpdateTime / 20 + " seconds"));
            return;
        }
        if (split[0].equals("votingTime")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <time>"));
                return;
            }
            TeamsManager.votingTime = Integer.parseInt(split[1]) * 20;
            sender.func_145747_a((ITextComponent)new TextComponentString("Voting menu will appear for " + TeamsManager.votingTime / 20 + " seconds"));
            return;
        }
        if (split[0].toLowerCase().equals("autobalancetime")) {
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams " + split[0] + " <time>"));
                return;
            }
            TeamsManager.autoBalanceInterval = Integer.parseInt(split[1]) * 20;
            sender.func_145747_a((ITextComponent)new TextComponentString("Autobalance will now occur every " + TeamsManager.autoBalanceInterval / 20 + " seconds"));
            return;
        }
        if (split[0].equals("setVariable")) {
            if (TeamsManager.getInstance().currentRound == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("There is no gametype to set variables for"));
                return;
            }
            if (split.length != 3) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Incorrect Usage : Should be /teams setVariable <variable> <value>"));
                return;
            }
            if (TeamsManager.getInstance().currentRound.gametype.setVariable(split[1], split[2])) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Set variable " + split[1] + " in gametype " + TeamsManager.getInstance().currentRound.gametype.shortName + " to " + split[2]));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Variable " + split[1] + " did not exist in gametype " + TeamsManager.getInstance().currentRound.gametype.shortName));
            }
            return;
        }
        if (split[0].toLowerCase().equals("setloadoutpool")) {
            LoadoutPool pool = LoadoutPool.GetPool(split[1]);
            if (pool != null) {
                TeamsManagerRanked.GetInstance().currentPool = pool;
                sender.func_145747_a((ITextComponent)new TextComponentString("Loadout pool set to " + split[1]));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("No such loadout pool"));
            }
            return;
        }
        if (split[0].toLowerCase().equals("go")) {
            TeamsManagerRanked.GetInstance().currentPool = LoadoutPool.GetPool("modernLoadout");
            teamsManager.start();
            return;
        }
        if (split[0].toLowerCase().equals("xp")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Awarded " + Integer.parseInt(split[1]) + " XP"));
            TeamsManagerRanked.AwardXP((EntityPlayerMP)sender, Integer.parseInt(split[1]));
            return;
        }
        if (split[0].toLowerCase().equals("resetrank")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reset your rank"));
            TeamsManagerRanked.ResetRank((EntityPlayerMP)sender);
            return;
        }
        if (split[0].toLowerCase().equals("giverewardbox")) {
            String name = split[1];
            RewardBox box = RewardBox.GetRewardBox(split[2]);
            if (box == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid box"));
                return;
            }
            GameProfile profile = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(name);
            if (profile != null) {
                RewardBoxInstance instance = RewardBoxInstance.CreateCheatReward(box, name);
                PlayerRankData data = TeamsManagerRanked.GetRankData(profile.getId());
                if (data != null) {
                    data.AddRewardBoxInstance(instance);
                }
            }
            return;
        }
        if (split[0].toLowerCase().equals("xpmultiplier")) {
            float target = Float.parseFloat(split[1]);
            if (target < 0.5f || target > 2.0f) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Not going to allow that for now. Keep it within 0.5 to 2.0"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("XP multiplier is now " + target));
                TeamsManagerRanked.GetInstance().XPMultiplier = target;
            }
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(split[0] + " is not a valid teams command. Try /teams help"));
    }

    public void sendHelpInformation(ICommandSender sender, int page) {
        if (page > 3 || page < 1) {
            TextComponentString text = new TextComponentString("Invalid help page, should be in the range (1-3)");
            text.func_150256_b().func_150238_a(TextFormatting.RED);
            sender.func_145747_a((ITextComponent)text);
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a72Listing teams commands \u00a7f[Page " + page + " of 3]"));
        switch (page) {
            case 1: {
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams help [page]"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams off"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams arena"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams survival"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams getSticks"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams listGametypes"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams listTeams"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams addMap <shortName> <longName>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams listMaps"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams removeMap <shortName>"));
                break;
            }
            case 2: {
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams useRotation <true / false>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams voting <true / false>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams addRound <map> <gametype> <team1> <team2> <TimeLimit> <ScoreLimit>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams listRounds"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams removeRound <ID>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams nextMap"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams votingTime <time>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams scoreDisplayTime <time>"));
                break;
            }
            case 3: {
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams setVariable <variable> <value>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams forceAdventure <true / false>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams overrideHunger <true / false>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams explosions <true / false>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams canBreakGuns <true / false>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams canBreakGlass <true / false>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams armourDrops <true / false>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams weaponDrops <off / on / smart>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams fuelNeeded <true / false>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams mgLife <time>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams planeLife <time>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams vehicleLife <time>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams aaLife <time>"));
                sender.func_145747_a((ITextComponent)new TextComponentString("/teams vehiclesBreakBlocks <true / false>"));
            }
        }
    }

    public EntityPlayerMP getPlayer(String name) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(name);
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "Try \"/teams help\"";
    }
}

