/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.teams.PlayerRankData;
import com.flansmod.common.types.EnumPaintjobRarity;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.PaintableType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import java.util.HashMap;

public class RewardBox
extends InfoType {
    public ArrayList<Paintjob> paintjobs = new ArrayList();
    public float[] weightPerRarity = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private static HashMap<Integer, RewardBox> boxes = new HashMap();

    public RewardBox(TypeFile file) {
        super(file);
    }

    @Override
    protected void postRead(TypeFile file) {
        boxes.put(this.hashCode(), this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        if (this.KeyMatches(split, "AddPaintjob")) {
            PaintableType type = PaintableType.GetPaintableType(split[2].hashCode());
            if (type == null) {
                FlansMod.Assert(false, "Invalid type: " + split[2] + " when reading " + this.shortName);
                return;
            }
            Paintjob paintjob = type.getPaintjob(split[3]);
            if (paintjob == null) {
                FlansMod.Assert(false, "Invalid paintjob: " + split[3] + " when reading " + this.shortName);
                return;
            }
            paintjob.rarity = this.GetRarity(split[1]);
            this.paintjobs.add(paintjob);
        } else if (this.KeyMatches(split, "RarityWeight")) {
            float weight;
            EnumPaintjobRarity rarity = this.GetRarity(split[1]);
            this.weightPerRarity[rarity.ordinal()] = weight = Float.parseFloat(split[2]);
        }
    }

    private EnumPaintjobRarity GetRarity(String split) {
        if (split.toLowerCase().equals("common")) {
            return EnumPaintjobRarity.COMMON;
        }
        if (split.toLowerCase().equals("uncommon")) {
            return EnumPaintjobRarity.UNCOMMON;
        }
        if (split.toLowerCase().equals("rare")) {
            return EnumPaintjobRarity.RARE;
        }
        if (split.toLowerCase().equals("legendary")) {
            return EnumPaintjobRarity.LEGENDARY;
        }
        FlansMod.Assert(false, "Unknown rarity entered for reward box");
        return EnumPaintjobRarity.UNKNOWN;
    }

    public int GetReward(PlayerRankData data) {
        float totalWeight = 0.0f;
        for (Paintjob paintjob1 : this.paintjobs) {
            totalWeight += this.weightPerRarity[paintjob1.rarity.ordinal()];
        }
        float pick = FlansMod.Pick(totalWeight);
        for (Paintjob paintjob : this.paintjobs) {
            if (!((pick -= this.weightPerRarity[paintjob.rarity.ordinal()]) <= 0.0f)) continue;
            return paintjob.hashCode();
        }
        FlansMod.Assert(false, "How did we not pick something?");
        return 0;
    }

    public static RewardBox GetRewardBox(int boxHash) {
        return boxes.get(boxHash);
    }

    public static RewardBox GetRewardBox(String string) {
        return RewardBox.GetRewardBox(string.hashCode());
    }
}

