/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.network.PacketBase;
import com.flansmod.common.teams.TeamsRound;
import io.netty.buffer.ByteBuf;

public class RoundFinishedData {
    public int scoresTime = 0;
    public int rankUpdateTime = 0;
    public int votingTime = 0;
    public boolean votingEnabled = false;
    public VotingOption[] votingOptions = new VotingOption[0];
    public int pendingXP = 0;
    public int resultantXP = 0;
    public int resultantLevel = 0;

    public RoundFinishedData() {
    }

    public RoundFinishedData(RoundFinishedData other) {
        this.scoresTime = other.scoresTime;
        this.rankUpdateTime = other.rankUpdateTime;
        this.votingTime = other.votingTime;
        this.votingEnabled = other.votingEnabled;
        this.votingOptions = other.votingOptions;
    }

    public void ReadInitialData(ByteBuf data) {
        this.scoresTime = data.readInt();
        this.rankUpdateTime = data.readInt();
        this.votingTime = data.readInt();
        this.votingEnabled = data.readBoolean();
        if (this.votingEnabled) {
            int numOptions = data.readByte();
            this.votingOptions = new VotingOption[numOptions];
            for (int i = 0; i < numOptions; ++i) {
                this.votingOptions[i] = new VotingOption(PacketBase.readUTF(data), PacketBase.readUTF(data), PacketBase.readUTF(data), PacketBase.readUTF(data));
            }
        }
        this.pendingXP = data.readInt();
        this.resultantXP = data.readInt();
        this.resultantLevel = data.readInt();
    }

    public void WriteInitialData(ByteBuf data) {
        data.writeInt(this.scoresTime);
        data.writeInt(this.rankUpdateTime);
        data.writeInt(this.votingTime);
        data.writeBoolean(this.votingEnabled);
        if (this.votingEnabled) {
            data.writeByte(this.votingOptions.length);
            for (VotingOption votingOption : this.votingOptions) {
                PacketBase.writeUTF(data, votingOption.gametype);
                PacketBase.writeUTF(data, votingOption.mapName);
                PacketBase.writeUTF(data, votingOption.teamNames[0]);
                PacketBase.writeUTF(data, votingOption.teamNames[1]);
            }
        }
        data.writeInt(this.pendingXP);
        data.writeInt(this.resultantXP);
        data.writeInt(this.resultantLevel);
    }

    public void ReadNumVotesUpdate(ByteBuf data) {
        int numOptions = data.readByte();
        this.votingOptions = new VotingOption[numOptions];
        for (int i = 0; i < numOptions; ++i) {
            this.votingOptions[i] = new VotingOption("", "", "", "");
            this.votingOptions[i].numVotes = data.readInt();
        }
    }

    public void WriteNumVotesUpdate(ByteBuf data) {
        data.writeByte(this.votingOptions.length);
        for (VotingOption votingOption : this.votingOptions) {
            data.writeInt(votingOption.numVotes);
        }
    }

    public void FillVoteOptions(TeamsRound[] rounds) {
        this.votingOptions = new VotingOption[rounds.length];
        for (int i = 0; i < rounds.length; ++i) {
            this.votingOptions[i] = new VotingOption(rounds[i].gametype.name, rounds[i].map.name, rounds[i].teams[0].textColour + rounds[i].teams[0].shortName, rounds[i].teams[1].textColour + rounds[i].teams[1].shortName);
        }
    }

    public class VotingOption {
        public String mapName;
        public String gametype;
        public String[] teamNames;
        public int numVotes;

        public VotingOption(String s, String s1, String s2, String s3) {
            this.gametype = s;
            this.mapName = s1;
            this.teamNames = new String[2];
            this.teamNames[0] = s2;
            this.teamNames[1] = s3;
            this.numVotes = 0;
        }
    }
}

