/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.teams.Gametype;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.teams.TeamsMap;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TeamsRound
implements Comparable<TeamsRound> {
    public Gametype gametype;
    public TeamsMap map;
    public Team[] teams;
    public int timeLimit;
    public int scoreLimit;
    public float popularity;
    public int roundsSincePlayed;

    public TeamsRound(TeamsMap map2, Gametype gametype2, Team[] teams2, int timeLimit, int scoreLimit) {
        this.map = map2;
        this.gametype = gametype2;
        this.teams = teams2;
        this.timeLimit = timeLimit;
        this.scoreLimit = scoreLimit;
        this.popularity = 0.5f;
    }

    public TeamsRound(NBTTagCompound tags) {
        this.map = TeamsManager.getInstance().maps.get(tags.func_74779_i("Map"));
        this.gametype = Gametype.getGametype(tags.func_74779_i("Gametype"));
        this.timeLimit = tags.func_74762_e("TimeLimit");
        this.scoreLimit = tags.func_74762_e("ScoreLimit");
        this.teams = new Team[tags.func_74762_e("NumTeams")];
        for (int i = 0; i < this.teams.length; ++i) {
            this.teams[i] = Team.getTeam(tags.func_74779_i("Team_" + i));
            if (this.teams[i] != null) continue;
            this.teams[i] = Team.teams.get(0);
        }
        this.popularity = tags.func_74760_g("Pop");
    }

    public void writeToNBT(NBTTagCompound tags) {
        tags.func_74778_a("Map", this.map.shortName);
        tags.func_74778_a("Gametype", this.gametype.shortName);
        tags.func_74768_a("TimeLimit", this.timeLimit);
        tags.func_74768_a("ScoreLimit", this.scoreLimit);
        tags.func_74768_a("NumTeams", this.teams.length);
        for (int i = 0; i < this.teams.length; ++i) {
            tags.func_74778_a("Team_" + i, this.teams[i].shortName);
        }
        tags.func_74776_a("Pop", this.popularity);
    }

    public int getTeamID(Team team) {
        if (team == Team.spectators) {
            return 1;
        }
        if (team == this.teams[0]) {
            return 2;
        }
        if (team == this.teams[1]) {
            return 3;
        }
        return 0;
    }

    public Team getTeam(int id) {
        switch (id) {
            case 0: {
                return null;
            }
            case 1: {
                return Team.spectators;
            }
        }
        return this.teams[id - 2];
    }

    public Team getOtherTeam(Team team) {
        if (team == Team.spectators || team == null || this.teams.length != 2) {
            return team;
        }
        if (team == this.teams[0]) {
            return this.teams[1];
        }
        return this.teams[0];
    }

    public Optional<Team> getTeam(EntityPlayer player) {
        String username = player.func_70005_c_();
        for (Team team : this.teams) {
            for (String name : team.members) {
                if (!username.equals(name)) continue;
                return Optional.of(team);
            }
        }
        return Optional.empty();
    }

    public float getWeight() {
        return this.popularity * 4.0f + (float)this.roundsSincePlayed;
    }

    @Override
    public int compareTo(TeamsRound o) {
        return Float.compare(o.getWeight(), this.getWeight());
    }
}

