/*
 * Decompiled with CFR 0.152.
 */
package com.horriblenerd.foodpouches;

import com.horriblenerd.foodpouches.Config;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FoodPouchItem
extends Item {
    private final boolean automatic;
    private final boolean infinite;
    private int capacity = 200;

    public FoodPouchItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1));
        this.automatic = false;
        this.infinite = false;
    }

    public FoodPouchItem(boolean auto) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1));
        this.automatic = auto;
        this.infinite = false;
    }

    public FoodPouchItem(boolean auto, boolean infinite) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1));
        this.automatic = auto;
        this.infinite = infinite;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.func_201670_d()) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (playerIn.func_225608_bj_()) {
            if (this.isInfinite()) {
                return ActionResult.func_226251_d_((Object)itemstack);
            }
            float food = 0.0f;
            PlayerInventory inv = playerIn.field_71071_by;
            for (ItemStack i : inv.field_70462_a) {
                Food f;
                if (!i.func_222117_E() || (f = i.func_77973_b().func_219967_s()) == null || !f.func_221464_f().isEmpty()) continue;
                float amount = f.func_221469_b() * 2.0f * (float)f.func_221466_a();
                int remaining = itemstack.func_77952_i();
                float count = amount * (float)i.func_190916_E() > (float)remaining ? (float)remaining / amount : (float)i.func_190916_E();
                i.func_190918_g((int)Math.ceil(count));
                this.addFoodLevel(itemstack, (int)(food += count * amount));
            }
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        if (!this.isAutomatic() && playerIn.func_71043_e(false) && itemstack.func_77952_i() + 1 < itemstack.func_77958_k()) {
            playerIn.func_184598_c(handIn);
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return stack;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        int needed = 20 - player.func_71024_bL().func_75116_a();
        if (this.isInfinite()) {
            player.func_71024_bL().func_75122_a(needed, 20.0f);
        } else {
            int able = this.getFoodLevel(stack);
            int restored = able < 20 ? able : needed;
            player.func_71024_bL().func_75122_a(restored, (float)restored);
            stack.func_196085_b(stack.func_77952_i() + restored);
        }
        return stack;
    }

    public SoundEvent func_225519_S__() {
        return SoundEvents.field_187537_bA;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.EAT;
    }

    public int func_77626_a(ItemStack stack) {
        return (Boolean)Config.LONG_USE_TIME.get() != false ? 48 : 32;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.automatic && entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            this.func_77654_b(stack, worldIn, (LivingEntity)player);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        StringTextComponent meals;
        if (this.isInfinite()) {
            meals = new StringTextComponent("");
            meals.func_211708_a(TextFormatting.GREEN);
            meals.func_150257_a(new StringTextComponent("999999 ").func_211708_a(TextFormatting.OBFUSCATED));
            meals.func_150257_a((ITextComponent)new StringTextComponent("meals"));
        } else {
            meals = new StringTextComponent(String.format("%d meals", this.getFoodLevel(stack) / 20));
            meals.func_211708_a(TextFormatting.GREEN);
        }
        tooltip.add((ITextComponent)meals);
        if (this.isInfinite() && !((Boolean)Config.CREATIVE_ENABLED.get()).booleanValue() || this.isAutomatic() && !((Boolean)Config.AUTO_ENABLED.get()).booleanValue()) {
            StringTextComponent enabled = new StringTextComponent("");
            enabled.func_150257_a(new StringTextComponent("Disabled!").func_211708_a(TextFormatting.RED));
            tooltip.add((ITextComponent)enabled);
        }
        if (((Boolean)Config.ADVANCED_TOOLTIP.get()).booleanValue()) {
            StringTextComponent advanced;
            if (Screen.hasShiftDown()) {
                advanced = new StringTextComponent("");
                advanced.func_211708_a(TextFormatting.BLUE);
                advanced.func_150257_a((ITextComponent)new StringTextComponent("Sneak + Use while holding to fill"));
                advanced.func_150257_a((ITextComponent)new StringTextComponent("\nEating only depletes it by the required amount"));
                advanced.func_150257_a((ITextComponent)new StringTextComponent("\n1 meal = 20 hunger/saturation (1 full hunger bar)"));
                tooltip.add((ITextComponent)advanced);
            } else {
                advanced = new StringTextComponent("");
                advanced.func_150257_a((ITextComponent)new StringTextComponent("<press shift>"));
                advanced.func_211708_a(TextFormatting.BLUE);
                tooltip.add((ITextComponent)advanced);
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.infinite;
    }

    public Rarity func_77613_e(ItemStack stack) {
        if (this.isInfinite()) {
            return Rarity.EPIC;
        }
        return super.func_77613_e(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.capacity;
    }

    public void setMealCapacity(int capacity) {
        this.capacity = capacity * 20;
    }

    public void setPreciseCapacity(int capacity) {
        this.capacity = capacity;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public int getFoodLevel(ItemStack stack) {
        return this.getMaxDamage(stack) - this.getDamage(stack);
    }

    public void setFoodLevel(ItemStack stack, int foodLevel) {
        this.setDamage(stack, this.getMaxDamage(stack) - foodLevel);
    }

    public void addFoodLevel(ItemStack stack, int foodLevel) {
        this.setFoodLevel(stack, this.getFoodLevel(stack) + foodLevel);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        if (stack.func_77973_b() instanceof FoodPouchItem && ((FoodPouchItem)stack.func_77973_b()).isInfinite()) {
            stack.func_196085_b(0);
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }
}

