/*
 * Decompiled with CFR 0.152.
 */
package com.horriblenerd.foodpouches.recipes;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.horriblenerd.foodpouches.FoodPouchItem;
import com.horriblenerd.foodpouches.Registration;
import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PouchRecipeRepair
extends SpecialRecipe {
    public PouchRecipeRepair(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b() instanceof FoodPouchItem) {
                list.add(itemstack);
                continue;
            }
            return false;
        }
        return list.size() >= 2;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack highest = ItemStack.field_190927_a;
        int amount = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof FoodPouchItem)) continue;
            stackList.add(stack);
            if (stack.func_77958_k() <= amount && (stack.func_77958_k() != amount || !((FoodPouchItem)stack.func_77973_b()).isAutomatic())) continue;
            amount = stack.func_77958_k();
            highest = stack.func_77946_l();
        }
        if (stackList.size() > 1) {
            int foodLevel = 0;
            for (ItemStack stack : stackList) {
                foodLevel += ((FoodPouchItem)stack.func_77973_b()).getFoodLevel(stack);
            }
            ((FoodPouchItem)highest.func_77973_b()).setFoodLevel(highest, foodLevel);
        }
        return highest;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)Registration.CRAFTING_POUCH_REPAIR.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PouchRecipeRepair> {
        private static final ResourceLocation NAME = new ResourceLocation("foodpouches", "pouch_repairing");

        public PouchRecipeRepair read(ResourceLocation recipeId, JsonObject json) {
            return new PouchRecipeRepair(recipeId);
        }

        public PouchRecipeRepair read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new PouchRecipeRepair(recipeId);
        }

        public void write(PacketBuffer buffer, PouchRecipeRepair recipe) {
        }
    }
}

