/*
 * Decompiled with CFR 0.152.
 */
package com.horriblenerd.foodpouches.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.horriblenerd.foodpouches.Config;
import com.horriblenerd.foodpouches.FoodPouchItem;
import com.horriblenerd.foodpouches.Registration;
import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PouchRecipeUpgrade
implements ICraftingRecipe {
    private final ResourceLocation id;
    private final String group;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> recipeItems;
    private final boolean isSimple;
    private final int startingFood;

    public PouchRecipeUpgrade(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn, int startingFoodIn) {
        this.id = idIn;
        this.group = groupIn;
        this.recipeOutput = recipeOutputIn;
        this.recipeItems = recipeItemsIn;
        this.isSimple = recipeItemsIn.stream().allMatch(Ingredient::isSimple);
        this.startingFood = startingFoodIn;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)Registration.CRAFTING_POUCH_UPGRADE.get();
    }

    public String func_193358_e() {
        return this.group;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        RecipeItemHelper recipeitemhelper = new RecipeItemHelper();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            ++i;
            if (this.isSimple) {
                recipeitemhelper.func_221264_a(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.recipeItems.size() && (this.isSimple ? recipeitemhelper.func_194116_a((IRecipe)this, null) : RecipeMatcher.findMatches(inputs, this.recipeItems) != null);
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack out = this.func_77571_b().func_77946_l();
        if (out.func_77973_b() instanceof FoodPouchItem) {
            if (((FoodPouchItem)out.func_77973_b()).isAutomatic() && !((Boolean)Config.AUTO_ENABLED.get()).booleanValue()) {
                return ItemStack.field_190927_a;
            }
            ((FoodPouchItem)out.func_77973_b()).setFoodLevel(out, this.startingFood);
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof FoodPouchItem)) continue;
            int f = ((FoodPouchItem)stack.func_77973_b()).getFoodLevel(stack);
            ((FoodPouchItem)out.func_77973_b()).addFoodLevel(out, f);
        }
        return out;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.recipeItems.size();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PouchRecipeUpgrade> {
        private static final ResourceLocation NAME = new ResourceLocation("foodpouches", "pouch_upgrading");

        public PouchRecipeUpgrade read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            int f = JSONUtils.func_151203_m((JsonObject)json, (String)"food");
            NonNullList<Ingredient> nonnulllist = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new PouchRecipeUpgrade(recipeId, s, itemstack, nonnulllist, f);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray p_199568_0_) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < p_199568_0_.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)p_199568_0_.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public PouchRecipeUpgrade read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int i = buffer.func_150792_a();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            int f = buffer.readInt();
            return new PouchRecipeUpgrade(recipeId, s, itemstack, (NonNullList<Ingredient>)nonnulllist, f);
        }

        public void write(PacketBuffer buffer, PouchRecipeUpgrade recipe) {
            buffer.func_180714_a(recipe.group);
            buffer.func_150787_b(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.recipeOutput);
            buffer.func_150787_b(recipe.startingFood);
        }
    }
}

