/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class FruitsConfig {
    public static int growingSpeed = 5;
    private static DropMode fruitDropModeSingleplayer = DropMode.INDEPENDENT;
    private static DropMode fruitDropModeMultiplayer = DropMode.ONE_BY_ONE;
    public static float oakLeavesDropsAppleSapling = 0.2f;
    private static ForgeConfigSpec.IntValue growingSpeedCfg;
    private static ForgeConfigSpec.EnumValue<DropMode> fruitDropModeSingleplayerCfg;
    private static ForgeConfigSpec.EnumValue<DropMode> fruitDropModeMultiplayerCfg;
    private static ForgeConfigSpec.DoubleValue oakLeavesDropsAppleSaplingCfg;
    static final ForgeConfigSpec spec;

    private FruitsConfig(ForgeConfigSpec.Builder builder) {
        growingSpeedCfg = builder.defineInRange("growingSpeed", growingSpeed, 0, 100);
        fruitDropModeSingleplayerCfg = builder.defineEnum("fruitDropModeSingleplayer", (Enum)fruitDropModeSingleplayer);
        fruitDropModeMultiplayerCfg = builder.defineEnum("fruitDropModeMultiplayer", (Enum)fruitDropModeMultiplayer);
        oakLeavesDropsAppleSaplingCfg = builder.defineInRange("oakLeavesDropsAppleSapling", (double)oakLeavesDropsAppleSapling, 0.0, 1.0);
    }

    public static void refresh() {
        growingSpeed = (Integer)growingSpeedCfg.get();
        fruitDropModeSingleplayer = (DropMode)((Object)fruitDropModeSingleplayerCfg.get());
        fruitDropModeMultiplayer = (DropMode)((Object)fruitDropModeMultiplayerCfg.get());
        oakLeavesDropsAppleSapling = ((Double)oakLeavesDropsAppleSaplingCfg.get()).floatValue();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading event) {
        ((CommentedFileConfig)event.getConfig().getConfigData()).load();
        FruitsConfig.refresh();
    }

    public static DropMode getDropMode(World world) {
        return world.func_73046_m().func_71262_S() ? fruitDropModeMultiplayer : fruitDropModeSingleplayer;
    }

    static {
        spec = (ForgeConfigSpec)new ForgeConfigSpec.Builder().configure(FruitsConfig::new).getRight();
    }

    public static enum DropMode {
        NO_DROP,
        INDEPENDENT,
        ONE_BY_ONE;

    }
}

