/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.util.HashSet;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.fruits.FruitType;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.hybridization.HybridingContext;
import snownee.fruits.hybridization.Hybridization;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.Util;

public final class Hook {
    private Hook() {
    }

    public static PathNodeType func_227480_b_(IBlockReader p_227480_0_, int p_227480_1_, int p_227480_2_, int p_227480_3_, MobEntity entity) {
        PathNodeType pathnodetype = Hook.getPathNodeTypeRaw(p_227480_0_, p_227480_1_, p_227480_2_, p_227480_3_, entity);
        if (pathnodetype == PathNodeType.OPEN && p_227480_2_ >= 1) {
            Block block = p_227480_0_.func_180495_p(new BlockPos(p_227480_1_, p_227480_2_ - 1, p_227480_3_)).func_177230_c();
            PathNodeType pathnodetype1 = Hook.getPathNodeTypeRaw(p_227480_0_, p_227480_1_, p_227480_2_ - 1, p_227480_3_, entity);
            PathNodeType pathNodeType = pathnodetype = pathnodetype1 != PathNodeType.WALKABLE && pathnodetype1 != PathNodeType.OPEN && pathnodetype1 != PathNodeType.WATER && pathnodetype1 != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            if (pathnodetype1 == PathNodeType.DAMAGE_FIRE || block == Blocks.field_196814_hQ || block == Blocks.field_222433_lV) {
                pathnodetype = PathNodeType.DAMAGE_FIRE;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_CACTUS) {
                pathnodetype = PathNodeType.DAMAGE_CACTUS;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_OTHER) {
                pathnodetype = PathNodeType.DAMAGE_OTHER;
            }
            if (pathnodetype1 == PathNodeType.STICKY_HONEY) {
                pathnodetype = PathNodeType.STICKY_HONEY;
            }
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            pathnodetype = Hook.checkNeighborBlocks(p_227480_0_, p_227480_1_, p_227480_2_, p_227480_3_, pathnodetype, entity);
        }
        return pathnodetype;
    }

    public static PathNodeType checkNeighborBlocks(IBlockReader p_193578_0_, int blockaccessIn, int x, int y, PathNodeType z, MobEntity entity) {
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        PathNodeType type;
                        if (i == 0 && k == 0 || (type = Hook.getPathNodeTypeRaw(p_193578_0_, blockaccessIn, x, y, entity)) != PathNodeType.DANGER_CACTUS && type != PathNodeType.DANGER_FIRE && type != PathNodeType.DANGER_OTHER) continue;
                        z = type;
                    }
                }
            }
        }
        return z;
    }

    public static PathNodeType getPathNodeTypeRaw(IBlockReader blockaccessIn, int x, int y, int z, MobEntity entity) {
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockState blockstate = blockaccessIn.func_180495_p(blockpos);
        PathNodeType type = Hybridization.INSTANCE == null ? blockstate.getAiPathNodeType(blockaccessIn, blockpos) : blockstate.getAiPathNodeType(blockaccessIn, blockpos, entity);
        if (type != null) {
            return type;
        }
        Block block = blockstate.func_177230_c();
        Material material = blockstate.func_185904_a();
        if (blockstate.isAir(blockaccessIn, blockpos)) {
            return PathNodeType.OPEN;
        }
        if (!block.func_203417_a(BlockTags.field_212185_E) && block != Blocks.field_196651_dG) {
            if (block == Blocks.field_150480_ab) {
                return PathNodeType.DAMAGE_FIRE;
            }
            if (block == Blocks.field_150434_aF) {
                return PathNodeType.DAMAGE_CACTUS;
            }
            if (block == Blocks.field_222434_lW) {
                return PathNodeType.DAMAGE_OTHER;
            }
            if (block == Blocks.field_226907_mc_) {
                return PathNodeType.STICKY_HONEY;
            }
            if (block == Blocks.field_150375_by) {
                return PathNodeType.COCOA;
            }
            if (block instanceof DoorBlock && material == Material.field_151575_d && !((Boolean)blockstate.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_WOOD_CLOSED;
            }
            if (block instanceof DoorBlock && material == Material.field_151573_f && !((Boolean)blockstate.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_IRON_CLOSED;
            }
            if (block instanceof DoorBlock && ((Boolean)blockstate.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_OPEN;
            }
            if (block instanceof AbstractRailBlock) {
                return PathNodeType.RAIL;
            }
            if (block instanceof LeavesBlock) {
                return PathNodeType.LEAVES;
            }
            if (!(block.func_203417_a(BlockTags.field_219748_G) || block.func_203417_a(BlockTags.field_219757_z) || block instanceof FenceGateBlock && !((Boolean)blockstate.func_177229_b((IProperty)FenceGateBlock.field_176466_a)).booleanValue())) {
                IFluidState ifluidstate = blockaccessIn.func_204610_c(blockpos);
                if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                    return PathNodeType.WATER;
                }
                if (ifluidstate.func_206884_a(FluidTags.field_206960_b)) {
                    return PathNodeType.LAVA;
                }
                return blockstate.func_196957_g(blockaccessIn, blockpos, PathType.LAND) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
            }
            return PathNodeType.FENCE;
        }
        return PathNodeType.TRAPDOOR;
    }

    public static boolean safeSetBlock(World world, BlockPos pos, BlockState state) {
        BlockState old = world.func_180495_p(pos);
        if (old == state || old.hasTileEntity() || old.func_185905_o() == PushReaction.BLOCK || old.func_177230_c() == Blocks.field_150343_Z || old.func_177230_c().func_203417_a(BlockTags.field_219755_X)) {
            return false;
        }
        return world.func_175656_a(pos, state);
    }

    public static boolean canPollinate(BlockState state) {
        if (state.func_203425_a(BlockTags.field_226148_H_)) {
            if (state.func_177230_c() == Blocks.field_196800_gd) {
                return state.func_177229_b((IProperty)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER;
            }
            return true;
        }
        if (state.func_203425_a(BlockTags.field_219746_E)) {
            return true;
        }
        if (Hybridization.INSTANCE != null && state.func_177230_c() instanceof FruitLeavesBlock) {
            if (!((FruitLeavesBlock)state.func_177230_c()).canGrow(state)) {
                return false;
            }
            return (Integer)state.func_177229_b((IProperty)FruitLeavesBlock.AGE) == 2;
        }
        return false;
    }

    public static void onPollinateComplete(BeeEntity bee) {
        String id;
        BlockState state = bee.field_70170_p.func_180495_p(bee.field_226368_bH_);
        Block block = state.func_177230_c();
        FruitType type = block instanceof FruitLeavesBlock ? ((FruitLeavesBlock)block).type.get() : null;
        NBTHelper data = NBTHelper.of((CompoundNBT)bee.getPersistentData());
        int count = data.getInt("FruitsCount");
        ListNBT list = data.getTagList("FruitsList", 8);
        if (list == null) {
            list = new ListNBT();
            data.setTag("FruitsList", (INBT)list);
        }
        String string = id = type != null ? type.name() : "_" + Util.trimRL((ResourceLocation)block.getRegistryName());
        if (!list.stream().anyMatch(e -> e.func_150285_a_().equals(id))) {
            StringNBT stringNBT = StringNBT.func_229705_a_((String)id);
            if (list.size() < 5) {
                list.add((Object)stringNBT);
            } else {
                list.set(count % 5, (INBT)stringNBT);
            }
            data.setInt("FruitsCount", count + 1);
        }
        if (list.size() > 1) {
            HashSet ingredients = Sets.newHashSet();
            list.forEach(e -> {
                String _id = e.func_150285_a_();
                if (_id.startsWith("_")) {
                    Block _block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(_id.substring(1)));
                    ingredients.add(Either.right((Object)_block));
                } else {
                    FruitType _type = FruitType.parse(_id);
                    ingredients.add(Either.left((Object)((Object)_type)));
                }
            });
            bee.field_70170_p.func_199532_z().func_215371_a(Hybridization.RECIPE_TYPE, (IInventory)new HybridingContext(ingredients), bee.field_70170_p).ifPresent(recipe -> {
                boolean isMisc;
                Block newBlock = recipe.getResultAsBlock(ingredients);
                boolean isLeaves = newBlock instanceof FruitLeavesBlock;
                boolean isFlower = !isLeaves && newBlock.func_203417_a(BlockTags.field_226149_I_);
                boolean bl = isMisc = !isLeaves && !isFlower;
                if (!isMisc && isLeaves != block instanceof FruitLeavesBlock) {
                    return;
                }
                BlockPos root = bee.field_226368_bH_;
                if (block.func_203417_a(BlockTags.field_226148_H_) && state.func_196959_b((IProperty)DoublePlantBlock.field_176492_b) && state.func_177229_b((IProperty)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER) {
                    root = root.func_177977_b();
                } else if (isMisc && !newBlock.func_181623_g() && !(block instanceof FruitLeavesBlock)) {
                    root = root.func_177977_b();
                }
                BlockState newState = newBlock.func_176223_P();
                boolean isBigFlower = false;
                if (isLeaves) {
                    newState = (BlockState)newState.func_206870_a((IProperty)FruitLeavesBlock.AGE, (Comparable)Integer.valueOf(2));
                    newState = (BlockState)newState.func_206870_a((IProperty)LeavesBlock.field_208494_a, state.func_177229_b((IProperty)LeavesBlock.field_208494_a));
                } else if (isFlower && newBlock.func_203417_a(BlockTags.field_226148_H_) && newState.func_196959_b((IProperty)DoublePlantBlock.field_176492_b)) {
                    newState = (BlockState)newState.func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER);
                    isBigFlower = true;
                }
                boolean success = Hook.safeSetBlock(bee.field_70170_p, root, newState);
                if (success && isBigFlower) {
                    newState = (BlockState)newState.func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER);
                    Hook.safeSetBlock(bee.field_70170_p, root.func_177984_a(), newState);
                }
                if (success) {
                    data.remove("FruitsList");
                    data.setInt("FruitsCount", 0);
                }
            });
        }
    }
}

