/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.cherry;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.trees.Tree;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BannerPatternItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import snownee.fruits.FruitType;
import snownee.fruits.Fruits;
import snownee.fruits.MainModule;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.block.trees.FruitTree;
import snownee.fruits.cherry.FruitTypeExtension;
import snownee.fruits.cherry.block.CherryLeavesBlock;
import snownee.fruits.cherry.block.SlidingDoorBlock;
import snownee.fruits.cherry.client.particle.PetalParticle;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.NoItem;
import snownee.kiwi.RenderLayer;
import snownee.kiwi.block.ModBlock;
import snownee.kiwi.item.ModItem;

@KiwiModule(name="cherry")
@KiwiModule.Optional
@KiwiModule.Subscriber(value={KiwiModule.Subscriber.Bus.MOD, KiwiModule.Subscriber.Bus.FORGE})
public class CherryModule
extends AbstractModule {
    @KiwiModule.Group(value="building_blocks")
    public static final LogBlock CHERRY_LOG = new LogBlock(MaterialColor.field_151664_l, CherryModule.blockProp((Block)Blocks.field_196617_K));
    @KiwiModule.Group(value="building_blocks")
    public static final Block CHERRY_WOOD = CherryModule.init((Block)new RotatedPillarBlock(CherryModule.blockProp((Block)Blocks.field_196634_T)));
    @KiwiModule.Group(value="building_blocks")
    public static final Block STRIPPED_CHERRY_LOG = CherryModule.init((Block)new RotatedPillarBlock(CherryModule.blockProp((Block)Blocks.field_203207_U)));
    @KiwiModule.Group(value="building_blocks")
    public static final Block STRIPPED_CHERRY_WOOD = CherryModule.init((Block)new RotatedPillarBlock(CherryModule.blockProp((Block)Blocks.field_209392_ae)));
    @KiwiModule.Group(value="building_blocks")
    public static final Block CHERRY_PLANKS = new ModBlock(CherryModule.blockProp((Block)Blocks.field_196668_q));
    @KiwiModule.Group(value="building_blocks")
    public static final SlabBlock CHERRY_SLAB = (SlabBlock)CherryModule.init((Block)new SlabBlock(CherryModule.blockProp((Block)Blocks.field_196630_bt)));
    @KiwiModule.Group(value="building_blocks")
    public static final StairsBlock CHERRY_STAIRS = (StairsBlock)CherryModule.init((Block)new StairsBlock(() -> CHERRY_PLANKS.func_176223_P(), CherryModule.blockProp((Block)Blocks.field_150481_bH)));
    @KiwiModule.Group(value="decorations")
    public static final FenceBlock CHERRY_FENCE = (FenceBlock)CherryModule.init((Block)new FenceBlock(CherryModule.blockProp((Block)Blocks.field_180403_aR)));
    @KiwiModule.Group(value="redstone")
    public static final FenceGateBlock CHERRY_FENCE_GATE = (FenceGateBlock)CherryModule.init((Block)new FenceGateBlock(CherryModule.blockProp((Block)Blocks.field_180386_br)));
    @KiwiModule.Group(value="redstone")
    public static final TrapDoorBlock CHERRY_TRAPDOOR = new TrapDoorBlock(CherryModule.blockProp((Block)Blocks.field_196644_cZ));
    @KiwiModule.Group(value="redstone")
    public static final SlidingDoorBlock CHERRY_DOOR = new SlidingDoorBlock(CherryModule.blockProp((Block)Blocks.field_180411_ar));
    @KiwiModule.Group(value="redstone")
    public static final WoodButtonBlock CHERRY_BUTTON = new WoodButtonBlock(CherryModule.blockProp((Block)Blocks.field_196644_cZ));
    @KiwiModule.Group(value="redstone")
    public static final PressurePlateBlock CHERRY_PRESSURE_PLATE = new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, CherryModule.blockProp((Block)Blocks.field_180411_ar));
    public static final BasicParticleType PETAL_CHERRY = new BasicParticleType(false);
    public static final BasicParticleType PETAL_REDLOVE = new BasicParticleType(false);
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final LeavesBlock CHERRY_LEAVES = new CherryLeavesBlock(() -> FruitTypeExtension.CHERRY, CherryModule.blockProp((Block)Blocks.field_196642_W), (IParticleData)PETAL_CHERRY);
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final LeavesBlock REDLOVE_LEAVES = new CherryLeavesBlock(() -> FruitTypeExtension.REDLOVE, CherryModule.blockProp((Block)Blocks.field_196642_W), (IParticleData)PETAL_REDLOVE);
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final CarpetBlock CHERRY_CARPET = (CarpetBlock)CherryModule.init((Block)new CarpetBlock(DyeColor.PINK, CherryModule.blockProp((Block)CHERRY_LEAVES)));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final CarpetBlock REDLOVE_CARPET = (CarpetBlock)CherryModule.init((Block)new CarpetBlock(DyeColor.WHITE, CherryModule.blockProp((Block)REDLOVE_LEAVES)));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final SaplingBlock CHERRY_SAPLING = new SaplingBlock((Tree)new FruitTree(() -> FruitTypeExtension.CHERRY), CherryModule.blockProp((Block)Blocks.field_196674_t));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final SaplingBlock REDLOVE_SAPLING = new SaplingBlock((Tree)new FruitTree(() -> FruitTypeExtension.REDLOVE), CherryModule.blockProp((Block)Blocks.field_196674_t));
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    @NoItem
    public static final FlowerPotBlock POTTED_CHERRY = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL, () -> CHERRY_SAPLING, CherryModule.blockProp((Block)Blocks.field_196746_es));
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    @NoItem
    public static final FlowerPotBlock POTTED_REDLOVE = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL, () -> REDLOVE_SAPLING, CherryModule.blockProp((Block)Blocks.field_196746_es));
    public static final Item CHERRY = new ModItem(CherryModule.itemProp().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.CHERRY));
    public static final Item REDLOVE = new ModItem(CherryModule.itemProp().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.REDLOVE));
    public static final SoundEvent OPEN_SOUND = new SoundEvent(new ResourceLocation("fruittrees", "block.wooden_door.open"));
    public static final SoundEvent CLOSE_SOUND = new SoundEvent(new ResourceLocation("fruittrees", "block.wooden_door.close"));
    public static final BannerPattern HEART = BannerPattern.create((String)"HEART", (String)"heart", (String)"hrt", (ItemStack)new ItemStack((IItemProvider)REDLOVE));
    public static final BannerPatternItem HEART_BANNER_PATTERN = new BannerPatternItem(HEART, CherryModule.itemProp().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(Rarity.UNCOMMON));

    protected void init(FMLCommonSetupEvent event) {
        try {
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.field_150457_bL;
            pot.addPlant(CHERRY_SAPLING.getRegistryName(), () -> POTTED_CHERRY);
            pot.addPlant(REDLOVE_SAPLING.getRegistryName(), () -> POTTED_REDLOVE);
            if (AxeItem.field_203176_a instanceof ImmutableMap) {
                AxeItem.field_203176_a = Collections.synchronizedMap(Maps.newHashMap((Map)AxeItem.field_203176_a));
            }
            AxeItem.field_203176_a.put(CHERRY_LOG, STRIPPED_CHERRY_LOG);
            AxeItem.field_203176_a.put(CHERRY_WOOD, STRIPPED_CHERRY_WOOD);
        }
        catch (Exception e) {
            Fruits.logger.catching((Throwable)e);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    protected void clientInit(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)PETAL_CHERRY, PetalParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)PETAL_REDLOVE, PetalParticle.Factory::new);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void handleBlockColor(ColorHandlerEvent.Block event) {
        BlockState birchLeaves = Blocks.field_196647_Y.func_176223_P();
        BlockColors blockColors = event.getBlockColors();
        blockColors.func_186722_a((state, world, pos, i) -> {
            if (i == 0) {
                return blockColors.func_228054_a_(birchLeaves, world, pos, i);
            }
            if (i == 1) {
                int stage = (Integer)state.func_177229_b((IProperty)FruitLeavesBlock.AGE);
                if (stage < 3) {
                    return blockColors.func_228054_a_(birchLeaves, world, pos, i);
                }
                Block block = state.func_177230_c();
                if (block == REDLOVE_LEAVES) {
                    return 0xC22626;
                }
                if (block == CHERRY_LEAVES) {
                    return 14965589;
                }
            }
            return -1;
        }, new Block[]{CHERRY_LEAVES, REDLOVE_LEAVES});
    }

    static {
        FruitTypeExtension.CHERRY = FruitType.create("CHERRY", (Block)CHERRY_LOG, CHERRY_LEAVES, () -> CHERRY_SAPLING, CHERRY);
        FruitTypeExtension.REDLOVE = FruitType.create("REDLOVE", (Block)CHERRY_LOG, REDLOVE_LEAVES, () -> REDLOVE_SAPLING, REDLOVE);
        MainModule.ALL_LEAVES.add((Block)CHERRY_LEAVES);
        MainModule.ALL_LEAVES.add((Block)REDLOVE_LEAVES);
    }

    public static final class Foods {
        public static final Food CHERRY = new Food.Builder().func_221456_a(3).func_221454_a(0.3f).func_221453_d();
        public static final Food REDLOVE = new Food.Builder().func_221456_a(5).func_221454_a(0.6f).effect(() -> new EffectInstance(Effects.field_76428_l, 50), 1.0f).func_221453_d();
    }
}

