/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.hybridization;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import snownee.fruits.FruitType;
import snownee.fruits.hybridization.HybridingContext;
import snownee.fruits.hybridization.Hybridization;
import snownee.kiwi.crafting.Recipe;

public class HybridingRecipe
extends Recipe<HybridingContext> {
    protected final Either<FruitType, Block> result;
    public final ImmutableSet<Either<FruitType, Block>> ingredients;

    public HybridingRecipe(ResourceLocation id, Either<FruitType, Block> result, ImmutableSet<Either<FruitType, Block>> ingredients) {
        super(id);
        this.result = result;
        this.ingredients = ingredients;
    }

    public boolean matches(HybridingContext inv, World worldIn) {
        return this.ingredients.stream().allMatch(inv.ingredients::contains);
    }

    public Either<FruitType, Block> getResult(Set<Either<FruitType, Block>> types) {
        return this.result;
    }

    public Block getResultAsBlock(Set<Either<FruitType, Block>> types) {
        return (Block)this.getResult(types).map(t -> t.leaves, b -> b);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Hybridization.SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return Hybridization.RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<HybridingRecipe> {
        public HybridingRecipe read(ResourceLocation recipeId, JsonObject json) {
            Either<FruitType, Block> result = Serializer.readIngredient(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            ImmutableSet.Builder builder = ImmutableSet.builder();
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            if (ingredients.size() < 2 || ingredients.size() > 4) {
                throw new JsonSyntaxException("Size of ingredients has to be in [2, 4]");
            }
            ingredients.forEach(e -> builder.add(Serializer.readIngredient(e.getAsJsonObject())));
            return new HybridingRecipe(recipeId, result, (ImmutableSet<Either<FruitType, Block>>)builder.build());
        }

        protected static Either<FruitType, Block> readIngredient(JsonObject object) {
            if (object.has("block")) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"block")));
                return Either.right((Object)block);
            }
            if (object.has("fruit")) {
                FruitType type = FruitType.parse(JSONUtils.func_151200_h((JsonObject)object, (String)"fruit"));
                return Either.left((Object)((Object)type));
            }
            throw new JsonSyntaxException("Expect key 'block' or 'fruit'");
        }

        public HybridingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int i;
            Either result = buffer.readBoolean() ? Either.left((Object)((Object)FruitType.parse(buffer.func_150789_c(Short.MAX_VALUE)))) : Either.right((Object)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS));
            ImmutableSet.Builder builder = ImmutableSet.builder();
            int size = buffer.readByte();
            for (i = 0; i < size; ++i) {
                Block block = (Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS);
                builder.add((Object)Either.right((Object)block));
            }
            size = buffer.readByte();
            for (i = 0; i < size; ++i) {
                builder.add((Object)Either.left((Object)((Object)FruitType.parse(buffer.func_150789_c(Short.MAX_VALUE)))));
            }
            return new HybridingRecipe(recipeId, (Either<FruitType, Block>)result, (ImmutableSet<Either<FruitType, Block>>)builder.build());
        }

        public void write(PacketBuffer buffer, HybridingRecipe recipe) {
            recipe.result.ifLeft(type -> {
                buffer.writeBoolean(true);
                buffer.func_180714_a(type.name());
            }).ifRight(block -> {
                buffer.writeBoolean(false);
                buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (IForgeRegistryEntry)block);
            });
            ArrayList types = Lists.newArrayList();
            ArrayList blocks = Lists.newArrayList();
            recipe.ingredients.forEach(e -> {
                Boolean cfr_ignored_0 = (Boolean)e.map(types::add, blocks::add);
            });
            buffer.writeByte(blocks.size());
            for (Block block2 : blocks) {
                buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (IForgeRegistryEntry)block2);
            }
            buffer.writeByte(types.size());
            for (FruitType type2 : types) {
                buffer.func_180714_a(type2.name());
            }
        }
    }
}

