/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.world.gen.treedecorator;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import snownee.fruits.MainModule;

public class CarpetTreeDecorator
extends TreeDecorator {
    private BlockStateProvider carpetProvider;

    public CarpetTreeDecorator(BlockStateProvider carpetProvider) {
        super(MainModule.CARPET_DECORATOR);
        this.carpetProvider = carpetProvider;
    }

    public <T> CarpetTreeDecorator(Dynamic<T> dynamic) {
        this(((BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)dynamic.get("provider").get("type").asString().orElseThrow(RuntimeException::new)))).func_227399_a_(dynamic.get("provider").orElseEmptyMap()));
    }

    public <T> T func_218175_a(DynamicOps<T> dynamicOps) {
        return (T)new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString(Registry.field_229390_w_.func_177774_c((Object)this.field_227422_a_).toString()), (Object)dynamicOps.createString("provider"), (Object)this.carpetProvider.func_218175_a(dynamicOps)))).getValue();
    }

    public void func_225576_a_(IWorld world, Random rand, List<BlockPos> trunkList, List<BlockPos> foliageList, Set<BlockPos> allBlocks, MutableBoundingBox boundingBox) {
        if (foliageList.isEmpty()) {
            return;
        }
        int y = foliageList.get(0).func_177956_o() + 1;
        for (BlockPos pos : foliageList) {
            if (pos.func_177956_o() > y) break;
            if (!CarpetTreeDecorator.placeCarpet(world, pos, this.carpetProvider.func_225574_a_(rand, pos), 19)) continue;
            allBlocks.add(pos);
            boundingBox.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
        }
    }

    public static boolean placeCarpet(IWorld world, BlockPos pos, BlockState carpet, int flags) {
        Block block;
        int i = 0;
        BlockPos ground = pos;
        BlockState groundState = Blocks.field_150350_a.func_176223_P();
        while (++i < 5) {
            ground = pos.func_177979_c(i);
            groundState = world.func_180495_p(ground);
            if (groundState.func_177230_c() == Blocks.field_150349_c || groundState.func_177230_c() == Blocks.field_196554_aH || groundState.isAir((IBlockReader)world, ground)) continue;
            if (i != 1) break;
            return false;
        }
        if ((block = groundState.func_177230_c()) == Blocks.field_150433_aE || block == Blocks.field_150432_aD || block == Blocks.field_150403_cj || block == Blocks.field_180401_cv || block == Blocks.field_226907_mc_ || block == Blocks.field_150425_aM) {
            return false;
        }
        if (!Block.func_208061_a((VoxelShape)groundState.func_196952_d((IBlockReader)world, ground), (Direction)Direction.UP)) {
            return false;
        }
        return world.func_180501_a(ground.func_177984_a(), carpet, flags);
    }
}

