/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbultimine;

import com.feed_the_beast.mods.ftbultimine.FTBUltimineConfig;
import com.feed_the_beast.mods.ftbultimine.net.FTBUltimineNet;
import com.feed_the_beast.mods.ftbultimine.net.SendShapePacket;
import com.feed_the_beast.mods.ftbultimine.shape.BlockMatcher;
import com.feed_the_beast.mods.ftbultimine.shape.Shape;
import com.feed_the_beast.mods.ftbultimine.shape.ShapeContext;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.PacketDistributor;

public class FTBUltiminePlayerData {
    public final UUID id;
    public boolean pressed = false;
    public Shape shape = Shape.get("");
    public BlockPos cachedPos;
    public Direction cachedDirection;
    public List<BlockPos> cachedBlocks;

    public FTBUltiminePlayerData(UUID i) {
        this.id = i;
    }

    public void clearCache() {
        this.cachedPos = null;
        this.cachedDirection = null;
        this.cachedBlocks = null;
    }

    public static RayTraceResult rayTrace(ServerPlayerEntity player) {
        double distance = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        return player.func_213324_a(player.func_184812_l_() ? distance : distance - 0.5, 1.0f, false);
    }

    public void checkBlocks(ServerPlayerEntity player, boolean sendUpdate, int maxBlocks) {
        if (!this.pressed) {
            return;
        }
        RayTraceResult result = FTBUltiminePlayerData.rayTrace(player);
        if (!(result instanceof BlockRayTraceResult) || result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            if (this.cachedBlocks != null && !this.cachedBlocks.isEmpty()) {
                this.clearCache();
                if (sendUpdate) {
                    FTBUltimineNet.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendShapePacket(this.shape, Collections.emptyList()));
                }
            }
            return;
        }
        BlockRayTraceResult r = (BlockRayTraceResult)result;
        if (this.cachedDirection != r.func_216354_b() || this.cachedPos == null || !this.cachedPos.equals((Object)r.func_216350_a())) {
            this.updateBlocks(player, r.func_216350_a(), r.func_216354_b(), sendUpdate, maxBlocks);
        }
    }

    @Nullable
    public ShapeContext updateBlocks(ServerPlayerEntity player, BlockPos p, Direction d, boolean sendUpdate, int maxBlocks) {
        ShapeContext context = null;
        this.cachedPos = p;
        this.cachedDirection = d;
        if (maxBlocks <= 0) {
            this.cachedBlocks = Collections.emptyList();
        } else {
            context = new ShapeContext();
            context.player = player;
            context.pos = this.cachedPos;
            context.face = this.cachedDirection;
            context.matcher = BlockMatcher.MATCH;
            context.maxBlocks = maxBlocks;
            context.original = player.field_70170_p.func_180495_p(this.cachedPos);
            if (FTBUltimineConfig.mergeStone && BlockMatcher.ANY_STONE.check(context.original, context.original)) {
                context.matcher = BlockMatcher.ANY_STONE;
            } else if (BlockMatcher.BUSH.check(context.original, context.original)) {
                context.matcher = BlockMatcher.BUSH;
            }
            this.cachedBlocks = this.shape.getBlocks(context);
        }
        if (sendUpdate) {
            FTBUltimineNet.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendShapePacket(this.shape, this.cachedBlocks));
        }
        return context;
    }
}

