/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.gardentools;

import com.lothrazar.gardentools.ConfigManager;
import com.lothrazar.gardentools.GardenRegistry;
import com.lothrazar.gardentools.block.BlockIrrigation;
import com.lothrazar.gardentools.block.TileIrrigation;
import com.lothrazar.gardentools.item.ItemPlanter;
import com.lothrazar.gardentools.item.ItemTiller;
import com.lothrazar.gardentools.setup.ClientProxy;
import com.lothrazar.gardentools.setup.IProxy;
import com.lothrazar.gardentools.setup.ServerProxy;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTier;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gardentools")
public class GardenMod {
    public static final String MODID = "gardentools";
    public static final String certificateFingerprint = "@FINGERPRINT@";
    public static final IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
    public static final Logger LOGGER = LogManager.getLogger();
    public static ConfigManager config;

    public GardenMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        config = new ConfigManager(FMLPaths.CONFIGDIR.get().resolve("gardentools.toml"));
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public static void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        String source = event.getSource() == null ? "" : event.getSource().getName() + " ";
        String msg = "gardentoolsInvalid fingerprint detected! The file " + source + "may have been tampered with. This version will NOT be supported by the author!";
        System.out.println(msg);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            event.getRegistry().register(new BlockIrrigation(Block.Properties.func_200945_a((Material)Material.field_151578_c)).setRegistryName("irrigation_core"));
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            IForgeRegistry r = event.getRegistry();
            Item.Properties properties = new Item.Properties().func_200916_a(GardenRegistry.itemGroup);
            r.register(new BlockItem(GardenRegistry.irrigation, properties.func_200918_c(0).func_200917_a(64)).setRegistryName("irrigation_core"));
            r.register(new ItemTiller((IItemTier)ItemTier.GOLD, properties.func_200917_a(1).func_200918_c(777)).setRegistryName("cultivator"));
            properties = new Item.Properties().func_200916_a(GardenRegistry.itemGroup);
            r.register(new ItemPlanter(properties.func_200917_a(1).func_200918_c(777)).setRegistryName("planter"));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            IForgeRegistry r = event.getRegistry();
            r.register(TileEntityType.Builder.func_223042_a(TileIrrigation::new, (Block[])new Block[]{GardenRegistry.irrigation}).func_206865_a(null).setRegistryName("irrigation_core"));
        }
    }
}

