/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.gardentools.item;

import com.lothrazar.gardentools.GardenMod;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemPlanter
extends Item {
    private static final String FORGE_SEEDS = "forge:seeds";

    public ItemPlanter(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        super.func_195939_a(context);
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        ItemStack seeds = ItemStack.field_190927_a;
        Direction face = context.func_195992_f();
        BlockPos center = context.func_195995_a().func_177984_a();
        BlockPos blockpos = null;
        int countPlanted = 0;
        for (int dist = 0; !(dist >= GardenMod.config.getPlantingRange() || seeds.func_190926_b() && (seeds = this.getSeed(player)).func_190926_b()); ++dist) {
            blockpos = center.func_177967_a(face, dist);
            boolean didPlant = false;
            if (world.func_175623_d(blockpos.func_177977_b())) {
                if (world.func_175623_d(blockpos = blockpos.func_177977_b()) && this.tryPlantHere(world, seeds, blockpos)) {
                    center = center.func_177977_b();
                    didPlant = true;
                }
            } else if (world.func_175623_d(blockpos)) {
                if (this.tryPlantHere(world, seeds, blockpos)) {
                    didPlant = true;
                }
            } else if (world.func_175623_d((blockpos = blockpos.func_177984_a()).func_177984_a()) && this.tryPlantHere(world, seeds, blockpos)) {
                center = center.func_177984_a();
                didPlant = true;
            }
            if (!didPlant) continue;
            ++countPlanted;
            seeds.func_190918_g(1);
        }
        if (player != null && countPlanted > 0) {
            context.func_195996_i().func_222118_a(countPlanted, (LivingEntity)player, p -> p.func_213334_d(context.func_221531_n()));
        }
        return ActionResultType.SUCCESS;
    }

    private boolean tryPlantHere(World world, ItemStack seeds, BlockPos blockpos) {
        boolean didPlant = false;
        if (world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak && world.func_175623_d(blockpos) && world.func_175656_a(blockpos, Block.func_149634_a((Item)seeds.func_77973_b()).func_176223_P())) {
            didPlant = true;
        }
        return didPlant;
    }

    private ItemStack getSeed(PlayerEntity player) {
        ItemStack seeds = ItemStack.field_190927_a;
        block0: for (ItemStack s : player.field_71071_by.field_70462_a) {
            if (s.func_190926_b()) continue;
            Item item = s.func_77973_b();
            for (ResourceLocation st : item.getTags()) {
                if (!st.toString().equalsIgnoreCase(FORGE_SEEDS)) continue;
                seeds = s;
                continue block0;
            }
        }
        return seeds;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip", new Object[0]);
        t.func_211708_a(TextFormatting.GRAY);
        tooltip.add((ITextComponent)t);
    }
}

