/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.gardentools;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigManager {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec COMMON_CONFIG;
    private static ForgeConfigSpec.IntValue TILLING_RANGE;
    private static ForgeConfigSpec.IntValue IRRIG_RANGE;
    private static ForgeConfigSpec.IntValue MOISTURE;
    private static ForgeConfigSpec.IntValue PLANTER_RANGE;

    private static void initConfig() {
        COMMON_BUILDER.comment("General settings").push("gardentools");
        TILLING_RANGE = COMMON_BUILDER.comment("Range of cultivator item").defineInRange("cultivator.range", 9, 2, 32);
        PLANTER_RANGE = COMMON_BUILDER.comment("Range of planter item").defineInRange("planter.range", 9, 2, 32);
        IRRIG_RANGE = COMMON_BUILDER.comment("Watering radius of irrigation block").defineInRange("irrigator.radius", 4, 1, 16);
        MOISTURE = COMMON_BUILDER.comment("Moisture level set by cultivator").defineInRange("cultivator.moisture", 7, 0, 7);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }

    public ConfigManager(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    public int getTillingRange() {
        return (Integer)TILLING_RANGE.get();
    }

    public int getPlantingRange() {
        return (Integer)PLANTER_RANGE.get();
    }

    public int getIrrigationRange() {
        return (Integer)IRRIG_RANGE.get();
    }

    public int getMoisture() {
        return (Integer)MOISTURE.get();
    }

    static {
        ConfigManager.initConfig();
    }
}

