/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.gardentools.block;

import com.lothrazar.gardentools.GardenRegistry;
import com.lothrazar.gardentools.block.Vector3;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileMagnet
extends TileEntity
implements ITickableTileEntity {
    private static final float ITEMSPEEDFAR = 0.8f;
    private static final float ITEMSPEEDCLOSE = 0.18f;
    private static final double ENTITY_PULL_DIST = 0.4;
    private static final double ENTITY_PULL_SPEED_CUTOFF = 3.0;

    public TileMagnet() {
        super(GardenRegistry.magnetTile);
    }

    public void func_73660_a() {
        TileEntity below = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        HashSet<Item> filter = new HashSet<Item>();
        if (below != null) {
            IItemHandler hopper = (IItemHandler)below.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
            for (int i = 0; i < hopper.getSlots(); ++i) {
                ItemStack here = hopper.getStackInSlot(i);
                if (here.func_190926_b()) continue;
                filter.add(here.func_77973_b());
            }
        }
        int radius = 16;
        boolean vradius = false;
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)radius, (double)vradius, (double)radius);
        List list = this.field_145850_b.func_217357_a(ItemEntity.class, axisalignedbb);
        TileMagnet.pullEntityList((double)x + 0.5, (double)y + 0.2, (double)z + 0.5, true, list, filter);
    }

    public static int pullEntityList(double x, double y, double z, boolean towardsPos, List<ItemEntity> all, Set<Item> filter) {
        int moved = 0;
        int direction = towardsPos ? 1 : -1;
        for (ItemEntity entity : all) {
            double zDist;
            BlockPos p;
            double xDist;
            double hdist;
            if (entity == null || filter != null && !filter.contains(entity.func_92059_d().func_77973_b()) || !((hdist = Math.sqrt((xDist = Math.abs(x - (double)(p = entity.func_233580_cy_()).func_177958_n())) * xDist + (zDist = Math.abs(z - (double)p.func_177952_p())) * zDist)) > 0.4)) continue;
            float speed = hdist > 3.0 ? 0.8f : 0.18f;
            TileMagnet.setEntityMotionFromVector((Entity)entity, x, y, z, (float)direction * speed);
            ++moved;
        }
        return moved;
    }

    public static void setEntityMotionFromVector(Entity entity, double x, double y, double z, float modifier) {
        Vector3 originalPosVector = new Vector3(x, y, z);
        Vector3 entityVector = new Vector3(entity);
        Vector3 finalVector = originalPosVector.copy().subtract(entityVector);
        if (finalVector.mag() > 1.0) {
            finalVector.normalize();
        }
        double motionX = finalVector.x * (double)modifier;
        double motionY = finalVector.y * (double)modifier;
        double motionZ = finalVector.z * (double)modifier;
        entity.func_213293_j(motionX, motionY, motionZ);
    }
}

