/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.gardentools.block.rancher;

import com.lothrazar.gardentools.ConfigManager;
import com.lothrazar.gardentools.GardenMod;
import com.lothrazar.gardentools.GardenRegistry;
import com.lothrazar.gardentools.UtilFakePlayer;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.util.FakePlayer;

public class TileRancher
extends TileEntity
implements ITickableTileEntity {
    private WeakReference<FakePlayer> fakePlayer;

    public TileRancher() {
        super(GardenRegistry.rancherTile);
    }

    public WeakReference<FakePlayer> setupBeforeTrigger(ServerWorld sw, String name, UUID uuid) {
        WeakReference<FakePlayer> fakePlayer = UtilFakePlayer.initFakePlayer(sw, uuid, name);
        if (fakePlayer == null) {
            GardenMod.LOGGER.error("Fake player failed to init " + name + " " + uuid);
            return null;
        }
        ((FakePlayer)fakePlayer.get()).func_70107_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        return fakePlayer;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L) {
            return;
        }
        if (this.field_145850_b instanceof ServerWorld && this.fakePlayer == null) {
            this.fakePlayer = this.setupBeforeTrigger((ServerWorld)this.field_145850_b, "rancher", UUID.randomUUID());
        }
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        int radius = (Integer)ConfigManager.RANCHER_RANGE.get();
        AxisAlignedBB aabb = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_186662_g((double)radius).func_72321_a(0.0, (double)this.field_145850_b.func_217301_I(), 0.0);
        List itemEntities = this.field_145850_b.func_217357_a(ItemEntity.class, aabb);
        List list = this.field_145850_b.func_217357_a(AnimalEntity.class, aabb);
        for (AnimalEntity entity : list) {
            IForgeShearable sheep;
            if (entity == null || this.fakePlayer == null || this.fakePlayer.get() == null) continue;
            if (entity instanceof IForgeShearable && (sheep = (IForgeShearable)entity).isShearable(((FakePlayer)this.fakePlayer.get()).func_184614_ca(), this.field_145850_b, this.field_174879_c)) {
                ((FakePlayer)this.fakePlayer.get()).func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151097_aZ));
                List drops = sheep.onSheared((PlayerEntity)this.fakePlayer.get(), ((FakePlayer)this.fakePlayer.get()).func_184614_ca(), this.field_145850_b, this.field_174879_c, 1);
                drops.forEach(d -> entity.func_70099_a(d, 1.0f));
                ((FakePlayer)this.fakePlayer.get()).func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                break;
            }
            if (!(entity instanceof CowEntity)) continue;
            CowEntity cow = (CowEntity)entity;
            ItemEntity eiBucket = this.findExact(itemEntities, Items.field_151133_ar);
            if (eiBucket == null) continue;
            boolean doreplace = eiBucket.func_92059_d().func_190916_E() == 1;
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(Hand.MAIN_HAND, eiBucket.func_92059_d());
            ActionResultType result = cow.func_230254_b_((PlayerEntity)this.fakePlayer.get(), Hand.MAIN_HAND);
            if (result != ActionResultType.CONSUME && result != ActionResultType.SUCCESS) continue;
            if (doreplace) {
                eiBucket.func_92058_a(((FakePlayer)this.fakePlayer.get()).func_184614_ca());
            } else {
                eiBucket.func_92058_a(((FakePlayer)this.fakePlayer.get()).func_184614_ca());
                cow.func_199701_a_(new ItemStack((IItemProvider)Items.field_151117_aB));
            }
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            break;
        }
    }

    private ItemEntity findExact(List<ItemEntity> itemEntities, Item bucket) {
        for (ItemEntity ei : itemEntities) {
            if (!ei.func_70089_S() || ei.func_92059_d().func_190926_b() || ei.func_92059_d().func_77973_b() != bucket) continue;
            return ei;
        }
        return null;
    }
}

