/*
 * Decompiled with CFR 0.152.
 */
package com.github.gosvoh.config;

import com.github.gosvoh.utils.Reference;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="getexpforeverything")
public class GetExpForEverythingConfig {
    @Config.Comment(value={"How many blocks you have to destroy to get experience (default: 100)"})
    @Config.RangeInt(min=1)
    @Config.Name(value="Blocks need to destroy")
    public static int blocksNeedToDestroy = 100;
    @Config.Comment(value={"How much items you have to craft to get experience (default: 100)"})
    @Config.RangeInt(min=1)
    @Config.Name(value="Items need to craft")
    public static int itemsNeedToCraft = 100;
    @Config.Comment(value={"How much base experience you will get (default: 1)"})
    @Config.RangeInt(min=1, max=1000)
    @Config.Name(value="Base experience")
    public static int baseExpToGain = 1;
    @Config.Comment(value={"Multiplier for level step.", "For example:", "0-4 lvl you will gain 1 exp every 100 destroyed blocks", "5-9 lvl you will gain 2 exp every 100 destroyed blocks", "10-14 lvl you will gain 4 exp every 100 destroyed blocks", "etc.", "(default: 2)"})
    @Config.RangeInt(min=1, max=1000)
    @Config.Name(value="Multiplier for level step")
    public static int multiplierForLevelStep = 2;
    @Config.Comment(value={"How many levels needs to reach after multiply base exp (default: 5)"})
    @Config.RangeInt(min=1, max=1000)
    @Config.Name(value="Level step")
    public static int levelStep = 5;
    @Config.Comment(value={"Blacklisted blocks, that won't give you experience"})
    @Config.Name(value="Blacklisted blocks")
    public static String[] blackListBlocks = new String[]{Blocks.field_150398_cm.getRegistryName().toString(), Blocks.field_150395_bd.getRegistryName().toString(), Blocks.field_150329_H.getRegistryName().toString(), Blocks.field_150328_O.getRegistryName().toString(), Blocks.field_150327_N.getRegistryName().toString()};
    @Config.Comment(value={"Blacklisted items, that won't give you experience"})
    @Config.Name(value="Blacklisted items")
    public static String[] blackListCraftedItems = new String[]{Items.field_151055_y.getRegistryName().toString()};
    @Config.Comment(value={"This trigger converts your block blacklists to whitelists if true (default: false)"})
    @Config.Name(value="Is block whitelist mode")
    public static boolean isBlockWhitelistMode = false;
    @Config.Comment(value={"This trigger converts your item blacklists to whitelists if true (default: false)"})
    @Config.Name(value="Is item whitelist mode")
    public static boolean isItemWhitelistMode = false;

    @Mod.EventBusSubscriber(modid="getexpforeverything")
    private static class ConfigChangedEventHandler {
        private ConfigChangedEventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("getexpforeverything")) {
                ConfigManager.sync((String)"getexpforeverything", (Config.Type)Config.Type.INSTANCE);
                if (Reference.countOfBrokenBlocks >= blocksNeedToDestroy) {
                    Reference.countOfBrokenBlocks = 0;
                }
                if (Reference.countOfCraftedItems >= itemsNeedToCraft) {
                    Reference.countOfCraftedItems = 0;
                }
            }
        }
    }
}

