/*
 * Decompiled with CFR 0.152.
 */
package com.github.gosvoh.config;

import com.github.gosvoh.GetExpForEverything;
import com.github.gosvoh.config.GetExpForEverythingConfig;
import com.github.gosvoh.utils.Reference;
import java.util.List;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.Logger;

public final class ConfigHelper {
    private static final Logger LOGGER = GetExpForEverything.LOGGER;

    public static void bakeClient(ModConfig config) {
        String prefix = "getexpforeverything.";
        GetExpForEverythingConfig.baseExpToGain = config.getConfigData().getInt(prefix + "base_experience");
        GetExpForEverythingConfig.blocksNeedToDestroy = config.getConfigData().getInt(prefix + "blocks_need_to_destroy");
        GetExpForEverythingConfig.itemsNeedToCraft = config.getConfigData().getInt(prefix + "items_to_craft");
        GetExpForEverythingConfig.levelStep = config.getConfigData().getInt(prefix + "level_step");
        GetExpForEverythingConfig.multiplierForLevelStep = config.getConfigData().getInt(prefix + "multiplier_for_level_step");
        GetExpForEverythingConfig.blackListBlocks = (List)config.getConfigData().get(prefix + "black_list_blocks");
        GetExpForEverythingConfig.blackListCraftedItems = (List)config.getConfigData().get(prefix + "black_list_items");
        GetExpForEverythingConfig.blackListBlockTags = (List)config.getConfigData().get(prefix + "black_list_block_tags");
        GetExpForEverythingConfig.blackListItemTags = (List)config.getConfigData().get(prefix + "black_list_item_tags");
        GetExpForEverythingConfig.isBlockWhitelistMode = (Boolean)config.getConfigData().get(prefix + "is_block_whitelist_mode");
        GetExpForEverythingConfig.isItemWhitelistMode = (Boolean)config.getConfigData().get(prefix + "is_item_whitelist_mode");
        if (Reference.countOfBrokenBlocks >= GetExpForEverythingConfig.blocksNeedToDestroy) {
            Reference.countOfBrokenBlocks = 0;
        }
        if (Reference.countOfCraftedItems >= GetExpForEverythingConfig.itemsNeedToCraft) {
            Reference.countOfCraftedItems = 0;
        }
        LOGGER.debug("Get experience for everything configuration file was changed!");
    }

    private static void setValueAndSave(ModConfig modConfig, String path, Object newValue) {
        modConfig.getConfigData().set(path, newValue);
        modConfig.save();
    }
}

