/*
 * Decompiled with CFR 0.152.
 */
package io.github.franiscoder.golemsgalore.api.enums;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public enum Crack {
    NONE(1.0f),
    LOW(0.75f),
    MEDIUM(0.5f),
    HIGH(0.25f);

    private static final List<Crack> VALUES;
    private final float maxHealthFraction;

    private Crack(float maxHealthFraction) {
        this.maxHealthFraction = maxHealthFraction;
    }

    public static Crack from(float healthFraction) {
        for (Crack crack : VALUES) {
            if (!(healthFraction < crack.maxHealthFraction)) continue;
            return crack;
        }
        return NONE;
    }

    static {
        VALUES = (List)Stream.of(Crack.values()).sorted(Comparator.comparingDouble(crack -> crack.maxHealthFraction)).collect(ImmutableList.toImmutableList());
    }
}

