/*
 * Decompiled with CFR 0.152.
 */
package io.github.franiscoder.golemsgalore.client.render;

import io.github.franiscoder.golemsgalore.GolemsGalore;
import io.github.franiscoder.golemsgalore.client.render.feature.ModGolemCrackFeatureRenderer;
import io.github.franiscoder.golemsgalore.client.render.feature.ModGolemFlowerFeatureRenderer;
import io.github.franiscoder.golemsgalore.client.render.model.ModGolemEntityModel;
import io.github.franiscoder.golemsgalore.entity.LaserGolemEntity;
import java.util.Optional;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_898;
import net.minecraft.class_927;

public class LaserGolemEntityRenderer
extends class_927<LaserGolemEntity, ModGolemEntityModel<LaserGolemEntity>> {
    private static final class_2960 TEXTURE = GolemsGalore.id("textures/entity/golem/laser_golem.png");
    private static final class_2960 EXPLOSION_BEAM_TEXTURE = new class_2960("textures/entity/guardian_beam.png");
    private static final class_1921 LAYER = class_1921.method_23578((class_2960)EXPLOSION_BEAM_TEXTURE);

    public LaserGolemEntityRenderer(class_898 e) {
        super(e, new ModGolemEntityModel(), 1.0f);
        this.method_4046(new ModGolemCrackFeatureRenderer(this));
        this.method_4046(new ModGolemFlowerFeatureRenderer(this));
    }

    private static class_243 fromLerpedPosition(class_1309 entity, double yOffset, float delta) {
        double d = class_3532.method_16436((double)delta, (double)entity.field_6038, (double)entity.method_23317());
        double e = class_3532.method_16436((double)delta, (double)entity.field_5971, (double)entity.method_23318()) + yOffset;
        double f = class_3532.method_16436((double)delta, (double)entity.field_5989, (double)entity.method_23321());
        return new class_243(d, e, f);
    }

    private static void vertexLaser(class_4588 vertexConsumer, class_1159 matrix4f, class_4581 matrix3f, float f, float g, float h, int i, int j, int k, float l, float m) {
        vertexConsumer.method_22918(matrix4f, f, g, h).method_1336(i, j, k, 255).method_22913(l, m).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(matrix3f, 0.0f, 1.0f, 0.0f).method_1344();
    }

    public class_2960 getTexture(LaserGolemEntity entity) {
        return TEXTURE;
    }

    protected void setupTransforms(LaserGolemEntity ironGolemEntity, class_4587 matrixStack, float f, float g, float h) {
        super.method_4058((class_1309)ironGolemEntity, matrixStack, f, g, h);
        if ((double)ironGolemEntity.field_6225 >= 0.01) {
            float j = ironGolemEntity.field_6249 - ironGolemEntity.field_6225 * (1.0f - h) + 6.0f;
            float k = (Math.abs(j % 13.0f - 6.5f) - 3.25f) / 3.25f;
            matrixStack.method_22907(class_1160.field_20707.method_23214(6.5f * k));
        }
    }

    public boolean shouldRender(LaserGolemEntity guardianEntity, class_4604 frustum, double d, double e, double f) {
        class_1309 livingEntity;
        if (super.method_4068((class_1308)guardianEntity, frustum, d, e, f)) {
            return true;
        }
        if (guardianEntity.hasBeamTarget() && (livingEntity = guardianEntity.getBeamTarget()) != null) {
            class_243 vec3d = LaserGolemEntityRenderer.fromLerpedPosition(livingEntity, (double)livingEntity.method_17682() * 0.5, 1.0f);
            class_243 vec3d2 = LaserGolemEntityRenderer.fromLerpedPosition((class_1309)guardianEntity, guardianEntity.method_5751(), 1.0f);
            return frustum.method_23093(new class_238(vec3d2.field_1352, vec3d2.field_1351, vec3d2.field_1350, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350));
        }
        return false;
    }

    public void render(LaserGolemEntity golem, float f, float tickDelta, class_4587 matrices, class_4597 vertexConsumerProvider, int i) {
        super.method_4072((class_1308)golem, f, tickDelta, matrices, vertexConsumerProvider, i);
        Optional<class_1309> target = Optional.ofNullable(golem.getBeamTarget());
        if (target.isPresent()) {
            float progress = golem.getBeamProgress(tickDelta);
            float exactTime = (float)golem.field_6002.method_8510() + tickDelta;
            float k = exactTime * 0.5f % 1.0f;
            float eyeHeight = golem.method_5751();
            matrices.method_22903();
            matrices.method_22904(0.0, (double)eyeHeight, 0.0);
            class_243 vec3d = LaserGolemEntityRenderer.fromLerpedPosition(target.get(), (double)target.get().method_17682() * 0.5, tickDelta);
            class_243 vec3d2 = LaserGolemEntityRenderer.fromLerpedPosition((class_1309)golem, eyeHeight, tickDelta);
            class_243 vec3d3 = vec3d.method_1020(vec3d2);
            float m = (float)(vec3d3.method_1033() + 1.0);
            vec3d3 = vec3d3.method_1029();
            float n = (float)Math.acos(vec3d3.field_1351);
            float o = (float)Math.atan2(vec3d3.field_1350, vec3d3.field_1352);
            matrices.method_22907(class_1160.field_20705.method_23214((1.5707964f - o) * 57.295776f));
            matrices.method_22907(class_1160.field_20703.method_23214(n * 57.295776f));
            float q = exactTime * 0.05f * -1.5f;
            float r = progress * progress;
            int s = 64 + (int)(r * 191.0f);
            int t = 32 + (int)(r * 191.0f);
            int u = 128 - (int)(r * 64.0f);
            float x = class_3532.method_15362((float)(q + 2.3561945f)) * 0.282f;
            float y = class_3532.method_15374((float)(q + 2.3561945f)) * 0.282f;
            float z = class_3532.method_15362((float)(q + 0.7853982f)) * 0.282f;
            float aa = class_3532.method_15374((float)(q + 0.7853982f)) * 0.282f;
            float ab = class_3532.method_15362((float)(q + 3.926991f)) * 0.282f;
            float ac = class_3532.method_15374((float)(q + 3.926991f)) * 0.282f;
            float ad = class_3532.method_15362((float)(q + 5.4977875f)) * 0.282f;
            float ae = class_3532.method_15374((float)(q + 5.4977875f)) * 0.282f;
            float af = class_3532.method_15362((float)(q + (float)Math.PI)) * 0.2f;
            float ag = class_3532.method_15374((float)(q + (float)Math.PI)) * 0.2f;
            float ah = class_3532.method_15362((float)(q + 0.0f)) * 0.2f;
            float ai = class_3532.method_15374((float)(q + 0.0f)) * 0.2f;
            float aj = class_3532.method_15362((float)(q + 1.5707964f)) * 0.2f;
            float ak = class_3532.method_15374((float)(q + 1.5707964f)) * 0.2f;
            float al = class_3532.method_15362((float)(q + 4.712389f)) * 0.2f;
            float am = class_3532.method_15374((float)(q + 4.712389f)) * 0.2f;
            float aq = -1.0f + k;
            float ar = m * 2.5f + aq;
            class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(LAYER);
            class_4587.class_4665 entry = matrices.method_23760();
            class_1159 matrix4f = entry.method_23761();
            class_4581 matrix3f = entry.method_23762();
            LaserGolemEntityRenderer.vertexLaser(vertexConsumer, matrix4f, matrix3f, af, m, ag, s, t, u, 0.4999f, ar);
            LaserGolemEntityRenderer.vertexLaser(vertexConsumer, matrix4f, matrix3f, af, 0.0f, ag, s, t, u, 0.4999f, aq);
            LaserGolemEntityRenderer.vertexLaser(vertexConsumer, matrix4f, matrix3f, ah, 0.0f, ai, s, t, u, 0.0f, aq);
            LaserGolemEntityRenderer.vertexLaser(vertexConsumer, matrix4f, matrix3f, ah, m, ai, s, t, u, 0.0f, ar);
            LaserGolemEntityRenderer.vertexLaser(vertexConsumer, matrix4f, matrix3f, aj, m, ak, s, t, u, 0.4999f, ar);
            LaserGolemEntityRenderer.vertexLaser(vertexConsumer, matrix4f, matrix3f, aj, 0.0f, ak, s, t, u, 0.4999f, aq);
            LaserGolemEntityRenderer.vertexLaser(vertexConsumer, matrix4f, matrix3f, al, 0.0f, am, s, t, u, 0.0f, aq);
            LaserGolemEntityRenderer.vertexLaser(vertexConsumer, matrix4f, matrix3f, al, m, am, s, t, u, 0.0f, ar);
            float as = 0.0f;
            if (golem.field_6012 % 2 == 0) {
                as = 0.5f;
            }
            LaserGolemEntityRenderer.vertexLaser(vertexConsumer, matrix4f, matrix3f, x, m, y, s, t, u, 0.5f, as + 0.5f);
            LaserGolemEntityRenderer.vertexLaser(vertexConsumer, matrix4f, matrix3f, z, m, aa, s, t, u, 1.0f, as + 0.5f);
            LaserGolemEntityRenderer.vertexLaser(vertexConsumer, matrix4f, matrix3f, ad, m, ae, s, t, u, 1.0f, as);
            LaserGolemEntityRenderer.vertexLaser(vertexConsumer, matrix4f, matrix3f, ab, m, ac, s, t, u, 0.5f, as);
            matrices.method_22909();
        }
    }
}

